/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;

public abstract class ResourceBundle {
    protected ResourceBundle parent;
    private static Hashtable resource_cache = new Hashtable();

    public Locale getLocale() {
        return null;
    }

    public final String getString(String string) {
        return (String)this.getObject(string);
    }

    public final String[] getStringArray(String string) {
        return (String[])this.getObject(string);
    }

    public final Object getObject(String string) {
        try {
            return this.handleGetObject(string);
        }
        catch (MissingResourceException missingResourceException) {
            if (this.parent != null) {
                return this.parent.getObject(string);
            }
            throw missingResourceException;
        }
    }

    public static final ResourceBundle getBundle(String string) {
        return ResourceBundle.getBundle(string, Locale.getDefault());
    }

    private static final ResourceBundle trySomeGetBundle(String string, String string2, ClassLoader classLoader) {
        ResourceBundle resourceBundle = null;
        ResourceBundle resourceBundle2 = null;
        while (true) {
            try {
                Class clazz = Class.forName(string, true, classLoader);
                ResourceBundle resourceBundle3 = null;
                try {
                    resourceBundle3 = (ResourceBundle)clazz.newInstance();
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InstantiationException instantiationException) {
                    // empty catch block
                }
                if (resourceBundle3 != null) {
                    if (resourceBundle2 == null) {
                        resourceBundle2 = resourceBundle3;
                    }
                    if (resourceBundle != null) {
                        resourceBundle.setParent(resourceBundle3);
                    }
                    resourceBundle = resourceBundle3;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            InputStream inputStream = classLoader.getResourceAsStream(string.replace('.', '/') + ".properties");
            if (inputStream != null) {
                try {
                    return new PropertyResourceBundle(inputStream);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (string.equals(string2)) {
                return resourceBundle2;
            }
            int n = string.lastIndexOf(95);
            if (n == -1) {
                return resourceBundle2;
            }
            string = string.substring(0, n);
        }
    }

    private static final synchronized ResourceBundle partialGetBundle(String string, Locale locale, boolean bl, ClassLoader classLoader) {
        String string2 = string + "_" + locale.toString();
        Object object = resource_cache.get(string2);
        if (object != null) {
            return (ResourceBundle)object;
        }
        String string3 = string + (bl ? "_" + locale.getLanguage() : "");
        ResourceBundle resourceBundle = ResourceBundle.trySomeGetBundle(string2, string3, classLoader);
        if (resourceBundle != null) {
            resource_cache.put(string2, resourceBundle);
        }
        return resourceBundle;
    }

    public static final ResourceBundle getBundle(String string, Locale locale) {
        return ResourceBundle.getBundle(string, locale, ClassLoader.getSystemClassLoader());
    }

    public static final ResourceBundle getBundle(String string, Locale locale, ClassLoader classLoader) {
        if (string == null) {
            throw new NullPointerException();
        }
        ResourceBundle resourceBundle = ResourceBundle.partialGetBundle(string, locale, false, classLoader);
        if (resourceBundle != null) {
            return resourceBundle;
        }
        if (!locale.equals(Locale.getDefault()) && (resourceBundle = ResourceBundle.partialGetBundle(string, Locale.getDefault(), true, classLoader)) != null) {
            return resourceBundle;
        }
        throw new MissingResourceException("can't load bundle", string, "bundle");
    }

    protected void setParent(ResourceBundle resourceBundle) {
        this.parent = resourceBundle;
    }

    protected abstract Object handleGetObject(String var1) throws MissingResourceException;

    public abstract Enumeration getKeys();
}

