/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public final class PropertyPermission
extends BasicPermission {
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("action", PropertyPermission.class$("java.lang.String"))};
    private static final long serialVersionUID = 885438825399942851L;
    private static final int READ = 1;
    private static final int WRITE = 2;
    private transient int actions;
    private static final String[] actionStrings = new String[]{"", "read", "write", "read,write"};

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public PropertyPermission(String string, String string2) {
        super(string);
        this.setActions(string2.toLowerCase());
    }

    private void setActions(String string) {
        this.actions = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            if ("read".equals(string2)) {
                this.actions |= 1;
                continue;
            }
            if ("write".equals(string2)) {
                this.actions |= 2;
                continue;
            }
            throw new IllegalArgumentException("illegal action " + string2);
        }
    }

    public boolean implies(Permission permission) {
        if (!(permission instanceof PropertyPermission)) {
            return false;
        }
        PropertyPermission propertyPermission = (PropertyPermission)permission;
        if ((propertyPermission.actions & ~this.actions) != 0) {
            return false;
        }
        return super.implies(permission);
    }

    public String getActions() {
        return actionStrings[this.actions];
    }

    public boolean equals(Object object) {
        if (!(object instanceof PropertyPermission)) {
            return false;
        }
        PropertyPermission propertyPermission = (PropertyPermission)object;
        return this.actions == propertyPermission.actions && super.equals(propertyPermission);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        this.setActions((String)getField.get("actions", null));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("actions", this.getActions());
        objectOutputStream.writeFields();
    }

    public PermissionCollection newPermissionCollection() {
        return new PermissionCollection(this){
            private /* synthetic */ PropertyPermission this$0;
            Hashtable permissions;
            int allActions;
            {
                this.this$0 = propertyPermission;
                this.finit$();
            }

            private /* synthetic */ void finit$() {
                this.permissions = new Hashtable();
                this.allActions = 0;
            }

            public void add(Permission permission) {
                if (this.isReadOnly()) {
                    throw new IllegalStateException("readonly");
                }
                PropertyPermission propertyPermission = (PropertyPermission)permission;
                String string = propertyPermission.getName();
                if (string.equals("*")) {
                    this.allActions |= propertyPermission.actions;
                }
                this.permissions.put(string, propertyPermission);
            }

            public boolean implies(Permission permission) {
                if (!(permission instanceof PropertyPermission)) {
                    return false;
                }
                PropertyPermission propertyPermission = (PropertyPermission)permission;
                if ((propertyPermission.actions & ~this.allActions) == 0) {
                    return true;
                }
                String string = propertyPermission.getName();
                if (string.equals("*")) {
                    return false;
                }
                int n = string.length();
                if (string.endsWith("*")) {
                    n -= 2;
                }
                PropertyPermission propertyPermission2;
                while ((propertyPermission2 = (PropertyPermission)this.permissions.get(string)) == null || (propertyPermission.actions & ~propertyPermission2.actions) != 0) {
                    if ((n = string.lastIndexOf(46, n)) < 0) {
                        return false;
                    }
                    string = string.substring(0, n + 1) + '*';
                }
                return true;
            }

            public Enumeration elements() {
                return this.permissions.elements();
            }
        };
    }
}

