/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Observer;
import java.util.Vector;

public class Observable {
    private boolean changed = false;
    private Vector observerVec = new Vector();

    public synchronized void addObserver(Observer observer) {
        if (!this.observerVec.contains(observer)) {
            this.observerVec.addElement(observer);
        }
    }

    protected synchronized void clearChanged() {
        this.changed = false;
    }

    public synchronized int countObservers() {
        return this.observerVec.size();
    }

    public synchronized void deleteObserver(Observer observer) {
        this.observerVec.removeElement(observer);
    }

    public synchronized void deleteObservers() {
        this.observerVec.removeAllElements();
    }

    public synchronized boolean hasChanged() {
        return this.changed;
    }

    public void notifyObservers() {
        this.notifyObservers(null);
    }

    public void notifyObservers(Object object) {
        if (this.changed) {
            int n = this.observerVec.size();
            for (int i = 0; i < n; ++i) {
                ((Observer)this.observerVec.elementAt(i)).update(this, object);
            }
            this.changed = false;
        }
    }

    protected synchronized void setChanged() {
        this.changed = true;
    }
}

