/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractSequentialList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class LinkedList
extends AbstractSequentialList
implements List,
Cloneable,
Serializable {
    static final long serialVersionUID = 876323262645176354L;
    transient Entry first;
    transient Entry last;
    transient int size;

    private /* synthetic */ void finit$() {
        this.size = 0;
    }

    private Entry getEntry(int n) {
        Entry entry;
        if (n < this.size / 2) {
            entry = this.first;
            while (n-- > 0) {
                entry = entry.next;
            }
        } else {
            entry = this.last;
            while (++n < this.size) {
                entry = entry.previous;
            }
        }
        return entry;
    }

    private void removeEntry(Entry entry) {
        if (this.size == 1) {
            this.last = null;
            this.first = null;
        } else if (entry == this.first) {
            this.first = entry.next;
            entry.next.previous = null;
        } else if (entry == this.last) {
            this.last = entry.previous;
            entry.previous.next = null;
        } else {
            entry.next.previous = entry.previous;
            entry.previous.next = entry.next;
        }
        this.size += -1;
    }

    public LinkedList() {
        this.finit$();
    }

    public LinkedList(Collection collection) {
        this.finit$();
        this.addAll(collection);
    }

    public Object getFirst() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.first.data;
    }

    public Object getLast() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.last.data;
    }

    public Object removeFirst() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        this.size += -1;
        ++this.modCount;
        Object object = this.first.data;
        if (this.first.next != null) {
            this.first.next.previous = null;
        } else {
            this.last = null;
        }
        this.first = this.first.next;
        return object;
    }

    public Object removeLast() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        this.size += -1;
        ++this.modCount;
        Object object = this.last.data;
        if (this.last.previous != null) {
            this.last.previous.next = null;
        } else {
            this.first = null;
        }
        this.last = this.last.previous;
        return object;
    }

    public void addFirst(Object object) {
        ++this.modCount;
        Entry entry = new Entry(object);
        if (this.size == 0) {
            this.first = this.last = entry;
        } else {
            entry.next = this.first;
            this.first.previous = entry;
            this.first = entry;
        }
        ++this.size;
    }

    public void addLast(Object object) {
        ++this.modCount;
        this.addLastEntry(new Entry(object));
    }

    private void addLastEntry(Entry entry) {
        if (this.size == 0) {
            this.first = this.last = entry;
        } else {
            entry.previous = this.last;
            this.last.next = entry;
            this.last = entry;
        }
        ++this.size;
    }

    public boolean contains(Object object) {
        Entry entry = this.first;
        while (entry != null) {
            if (entry.data == null ? object == null : object.equals(entry.data)) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public int size() {
        return this.size;
    }

    public boolean add(Object object) {
        ++this.modCount;
        this.addLastEntry(new Entry(object));
        return true;
    }

    public boolean remove(Object object) {
        ++this.modCount;
        Entry entry = this.first;
        while (entry != null) {
            if (entry.data == null ? object == null : object.equals(entry.data)) {
                this.removeEntry(entry);
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public boolean addAll(Collection collection) {
        return this.addAll(this.size, collection);
    }

    public boolean addAll(int n, Collection collection) {
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size:" + this.size);
        }
        ++this.modCount;
        int n2 = collection.size();
        if (n2 == 0) {
            return false;
        }
        Iterator iterator = collection.iterator();
        Entry entry = null;
        Entry entry2 = null;
        if (n != this.size) {
            entry = this.getEntry(n);
            entry2 = entry.previous;
        } else {
            entry2 = this.last;
        }
        Entry entry3 = new Entry(iterator.next());
        entry3.previous = entry2;
        Entry entry4 = entry3;
        Entry entry5 = entry3;
        for (int i = 1; i < n2; ++i) {
            entry3 = new Entry(iterator.next());
            entry3.previous = entry4;
            entry4.next = entry3;
            entry4 = entry3;
        }
        entry4.next = entry;
        if (entry != null) {
            entry.previous = entry3;
        } else {
            this.last = entry3;
        }
        if (entry2 != null) {
            entry2.next = entry5;
        } else {
            this.first = entry5;
        }
        this.size += n2;
        return true;
    }

    public void clear() {
        ++this.modCount;
        this.first = null;
        this.last = null;
        this.size = 0;
    }

    public Object get(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size:" + this.size);
        }
        Entry entry = this.getEntry(n);
        return entry.data;
    }

    public Object set(int n, Object object) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size:" + this.size);
        }
        Entry entry = this.getEntry(n);
        Object object2 = entry.data;
        entry.data = object;
        return object2;
    }

    public void add(int n, Object object) {
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size:" + this.size);
        }
        ++this.modCount;
        this.addEntry(n, new Entry(object));
    }

    private void addEntry(int n, Entry entry) {
        if (n < this.size) {
            Entry entry2;
            entry.next = entry2 = this.getEntry(n);
            entry.previous = entry2.previous;
            if (entry2.previous == null) {
                this.first = entry;
            } else {
                entry2.previous.next = entry;
            }
            entry2.previous = entry;
            ++this.size;
        } else {
            this.addLastEntry(entry);
        }
    }

    public Object remove(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size:" + this.size);
        }
        ++this.modCount;
        Entry entry = this.getEntry(n);
        this.removeEntry(entry);
        return entry.data;
    }

    public int indexOf(Object object) {
        int n = 0;
        Entry entry = this.first;
        while (entry != null) {
            if (entry.data == null ? object == null : object.equals(entry.data)) {
                return n;
            }
            ++n;
            entry = entry.next;
        }
        return -1;
    }

    public int lastIndexOf(Object object) {
        int n = this.size - 1;
        Entry entry = this.last;
        while (entry != null) {
            if (entry.data == null ? object == null : object.equals(entry.data)) {
                return n;
            }
            --n;
            entry = entry.previous;
        }
        return -1;
    }

    public ListIterator listIterator(int n) {
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size:" + this.size);
        }
        return new LinkedListItr(this, n);
    }

    public Object clone() {
        LinkedList linkedList = null;
        try {
            linkedList = (LinkedList)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        linkedList.size = 0;
        linkedList.addAll(this);
        return linkedList;
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.size];
        Entry entry = this.first;
        for (int i = 0; i < this.size; ++i) {
            objectArray[i] = entry.data;
            entry = entry.next;
        }
        return objectArray;
    }

    public Object[] toArray(Object[] objectArray) {
        if (objectArray.length < this.size) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.size);
        } else if (objectArray.length > this.size) {
            objectArray[this.size] = null;
        }
        Entry entry = this.first;
        for (int i = 0; i < this.size; ++i) {
            objectArray[i] = entry.data;
            entry = entry.next;
        }
        return objectArray;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.size);
        Iterator iterator = this.iterator();
        for (int i = 0; i < this.size; ++i) {
            objectOutputStream.writeObject(iterator.next());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        int n = objectInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            this.addLastEntry(new Entry(objectInputStream.readObject()));
        }
    }

    class LinkedListItr
    implements ListIterator {
        private /* synthetic */ LinkedList this$0;
        int knownMod;
        Entry next;
        Entry previous;
        Entry lastReturned;
        int position;

        LinkedListItr(LinkedList linkedList, int n) {
            this.this$0 = linkedList;
            if (n == linkedList.size) {
                this.next = null;
                this.previous = linkedList.last;
            } else {
                this.next = linkedList.getEntry(n);
                this.previous = this.next.previous;
            }
            this.position = n;
            this.knownMod = linkedList.modCount;
        }

        private void checkMod() {
            if (this.knownMod != this.this$0.modCount) {
                throw new ConcurrentModificationException();
            }
        }

        public int nextIndex() {
            this.checkMod();
            return this.position;
        }

        public int previousIndex() {
            this.checkMod();
            return this.position - 1;
        }

        public boolean hasNext() {
            this.checkMod();
            return this.next != null;
        }

        public boolean hasPrevious() {
            this.checkMod();
            return this.previous != null;
        }

        public Object next() {
            this.checkMod();
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            ++this.position;
            this.lastReturned = this.previous = this.next;
            this.next = this.lastReturned.next;
            return this.lastReturned.data;
        }

        public Object previous() {
            this.checkMod();
            if (this.previous == null) {
                throw new NoSuchElementException();
            }
            this.position += -1;
            this.lastReturned = this.next = this.previous;
            this.previous = this.lastReturned.previous;
            return this.lastReturned.data;
        }

        public void remove() {
            this.checkMod();
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (this.lastReturned == this.previous) {
                this.position += -1;
            }
            this.next = this.lastReturned.next;
            this.previous = this.lastReturned.previous;
            ++this.this$0.modCount;
            ++this.knownMod;
            this.this$0.removeEntry(this.lastReturned);
            this.lastReturned = null;
        }

        public void add(Object object) {
            this.checkMod();
            ++this.this$0.modCount;
            ++this.knownMod;
            Entry entry = new Entry(object);
            entry.previous = this.previous;
            entry.next = this.next;
            if (this.previous != null) {
                this.previous.next = entry;
            } else {
                this.this$0.first = entry;
            }
            if (this.next != null) {
                this.next.previous = entry;
                this.next = this.next.next;
            } else {
                this.this$0.last = entry;
            }
            this.previous = entry;
            ++this.this$0.size;
            ++this.position;
            this.lastReturned = null;
        }

        public void set(Object object) {
            this.checkMod();
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            this.lastReturned.data = object;
        }
    }

    static class Entry {
        Object data;
        Entry next;
        Entry previous;

        Entry(Object object) {
            this.data = object;
        }
    }
}

