/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.BasicMapEntry;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class Hashtable
extends Dictionary
implements Map,
Cloneable,
Serializable {
    private static final int DEFAULT_CAPACITY = 11;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final long serialVersionUID = 1421746759512286392L;
    int threshold;
    float loadFactor;
    transient Entry[] buckets;
    transient int modCount;
    transient int size;

    private /* synthetic */ void finit$() {
        this.loadFactor = 0.75f;
    }

    public Hashtable() {
        this(11, 0.75f);
    }

    public Hashtable(Map map) {
        this.finit$();
        int n = Math.max(map.size() * 2, 11);
        this.buckets = new Entry[n];
        this.threshold = (int)((float)n * this.loadFactor);
        this.putAll(map);
    }

    public Hashtable(int n) {
        this(n, 0.75f);
    }

    public Hashtable(int n, float f) {
        this.finit$();
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Initial Capacity: " + n);
        }
        if (f <= 0.0f) {
            throw new IllegalArgumentException("Illegal Load Factor: " + f);
        }
        if (n == 0) {
            n = 1;
        }
        this.buckets = new Entry[n];
        this.loadFactor = f;
        this.threshold = (int)((float)n * f);
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public synchronized Enumeration keys() {
        return new Enumerator(this, 0);
    }

    public synchronized Enumeration elements() {
        return new Enumerator(this, 1);
    }

    public synchronized boolean contains(Object object) {
        for (int i = 0; i < this.buckets.length; ++i) {
            Entry entry = this.buckets[i];
            while (entry != null) {
                if (object.equals(entry.value)) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    public boolean containsValue(Object object) {
        return this.contains(object);
    }

    public synchronized boolean containsKey(Object object) {
        int n = this.hash(object);
        Entry entry = this.buckets[n];
        while (entry != null) {
            if (object.equals(entry.key)) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public synchronized Object get(Object object) {
        int n = this.hash(object);
        Entry entry = this.buckets[n];
        while (entry != null) {
            if (object.equals(entry.key)) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    public synchronized Object put(Object object, Object object2) {
        ++this.modCount;
        int n = this.hash(object);
        Entry entry = this.buckets[n];
        if (object2 == null) {
            throw new NullPointerException();
        }
        while (entry != null) {
            if (object.equals(entry.key)) {
                Object object3 = entry.value;
                entry.value = object2;
                return object3;
            }
            entry = entry.next;
        }
        if (++this.size > this.threshold) {
            this.rehash();
            n = this.hash(object);
        }
        entry = new Entry(object, object2);
        entry.next = this.buckets[n];
        this.buckets[n] = entry;
        return null;
    }

    public synchronized Object remove(Object object) {
        ++this.modCount;
        int n = this.hash(object);
        Entry entry = this.buckets[n];
        Entry entry2 = null;
        while (entry != null) {
            if (object.equals(entry.key)) {
                if (entry2 == null) {
                    this.buckets[n] = entry.next;
                } else {
                    entry2.next = entry.next;
                }
                this.size += -1;
                return entry.value;
            }
            entry2 = entry;
            entry = entry.next;
        }
        return null;
    }

    public synchronized void putAll(Map map) {
        int n = map.size();
        Iterator iterator = map.entrySet().iterator();
        for (int i = 0; i < n; ++i) {
            Map.Entry entry = (Map.Entry)iterator.next();
            if (entry instanceof BasicMapEntry) {
                BasicMapEntry basicMapEntry = (BasicMapEntry)entry;
                this.put(basicMapEntry.key, basicMapEntry.value);
                continue;
            }
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public synchronized void clear() {
        ++this.modCount;
        for (int i = 0; i < this.buckets.length; ++i) {
            this.buckets[i] = null;
        }
        this.size = 0;
    }

    public synchronized Object clone() {
        Hashtable hashtable = null;
        try {
            hashtable = (Hashtable)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        hashtable.buckets = new Entry[this.buckets.length];
        for (int i = 0; i < this.buckets.length; ++i) {
            Entry entry = this.buckets[i];
            Entry entry2 = null;
            while (entry != null) {
                if (entry2 == null) {
                    hashtable.buckets[i] = new Entry(entry.key, entry.value);
                    entry2 = hashtable.buckets[i];
                } else {
                    entry2 = entry2.next = new Entry(entry.key, entry.value);
                }
                entry = entry.next;
            }
        }
        return hashtable;
    }

    public synchronized String toString() {
        Iterator iterator = this.entrySet().iterator();
        StringBuffer stringBuffer = new StringBuffer("{");
        for (int i = 0; i < this.size; ++i) {
            stringBuffer.append(iterator.next());
            if (i >= this.size - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public Set keySet() {
        AbstractSet abstractSet = new AbstractSet(this){
            private /* synthetic */ Hashtable this$0;
            {
                this.this$0 = hashtable;
            }

            public int size() {
                return this.this$0.size;
            }

            public Iterator iterator() {
                return new HashIterator(this.this$0, 0);
            }

            public void clear() {
                this.this$0.clear();
            }

            public boolean contains(Object object) {
                return this.this$0.containsKey(object);
            }

            public boolean remove(Object object) {
                return this.this$0.remove(object) != null;
            }
        };
        return Collections.synchronizedSet(abstractSet);
    }

    public Collection values() {
        AbstractCollection abstractCollection = new AbstractCollection(this){
            private /* synthetic */ Hashtable this$0;
            {
                this.this$0 = hashtable;
            }

            public int size() {
                return this.this$0.size;
            }

            public Iterator iterator() {
                return new HashIterator(this.this$0, 1);
            }

            public void clear() {
                this.this$0.clear();
            }
        };
        return Collections.synchronizedCollection(abstractCollection);
    }

    public Set entrySet() {
        AbstractSet abstractSet = new AbstractSet(this){
            private /* synthetic */ Hashtable this$0;
            {
                this.this$0 = hashtable;
            }

            public int size() {
                return this.this$0.size;
            }

            public Iterator iterator() {
                return new HashIterator(this.this$0, 2);
            }

            public void clear() {
                this.this$0.clear();
            }

            public boolean contains(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                Entry entry2 = this.this$0.getEntry(entry);
                return entry2 != null;
            }

            public boolean remove(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                Entry entry2 = this.this$0.getEntry(entry);
                if (entry2 != null) {
                    this.this$0.remove(entry2.key);
                    return true;
                }
                return false;
            }
        };
        return Collections.synchronizedSet(abstractSet);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        Set set = map.entrySet();
        Iterator iterator = this.entrySet().iterator();
        if (map.size() != this.size) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (set.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        Iterator iterator = this.entrySet().iterator();
        for (int i = 0; i < this.size; ++i) {
            n += iterator.next().hashCode();
        }
        return n;
    }

    private int hash(Object object) {
        return Math.abs(object.hashCode() % this.buckets.length);
    }

    private Entry getEntry(Map.Entry entry) {
        int n = this.hash(entry.getKey());
        Entry entry2 = this.buckets[n];
        while (entry2 != null) {
            if (entry2.equals(entry)) {
                return entry2;
            }
            entry2 = entry2.next;
        }
        return null;
    }

    protected void rehash() {
        Entry[] entryArray = this.buckets;
        int n = this.buckets.length * 2 + 1;
        this.threshold = (int)((float)n * this.loadFactor);
        this.buckets = new Entry[n];
        for (int i = 0; i < entryArray.length; ++i) {
            Entry entry = entryArray[i];
            while (entry != null) {
                int n2 = this.hash(entry.key);
                Entry entry2 = this.buckets[n2];
                if (entry2 != null) {
                    while (entry2.next != null) {
                        entry2 = entry2.next;
                    }
                    entry2.next = entry;
                } else {
                    this.buckets[n2] = entry;
                }
                Entry entry3 = entry.next;
                entry.next = null;
                entry = entry3;
            }
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.buckets.length);
        objectOutputStream.writeInt(this.size);
        Iterator iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            objectOutputStream.writeObject(entry.getKey());
            objectOutputStream.writeObject(entry.getValue());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        int n2 = objectInputStream.readInt();
        this.size = 0;
        this.modCount = 0;
        this.buckets = new Entry[n];
        for (int i = 0; i < n2; ++i) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.put(object, object2);
        }
    }

    class Enumerator
    implements Enumeration {
        private /* synthetic */ Hashtable this$0;
        static final int KEYS = 0;
        static final int VALUES = 1;
        int type;
        int count;
        int idx;
        Entry last;

        Enumerator(Hashtable hashtable, int n) {
            this.this$0 = hashtable;
            this.type = n;
            this.count = 0;
            this.idx = hashtable.buckets.length;
        }

        public boolean hasMoreElements() {
            return this.count < this.this$0.size;
        }

        public Object nextElement() {
            if (this.count >= this.this$0.size) {
                throw new NoSuchElementException();
            }
            ++this.count;
            Entry entry = null;
            if (this.last != null) {
                entry = this.last.next;
            }
            while (entry == null) {
                entry = this.this$0.buckets[this.idx += -1];
            }
            this.last = entry;
            if (this.type == 1) {
                return entry.value;
            }
            return entry.key;
        }
    }

    class HashIterator
    implements Iterator {
        private /* synthetic */ Hashtable this$0;
        static final int KEYS = 0;
        static final int VALUES = 1;
        static final int ENTRIES = 2;
        int type;
        int knownMod;
        int count;
        int idx;
        Entry last;
        Entry next;

        HashIterator(Hashtable hashtable, int n) {
            this.this$0 = hashtable;
            this.type = n;
            this.knownMod = hashtable.modCount;
            this.count = 0;
            this.idx = hashtable.buckets.length;
        }

        public boolean hasNext() {
            if (this.knownMod != this.this$0.modCount) {
                throw new ConcurrentModificationException();
            }
            return this.count < this.this$0.size;
        }

        public Object next() {
            if (this.knownMod != this.this$0.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.count == this.this$0.size) {
                throw new NoSuchElementException();
            }
            ++this.count;
            Entry entry = null;
            if (this.next != null) {
                entry = this.next;
            }
            while (entry == null) {
                entry = this.this$0.buckets[this.idx += -1];
            }
            this.next = entry.next;
            this.last = entry;
            if (this.type == 1) {
                return entry.value;
            }
            if (this.type == 0) {
                return entry.key;
            }
            return entry;
        }

        public void remove() {
            if (this.knownMod != this.this$0.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.last == null) {
                throw new IllegalStateException();
            }
            this.this$0.remove(this.last.key);
            ++this.knownMod;
            this.count += -1;
            this.last = null;
        }
    }

    static class Entry
    extends BasicMapEntry {
        Entry next;

        Entry(Object object, Object object2) {
            super(object, object2);
        }

        public final Object setValue(Object object) {
            if (object == null) {
                throw new NullPointerException();
            }
            return super.setValue(object);
        }
    }
}

