/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.BasicMapEntry;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class HashMap
extends AbstractMap
implements Map,
Cloneable,
Serializable {
    private static final int DEFAULT_CAPACITY = 11;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final long serialVersionUID = 362498820763181265L;
    int threshold;
    float loadFactor;
    transient Entry[] buckets;
    transient int modCount;
    transient int size;

    private /* synthetic */ void finit$() {
        this.loadFactor = 0.75f;
    }

    public HashMap() {
        this(11, 0.75f);
    }

    public HashMap(Map map) {
        this.finit$();
        int n = Math.max(map.size() * 2, 11);
        this.buckets = new Entry[n];
        this.threshold = (int)((float)n * this.loadFactor);
        this.putAll(map);
    }

    public HashMap(int n) {
        this(n, 0.75f);
    }

    public HashMap(int n, float f) {
        this.finit$();
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Initial Capacity: " + n);
        }
        if (f <= 0.0f) {
            throw new IllegalArgumentException("Illegal Load Factor: " + f);
        }
        if (n == 0) {
            n = 1;
        }
        this.buckets = new Entry[n];
        this.loadFactor = f;
        this.threshold = (int)((float)n * f);
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean containsValue(Object object) {
        for (int i = 0; i < this.buckets.length; ++i) {
            Entry entry = this.buckets[i];
            while (entry != null) {
                if (object == null ? entry.value == null : object.equals(entry.value)) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    public boolean containsKey(Object object) {
        int n = this.hash(object);
        Entry entry = this.buckets[n];
        while (entry != null) {
            if (object == null ? entry.key == null : object.equals(entry.key)) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public Object get(Object object) {
        int n = this.hash(object);
        Entry entry = this.buckets[n];
        while (entry != null) {
            if (object == null ? entry.key == null : object.equals(entry.key)) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    public Object put(Object object, Object object2) {
        ++this.modCount;
        int n = this.hash(object);
        Entry entry = this.buckets[n];
        while (entry != null) {
            if (object == null ? entry.key == null : object.equals(entry.key)) {
                Object object3 = entry.value;
                entry.value = object2;
                return object3;
            }
            entry = entry.next;
        }
        if (++this.size > this.threshold) {
            this.rehash();
            n = this.hash(object);
        }
        entry = new Entry(object, object2);
        entry.next = this.buckets[n];
        this.buckets[n] = entry;
        return null;
    }

    public Object remove(Object object) {
        ++this.modCount;
        int n = this.hash(object);
        Entry entry = this.buckets[n];
        Entry entry2 = null;
        while (entry != null) {
            if (object == null ? entry.key == null : object.equals(entry.key)) {
                if (entry2 == null) {
                    this.buckets[n] = entry.next;
                } else {
                    entry2.next = entry.next;
                }
                this.size += -1;
                return entry.value;
            }
            entry2 = entry;
            entry = entry.next;
        }
        return null;
    }

    public void putAll(Map map) {
        int n = map.size();
        Iterator iterator = map.entrySet().iterator();
        for (int i = 0; i < n; ++i) {
            Map.Entry entry = (Map.Entry)iterator.next();
            if (entry instanceof BasicMapEntry) {
                BasicMapEntry basicMapEntry = (BasicMapEntry)entry;
                this.put(basicMapEntry.key, basicMapEntry.value);
                continue;
            }
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void clear() {
        ++this.modCount;
        for (int i = 0; i < this.buckets.length; ++i) {
            this.buckets[i] = null;
        }
        this.size = 0;
    }

    public Object clone() {
        HashMap hashMap = null;
        try {
            hashMap = (HashMap)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        hashMap.buckets = new Entry[this.buckets.length];
        for (int i = 0; i < this.buckets.length; ++i) {
            Entry entry = this.buckets[i];
            Entry entry2 = null;
            while (entry != null) {
                if (entry2 == null) {
                    hashMap.buckets[i] = new Entry(entry.key, entry.value);
                    entry2 = hashMap.buckets[i];
                } else {
                    entry2 = entry2.next = new Entry(entry.key, entry.value);
                }
                entry = entry.next;
            }
        }
        return hashMap;
    }

    public Set keySet() {
        return new AbstractSet(this){
            private /* synthetic */ HashMap this$0;
            {
                this.this$0 = hashMap;
            }

            public int size() {
                return this.this$0.size;
            }

            public Iterator iterator() {
                return new HashIterator(this.this$0, 0);
            }

            public void clear() {
                this.this$0.clear();
            }

            public boolean contains(Object object) {
                return this.this$0.containsKey(object);
            }

            public boolean remove(Object object) {
                int n = this.this$0.size;
                this.this$0.remove(object);
                return n != this.this$0.size;
            }
        };
    }

    public Collection values() {
        return new AbstractCollection(this){
            private /* synthetic */ HashMap this$0;
            {
                this.this$0 = hashMap;
            }

            public int size() {
                return this.this$0.size;
            }

            public Iterator iterator() {
                return new HashIterator(this.this$0, 1);
            }

            public void clear() {
                this.this$0.clear();
            }
        };
    }

    public Set entrySet() {
        return new AbstractSet(this){
            private /* synthetic */ HashMap this$0;
            {
                this.this$0 = hashMap;
            }

            public int size() {
                return this.this$0.size;
            }

            public Iterator iterator() {
                return new HashIterator(this.this$0, 2);
            }

            public void clear() {
                this.this$0.clear();
            }

            public boolean contains(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                Entry entry2 = this.this$0.getEntry(entry);
                return entry2 != null;
            }

            public boolean remove(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                Entry entry2 = this.this$0.getEntry(entry);
                if (entry2 != null) {
                    this.this$0.remove(entry2.key);
                    return true;
                }
                return false;
            }
        };
    }

    private int hash(Object object) {
        if (object == null) {
            return 0;
        }
        return Math.abs(object.hashCode() % this.buckets.length);
    }

    private Entry getEntry(Map.Entry entry) {
        int n = this.hash(entry.getKey());
        Entry entry2 = this.buckets[n];
        while (entry2 != null) {
            if (entry2.equals(entry)) {
                return entry2;
            }
            entry2 = entry2.next;
        }
        return null;
    }

    private void rehash() {
        Entry[] entryArray = this.buckets;
        int n = this.buckets.length * 2 + 1;
        this.threshold = (int)((float)n * this.loadFactor);
        this.buckets = new Entry[n];
        for (int i = 0; i < entryArray.length; ++i) {
            Entry entry = entryArray[i];
            while (entry != null) {
                int n2 = this.hash(entry.key);
                Entry entry2 = this.buckets[n2];
                if (entry2 != null) {
                    while (entry2.next != null) {
                        entry2 = entry2.next;
                    }
                    entry2.next = entry;
                } else {
                    this.buckets[n2] = entry;
                }
                Entry entry3 = entry.next;
                entry.next = null;
                entry = entry3;
            }
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.buckets.length);
        objectOutputStream.writeInt(this.size);
        Iterator iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            objectOutputStream.writeObject(entry.getKey());
            objectOutputStream.writeObject(entry.getValue());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        int n2 = objectInputStream.readInt();
        this.size = 0;
        this.modCount = 0;
        this.buckets = new Entry[n];
        for (int i = 0; i < n2; ++i) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.put(object, object2);
        }
    }

    class HashIterator
    implements Iterator {
        private /* synthetic */ HashMap this$0;
        static final int KEYS = 0;
        static final int VALUES = 1;
        static final int ENTRIES = 2;
        int type;
        int knownMod;
        int count;
        int idx;
        Entry last;
        Entry next;

        HashIterator(HashMap hashMap, int n) {
            this.this$0 = hashMap;
            this.type = n;
            this.knownMod = hashMap.modCount;
            this.count = 0;
            this.idx = hashMap.buckets.length;
        }

        public boolean hasNext() {
            if (this.knownMod != this.this$0.modCount) {
                throw new ConcurrentModificationException();
            }
            return this.count < this.this$0.size;
        }

        public Object next() {
            if (this.knownMod != this.this$0.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.count == this.this$0.size) {
                throw new NoSuchElementException();
            }
            ++this.count;
            Entry entry = null;
            if (this.next != null) {
                entry = this.next;
            }
            while (entry == null) {
                entry = this.this$0.buckets[this.idx += -1];
            }
            this.next = entry.next;
            this.last = entry;
            if (this.type == 1) {
                return entry.value;
            }
            if (this.type == 0) {
                return entry.key;
            }
            return entry;
        }

        public void remove() {
            if (this.knownMod != this.this$0.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.last == null) {
                throw new IllegalStateException();
            }
            this.this$0.remove(this.last.key);
            ++this.knownMod;
            this.count += -1;
            this.last = null;
        }
    }

    static class Entry
    extends BasicMapEntry {
        Entry next;

        Entry(Object object, Object object2) {
            super(object, object2);
        }
    }
}

