/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class GregorianCalendar
extends Calendar {
    public static final int BC = 0;
    public static final int AD = 1;
    long gregorianCutover;
    private static final int[] mins = new int[]{0, 1, 0, 0, 0, 1, 1, 1, -1, 0, 0, 0, 0, 0, 0, -43200000, 0};
    private static final int[] maxs = new int[]{1, 5000000, 11, 54, 6, 31, 366, 7, 6, 1, 12, 23, 59, 59, 999, 43200000, 3600000};
    private static final int[] leastMaximums = new int[]{1, 5000000, 11, 53, 6, 28, 365, 7, 4, 1, 11, 23, 59, 59, 999, 43200000, 3600000};
    private static final long serialVersionUID = -8125100834729963327L;

    private /* synthetic */ void finit$() {
        this.gregorianCutover = -12219292800000L;
    }

    public GregorianCalendar() {
        this(TimeZone.getDefault(), Locale.getDefault());
    }

    public GregorianCalendar(TimeZone timeZone) {
        this(timeZone, Locale.getDefault());
    }

    public GregorianCalendar(Locale locale) {
        this(TimeZone.getDefault(), locale);
    }

    public GregorianCalendar(TimeZone timeZone, Locale locale) {
        super(timeZone, locale);
        this.finit$();
        this.setDefaultTime();
    }

    public GregorianCalendar(int n, int n2, int n3) {
        this();
        this.set(n, n2, n3, 0, 0, 0);
    }

    public GregorianCalendar(int n, int n2, int n3, int n4, int n5) {
        this();
        this.set(n, n2, n3, n4, n5, 0);
    }

    public GregorianCalendar(int n, int n2, int n3, int n4, int n5, int n6) {
        this();
        this.set(n, n2, n3, n4, n5, n6);
    }

    private final void setDefaultTime() {
        this.setTimeInMillis(System.currentTimeMillis());
    }

    public int getMinimum(int n) {
        return mins[n];
    }

    public int getGreatestMinimum(int n) {
        return mins[n];
    }

    public int getMaximum(int n) {
        return maxs[n];
    }

    public int getLeastMaximum(int n) {
        return leastMaximums[n];
    }

    protected native void computeFields();

    protected native void computeTime();

    public void add(int n, int n2) {
        if (n >= 15) {
            throw new IllegalArgumentException("bad field to add");
        }
        this.fields[n] = this.fields[n] + n2;
        this.adjust(n);
    }

    public void roll(int n, boolean bl) {
        if (n >= 15) {
            throw new IllegalArgumentException("bad field to roll");
        }
        int n2 = this.fields[n];
        this.fields[n] = bl ? (n2 == this.getMaximum(n) ? this.getMinimum(n) : n2 + 1) : (n2 == this.getMinimum(n) ? this.getMaximum(n) : n2 - 1);
    }

    private void adjust(int n) {
        int n2 = this.fields[n];
        int n3 = maxs[n] + 1;
        switch (n) {
            case 2: 
            case 13: 
            case 14: {
                if (n2 >= n3) {
                    int n4 = n2 / n3;
                    this.fields[n] = n2 - n3 * n4;
                    this.fields[n - 1] = this.fields[n - 1] + n4;
                    this.adjust(n - 1);
                    break;
                }
                if (n2 >= 0) break;
                int n5 = (n2 - n3 - 1) / n3;
                this.fields[n] = n2 - n3 * n5;
                this.fields[n - 1] = this.fields[n - 1] + n5;
                this.adjust(n - 1);
            }
        }
    }

    public final Date getGregorianChange() {
        return new Date(this.gregorianCutover);
    }

    public void setGregorianChange(Date date) {
        this.gregorianCutover = date.getTime();
    }

    public boolean isLeapYear(int n) {
        if (n % 4 != 0) {
            return false;
        }
        if (n % 100 != 0 || n % 400 == 0) {
            return true;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(n, 1, 28);
        return this.gregorianCutover < gregorianCalendar.getTimeInMillis();
    }

    public boolean after(Object object) {
        return object instanceof Calendar && this.getTimeInMillis() > ((Calendar)object).getTimeInMillis();
    }

    public boolean before(Object object) {
        return object instanceof Calendar && this.getTimeInMillis() < ((Calendar)object).getTimeInMillis();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof GregorianCalendar)) {
            return false;
        }
        GregorianCalendar gregorianCalendar = (GregorianCalendar)object;
        int n = 17;
        while (--n >= 0) {
            boolean bl = this.isSet[n];
            if (bl == gregorianCalendar.isSet[n] && (!bl || this.fields[n] == gregorianCalendar.fields[n])) continue;
            return false;
        }
        return this.areFieldsSet == gregorianCalendar.areFieldsSet && this.isTimeSet == gregorianCalendar.isTimeSet && (!this.isTimeSet || this.time == gregorianCalendar.time) && this.getFirstDayOfWeek() == gregorianCalendar.getFirstDayOfWeek() && this.getMinimalDaysInFirstWeek() == gregorianCalendar.getMinimalDaysInFirstWeek() && this.isLenient() == gregorianCalendar.isLenient() && this.getTimeZone().equals(gregorianCalendar.getTimeZone());
    }

    public int hashCode() {
        int n = 0;
        int n2 = 17;
        while (--n2 >= 0) {
            if (!this.isSet[n2]) continue;
            n += 37 * this.fields[n2];
        }
        if (this.isTimeSet) {
            n += (int)((long)89 * this.time);
        }
        return n;
    }
}

