/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class Date
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 7523967970034938905L;
    private transient long millis;

    public Date() {
        this.millis = System.currentTimeMillis();
    }

    public Date(long l) {
        this.millis = l;
    }

    public Date(int n, int n2, int n3, int n4, int n5, int n6) {
        this.setTime(n, n2, n3, n4, n5, n6);
    }

    public Date(int n, int n2, int n3, int n4, int n5) {
        this.setTime(n, n2, n3, n4, n5, 0);
    }

    public Date(int n, int n2, int n3) {
        this.setTime(n, n2, n3, 0, 0, 0);
    }

    public Date(String string) {
        this(Date.parse(string));
    }

    private static int skipParens(String string, int n) {
        int n2;
        int n3 = string.length();
        int n4 = 0;
        for (n2 = n; n2 < n3; ++n2) {
            if (string.charAt(n2) == '(') {
                ++n4;
                continue;
            }
            if (string.charAt(n2) != ')') continue;
            if (--n4 == 0) {
                return n2 + 1;
            }
            if (n4 >= 0) continue;
            return n2;
        }
        return n2;
    }

    private static int parseTz(String string, char c) {
        int n;
        try {
            n = Integer.parseInt(string.substring(1));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(string);
        }
        n = n < 24 ? (n *= 60) : n / 100 * 60 + n % 100;
        if (c == '-') {
            return -n;
        }
        return n;
    }

    private static int parseMonth(String string) {
        String[] stringArray = new String[]{"JANUARY", "FEBRUARY", "MARCH", "APRIL", "MAY", "JUNE", "JULY", "AUGUST", "SEPTEMBER", "OCTOBER", "NOVEMBER", "DECEMBER"};
        for (int i = 0; i < 12; ++i) {
            if (!stringArray[i].startsWith(string)) continue;
            return i;
        }
        return -1;
    }

    private static boolean parseDayOfWeek(String string) {
        String[] stringArray = new String[]{"SUNDAY", "MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY"};
        for (int i = 0; i < 7; ++i) {
            if (!stringArray[i].startsWith(string)) continue;
            return true;
        }
        return false;
    }

    public static long parse(String string) {
        int n;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = 0;
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        int n9 = 0;
        while ((n = string.indexOf(40, n9)) >= 0) {
            stringBuffer.append(string.substring(n9, n));
            n9 = Date.skipParens(string, n);
        }
        stringBuffer.append(string.substring(n9));
        StringTokenizer stringTokenizer = new StringTokenizer(stringBuffer.toString().toUpperCase(), " \t\n\r,");
        while (stringTokenizer.hasMoreTokens()) {
            char c;
            int n10;
            String string2 = stringTokenizer.nextToken();
            char c2 = string2.charAt(0);
            if ((c2 == '+' || c2 == '-') && n2 >= 0) {
                n8 = Date.parseTz(string2, c2);
                bl = false;
                continue;
            }
            if (c2 >= '0' && c2 <= '9') {
                while (string2 != null && string2.length() > 0) {
                    int n11;
                    n10 = string2.indexOf(58);
                    c = string2.indexOf(47);
                    int n12 = string2.indexOf(45);
                    int n13 = string2.length();
                    if (n10 >= 0) {
                        n13 = Math.min(n13, n10);
                    }
                    if (c >= '\u0000') {
                        n13 = Math.min(n13, c);
                    }
                    if (n12 >= 0) {
                        n13 = Math.min(n13, n12);
                    }
                    if (n13 == string2.length()) {
                        n13 = -1;
                    }
                    try {
                        n11 = Integer.parseInt(n13 < 0 ? string2 : string2.substring(0, n13));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException(string2);
                    }
                    if (n11 > 70 && (n13 < 0 || n13 == c)) {
                        n2 = n11 > 1900 ? n11 - 1900 : n11;
                    } else if (n13 > 0 && n13 == n10) {
                        if (n5 < 0) {
                            n5 = n11;
                        } else {
                            n6 = n11;
                        }
                    } else if (n13 > 0 && n13 == c) {
                        if (n3 < 0) {
                            n3 = n11 - 1;
                        } else {
                            n4 = n11;
                        }
                    } else if (n5 >= 0 && n6 < 0) {
                        n6 = n11;
                    } else if (n6 >= 0 && n7 < 0) {
                        n7 = n11;
                    } else if (n4 < 0) {
                        n4 = n11;
                    } else {
                        throw new IllegalArgumentException(string2);
                    }
                    if (n13 < 0 || n13 + 1 >= string2.length()) {
                        string2 = null;
                        continue;
                    }
                    string2 = string2.substring(n13 + 1);
                }
                continue;
            }
            if (c2 >= 'A' && c2 <= 'Z') {
                if (string2.equals("AM")) {
                    if (n5 < 1 || n5 > 12) {
                        throw new IllegalArgumentException(string2);
                    }
                    if (n5 != 12) continue;
                    n5 = 0;
                    continue;
                }
                if (string2.equals("PM")) {
                    if (n5 < 1 || n5 > 12) {
                        throw new IllegalArgumentException(string2);
                    }
                    if (n5 >= 12) continue;
                    n5 += 12;
                    continue;
                }
                if (Date.parseDayOfWeek(string2)) continue;
                if (string2.equals("UT") || string2.equals("UTC") || string2.equals("GMT")) {
                    bl = false;
                    continue;
                }
                if (string2.startsWith("UT") || string2.startsWith("GMT")) {
                    n10 = 3;
                    if (string2.charAt(1) == 'T' && string2.charAt(2) != 'C') {
                        n10 = 2;
                    }
                    if ((c = (char)string2.charAt(n10)) != '+' && c != '-') {
                        throw new IllegalArgumentException(string2);
                    }
                    n8 = Date.parseTz(string2.substring(n10), c);
                    bl = false;
                    continue;
                }
                int n14 = Date.parseMonth(string2);
                if (n14 >= 0) {
                    n3 = n14;
                    continue;
                }
                if (string2.length() == 3 && string2.charAt(2) == 'T') {
                    n10 = string2.charAt(0);
                    if (n10 == 69) {
                        n8 = -300;
                    } else if (n10 == 67) {
                        n8 = -360;
                    } else if (n10 == 77) {
                        n8 = -420;
                    } else if (n10 == 80) {
                        n8 = -480;
                    } else {
                        throw new IllegalArgumentException(string2);
                    }
                    if (string2.charAt(1) == 'D') {
                        n8 += 60;
                    } else if (string2.charAt(1) != 'S') {
                        throw new IllegalArgumentException(string2);
                    }
                    bl = false;
                    continue;
                }
                throw new IllegalArgumentException(string2);
            }
            throw new IllegalArgumentException(string2);
        }
        if (n6 < 0) {
            n6 = 0;
        }
        if (n7 < 0) {
            n7 = 0;
        }
        if (n2 < 0 || n3 < 0 || n4 < 0 || n5 < 0) {
            throw new IllegalArgumentException("Missing field");
        }
        return Date.UTC(n2, n3, n4, n5, n6, n7) + (long)(bl ? new Date(n2, n3, n4).getTimezoneOffset() * 60 * 1000 : -n8 * 60 * 1000);
    }

    public boolean after(Date date) {
        return this.millis > date.millis;
    }

    public boolean before(Date date) {
        return this.millis < date.millis;
    }

    public boolean equals(Object object) {
        return object != null && object instanceof Date && ((Date)object).millis == this.millis;
    }

    public long getTime() {
        return this.millis;
    }

    public int hashCode() {
        return (int)this.millis ^ (int)(this.millis >>> 32);
    }

    private void setTime(int n, int n2, int n3, int n4, int n5, int n6) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(n + 1900, n2, n3, n4, n5, n6);
        this.millis = gregorianCalendar.getTimeInMillis();
    }

    public void setTime(long l) {
        this.millis = l;
    }

    private int getField(int n) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(this);
        return gregorianCalendar.get(n);
    }

    public int getYear() {
        return this.getField(1) - 1900;
    }

    public int getMonth() {
        return this.getField(2);
    }

    public int getDate() {
        return this.getField(5);
    }

    public int getDay() {
        return this.getField(7) - 1;
    }

    public int getHours() {
        return this.getField(11);
    }

    public int getMinutes() {
        return this.getField(12);
    }

    public int getSeconds() {
        return this.getField(13);
    }

    private void setField(int n, int n2) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(this);
        gregorianCalendar.set(n, n2);
        this.millis = gregorianCalendar.getTimeInMillis();
    }

    public void setYear(int n) {
        this.setField(1, 1900 + n);
    }

    public void setMonth(int n) {
        this.setField(2, n);
    }

    public void setDate(int n) {
        this.setField(5, n);
    }

    public void setHours(int n) {
        this.setField(11, n);
    }

    public void setMinutes(int n) {
        this.setField(12, n);
    }

    public void setSeconds(int n) {
        this.setField(13, n);
    }

    public int getTimezoneOffset() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(this);
        return -(gregorianCalendar.get(15) + gregorianCalendar.get(16) / 60000);
    }

    public String toString() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("E MMM dd HH:mm:ss z yyyy", Locale.US);
        simpleDateFormat.setTimeZone(TimeZone.getDefault());
        return simpleDateFormat.format(this);
    }

    public String toGMTString() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("d MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return simpleDateFormat.format(this);
    }

    public String toLocaleString() {
        DateFormat dateFormat = DateFormat.getDateTimeInstance();
        dateFormat.setTimeZone(TimeZone.getDefault());
        return dateFormat.format(this);
    }

    public static long UTC(int n, int n2, int n3, int n4, int n5, int n6) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        gregorianCalendar.set(n + 1900, n2, n3, n4, n5, n6);
        return gregorianCalendar.getTimeInMillis();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.millis = objectInputStream.readLong();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeLong(this.millis);
    }
}

