/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSequentialList;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

public class Collections {
    public static final Set EMPTY_SET = new AbstractSet(null){
        private /* synthetic */ Collections this$0;
        {
            this.this$0 = collections;
        }

        public int size() {
            return 0;
        }

        public Iterator iterator() {
            return EMPTY_LIST.iterator();
        }
    };
    public static final List EMPTY_LIST = new AbstractList(null){
        private /* synthetic */ Collections this$0;
        {
            this.this$0 = collections;
        }

        public int size() {
            return 0;
        }

        public Object get(int n) {
            throw new IndexOutOfBoundsException();
        }
    };
    public static final Map EMPTY_MAP = new AbstractMap(null){
        private /* synthetic */ Collections this$0;
        {
            this.this$0 = collections;
        }

        public Set entrySet() {
            return EMPTY_SET;
        }
    };
    static ReverseComparator rcInstance = new ReverseComparator();
    private static Random defaultRandom = null;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private Collections() {
    }

    private static int compare(Object object, Object object2, Comparator comparator) {
        if (comparator == null) {
            return ((Comparable)object).compareTo(object2);
        }
        return comparator.compare(object, object2);
    }

    private static int search(List list, Object object, Comparator comparator) {
        int n = 0;
        if (list instanceof AbstractSequentialList) {
            ListIterator listIterator = list.listIterator();
            for (int i = list.size() - 1; i >= 0; --i) {
                int n2 = Collections.compare(object, listIterator.next(), comparator);
                if (n2 == 0) {
                    return n;
                }
                if (n2 < 0) {
                    return -n - 1;
                }
                ++n;
            }
        } else {
            int n3 = 0;
            int n4 = list.size() - 1;
            while (n3 <= n4) {
                n = n3 + n4 >> 1;
                int n5 = Collections.compare(object, list.get(n), comparator);
                if (n5 == 0) {
                    return n;
                }
                if (n5 < 0) {
                    n4 = n - 1;
                    continue;
                }
                n3 = ++n;
            }
        }
        return -n - 1;
    }

    public static int binarySearch(List list, Object object) {
        return Collections.search(list, object, null);
    }

    public static int binarySearch(List list, Object object, Comparator comparator) {
        if (comparator == null) {
            throw new NullPointerException();
        }
        return Collections.search(list, object, comparator);
    }

    public static void copy(List list, List list2) {
        Iterator iterator = list2.iterator();
        ListIterator listIterator = list.listIterator();
        try {
            for (int i = list2.size() - 1; i >= 0; --i) {
                listIterator.next();
                listIterator.set(iterator.next());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IndexOutOfBoundsException("Source doesn't fit in dest.");
        }
    }

    public static Enumeration enumeration(Collection collection) {
        Iterator iterator = collection.iterator();
        return new Enumeration(null, iterator){
            private /* synthetic */ Collections this$0;
            private /* synthetic */ Iterator val$i;
            {
                this.this$0 = collections;
                this.finit$(iterator);
            }

            private /* synthetic */ void finit$(Iterator iterator) {
                this.val$i = iterator;
            }

            public final boolean hasMoreElements() {
                return this.val$i.hasNext();
            }

            public final Object nextElement() {
                return this.val$i.next();
            }
        };
    }

    public static void fill(List list, Object object) {
        ListIterator listIterator = list.listIterator();
        for (int i = list.size() - 1; i >= 0; --i) {
            listIterator.next();
            listIterator.set(object);
        }
    }

    public static Object max(Collection collection) {
        Iterator iterator = collection.iterator();
        Comparable comparable = (Comparable)iterator.next();
        int n = collection.size();
        for (int i = 1; i < n; ++i) {
            Object object = iterator.next();
            if (comparable.compareTo(object) >= 0) continue;
            comparable = (Comparable)object;
        }
        return comparable;
    }

    public static Object max(Collection collection, Comparator comparator) {
        Iterator iterator = collection.iterator();
        Object object = iterator.next();
        int n = collection.size();
        for (int i = 1; i < n; ++i) {
            Object object2 = iterator.next();
            if (comparator.compare(object, object2) >= 0) continue;
            object = object2;
        }
        return object;
    }

    public static Object min(Collection collection) {
        Iterator iterator = collection.iterator();
        Comparable comparable = (Comparable)iterator.next();
        int n = collection.size();
        for (int i = 1; i < n; ++i) {
            Object object = iterator.next();
            if (comparable.compareTo(object) <= 0) continue;
            comparable = (Comparable)object;
        }
        return comparable;
    }

    public static Object min(Collection collection, Comparator comparator) {
        Iterator iterator = collection.iterator();
        Object object = iterator.next();
        int n = collection.size();
        for (int i = 1; i < n; ++i) {
            Object object2 = iterator.next();
            if (comparator.compare(object, object2) <= 0) continue;
            object = object2;
        }
        return object;
    }

    public static List nCopies(int n, Object object) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        return new AbstractList(null, n, object){
            private /* synthetic */ Collections this$0;
            private /* synthetic */ int val$n;
            private /* synthetic */ Object val$o;
            {
                this.this$0 = collections;
                this.finit$(n, object);
            }

            private /* synthetic */ void finit$(int n, Object object) {
                this.val$o = object;
                this.val$n = n;
            }

            public int size() {
                return this.val$n;
            }

            public Object get(int n) {
                if (n < 0 || n >= this.val$n) {
                    throw new IndexOutOfBoundsException();
                }
                return this.val$o;
            }
        };
    }

    public static void reverse(List list) {
        int n;
        ListIterator listIterator = list.listIterator();
        int n2 = 0;
        ListIterator listIterator2 = list.listIterator(n);
        for (n = list.size(); n2 < n; ++n2, --n) {
            Object object = listIterator.next();
            listIterator.set(listIterator2.previous());
            listIterator2.set(object);
        }
    }

    public static Comparator reverseOrder() {
        return rcInstance;
    }

    public static void shuffle(List list) {
        if (defaultRandom == null) {
            Class clazz = Collections.class$("java.util.Collections");
            synchronized (clazz) {
                block4: {
                    try {
                        if (defaultRandom != null) break block4;
                        defaultRandom = new Random();
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        throw throwable;
                    }
                }
                Object var3_2 = null;
            }
        }
        Collections.shuffle(list, defaultRandom);
    }

    public static void shuffle(List list, Random random) {
        Object[] objectArray = list.toArray();
        int n = list.size();
        ListIterator listIterator = list.listIterator(n);
        for (int i = n - 1; i >= 0; --i) {
            int n2 = random.nextInt(i + 1);
            Object object = objectArray[n2];
            objectArray[n2] = objectArray[i];
            objectArray[i] = object;
            listIterator.previous();
            listIterator.set(object);
        }
    }

    public static Set singleton(Object object) {
        return new AbstractSet(null, object){
            private /* synthetic */ Collections this$0;
            private /* synthetic */ Object val$o;
            {
                this.this$0 = collections;
                this.finit$(object);
            }

            private /* synthetic */ void finit$(Object object) {
                this.val$o = object;
            }

            static /* synthetic */ Object access$1(6 var0, Object object) {
                var0.val$o = object;
                return var0.val$o;
            }

            public int size() {
                return 1;
            }

            public Iterator iterator() {
                return new Iterator(this){
                    private /* synthetic */ 6 this$1;
                    private boolean hasNext;
                    {
                        this.this$1 = var1_1;
                        this.finit$();
                    }

                    private /* synthetic */ void finit$() {
                        this.hasNext = true;
                    }

                    public boolean hasNext() {
                        return this.hasNext;
                    }

                    public Object next() {
                        if (this.hasNext) {
                            this.hasNext = false;
                            return this.this$1.val$o;
                        }
                        throw new NoSuchElementException();
                    }

                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static List singletonList(Object object) {
        return new AbstractList(null, object){
            private /* synthetic */ Collections this$0;
            private /* synthetic */ Object val$o;
            {
                this.this$0 = collections;
                this.finit$(object);
            }

            private /* synthetic */ void finit$(Object object) {
                this.val$o = object;
            }

            public int size() {
                return 1;
            }

            public Object get(int n) {
                if (n == 0) {
                    throw new IndexOutOfBoundsException();
                }
                return this.val$o;
            }
        };
    }

    public static Map singletonMap(Object object, Object object2) {
        return new AbstractMap(null, object, object2){
            private /* synthetic */ Collections this$0;
            private /* synthetic */ Object val$key;
            private /* synthetic */ Object val$value;
            {
                this.this$0 = collections;
                this.finit$(object, object2);
            }

            private /* synthetic */ void finit$(Object object, Object object2) {
                this.val$value = object2;
                this.val$key = object;
            }

            public Set entrySet() {
                return Collections.singleton(new HashMap.Entry(this.val$key, this.val$value));
            }
        };
    }

    public static void sort(List list) {
        Object[] objectArray = list.toArray();
        Arrays.sort(objectArray);
        ListIterator listIterator = list.listIterator();
        for (int i = 0; i < objectArray.length; ++i) {
            listIterator.next();
            listIterator.set(objectArray[i]);
        }
    }

    public static void sort(List list, Comparator comparator) {
        Object[] objectArray = list.toArray();
        Arrays.sort(objectArray, comparator);
        ListIterator listIterator = list.listIterator();
        for (int i = 0; i < objectArray.length; ++i) {
            listIterator.next();
            listIterator.set(objectArray[i]);
        }
    }

    public static Collection synchronizedCollection(Collection collection) {
        return new SynchronizedCollection(collection);
    }

    public static List synchronizedList(List list) {
        return new SynchronizedList(list);
    }

    public static Map synchronizedMap(Map map) {
        return new SynchronizedMap(map);
    }

    public static Set synchronizedSet(Set set) {
        return new SynchronizedSet(set);
    }

    public static SortedMap synchronizedSortedMap(SortedMap sortedMap) {
        return new SynchronizedSortedMap(sortedMap);
    }

    public static SortedSet synchronizedSortedSet(SortedSet sortedSet) {
        return new SynchronizedSortedSet(sortedSet);
    }

    public static Collection unmodifiableCollection(Collection collection) {
        return new UnmodifiableCollection(collection);
    }

    public static List unmodifiableList(List list) {
        return new UnmodifiableList(list);
    }

    public static Map unmodifiableMap(Map map) {
        return new UnmodifiableMap(map);
    }

    public static Set unmodifiableSet(Set set) {
        return new UnmodifiableSet(set);
    }

    public static SortedMap unmodifiableSortedMap(SortedMap sortedMap) {
        return new UnmodifiableSortedMap(sortedMap);
    }

    public static SortedSet unmodifiableSortedSet(SortedSet sortedSet) {
        return new UnmodifiableSortedSet(sortedSet);
    }

    static class SynchronizedSortedMap
    extends SynchronizedMap
    implements SortedMap {
        private SortedMap sm;

        public SynchronizedSortedMap(Object object, SortedMap sortedMap) {
            super(object, sortedMap);
            this.sm = sortedMap;
        }

        public SynchronizedSortedMap(SortedMap sortedMap) {
            super(sortedMap);
            this.sm = sortedMap;
        }

        public Comparator comparator() {
            Object object = this.sync;
            synchronized (object) {
                try {
                    Comparator comparator = this.sm.comparator();
                    Object var4_3 = null;
                    return comparator;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    throw throwable;
                }
            }
        }

        public Object firstKey() {
            Object object = this.sync;
            synchronized (object) {
                try {
                    Object object2 = this.sm.firstKey();
                    Object var4_3 = null;
                    return object2;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    throw throwable;
                }
            }
        }

        public Object lastKey() {
            Object object = this.sync;
            synchronized (object) {
                try {
                    Object object2 = this.sm.lastKey();
                    Object var4_3 = null;
                    return object2;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    throw throwable;
                }
            }
        }

        public SortedMap headMap(Object object) {
            return new SynchronizedSortedMap(this.sync, this.sm.headMap(object));
        }

        public SortedMap tailMap(Object object) {
            return new SynchronizedSortedMap(this.sync, this.sm.tailMap(object));
        }

        public SortedMap subMap(Object object, Object object2) {
            return new SynchronizedSortedMap(this.sync, this.sm.subMap(object, object2));
        }
    }

    static class SynchronizedMap
    implements Map,
    Serializable {
        Object sync;
        Map m;

        public SynchronizedMap(Object object, Map map) {
            this.sync = object;
            this.m = map;
        }

        public SynchronizedMap(Map map) {
            this.m = map;
            this.sync = this;
        }

        public void clear() {
            Object object = this.sync;
            synchronized (object) {
                try {
                    this.m.clear();
                }
                finally {
                    Object var3_2 = null;
                }
                return;
            }
        }

        public boolean containsKey(Object object) {
            Object object2 = this.sync;
            synchronized (object2) {
                try {
                    boolean bl = this.m.containsKey(object);
                    Object var5_4 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    throw throwable;
                }
            }
        }

        public boolean containsValue(Object object) {
            Object object2 = this.sync;
            synchronized (object2) {
                try {
                    boolean bl = this.m.containsValue(object);
                    Object var5_4 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    throw throwable;
                }
            }
        }

        public Set entrySet() {
            Object object = this.sync;
            synchronized (object) {
                try {
                    SynchronizedSet synchronizedSet = new SynchronizedSet(this, this.sync, this.m.entrySet()){
                        private /* synthetic */ SynchronizedMap this$1;
                        {
                            this.this$1 = synchronizedMap;
                            super(object, set);
                        }

                        static SynchronizedMap access$0(13 var0) {
                            return var0.this$1;
                        }

                        public Iterator iterator() {
                            Object object = this.this$1.sync;
                            synchronized (object) {
                                try {
                                    SynchronizedIterator synchronizedIterator = new SynchronizedIterator(this, this.this$1.sync, this.c.iterator()){
                                        private /* synthetic */ 13 this$2;
                                        {
                                            this.this$2 = var1_1;
                                            super(object, iterator);
                                        }

                                        static 13 access$0(14 var0) {
                                            return var0.this$2;
                                        }

                                        public Object next() {
                                            Object object = 13.access$0(this.this$2).sync;
                                            synchronized (object) {
                                                try {
                                                    Map.Entry entry = (Map.Entry)super.next();
                                                    Map.Entry entry2 = new Map.Entry(this, entry){
                                                        private /* synthetic */ 14 this$3;
                                                        private /* synthetic */ Map.Entry val$e;
                                                        {
                                                            this.this$3 = var1_1;
                                                            this.finit$(entry);
                                                        }

                                                        private /* synthetic */ void finit$(Map.Entry entry) {
                                                            this.val$e = entry;
                                                        }

                                                        public Object getKey() {
                                                            Object object = 13.access$0(14.access$0(this.this$3)).sync;
                                                            synchronized (object) {
                                                                try {
                                                                    Object object2 = this.val$e.getKey();
                                                                    Object var4_3 = null;
                                                                    return object2;
                                                                }
                                                                catch (Throwable throwable) {
                                                                    Object var4_4 = null;
                                                                    throw throwable;
                                                                }
                                                            }
                                                        }

                                                        public Object getValue() {
                                                            Object object = 13.access$0(14.access$0(this.this$3)).sync;
                                                            synchronized (object) {
                                                                try {
                                                                    Object object2 = this.val$e.getValue();
                                                                    Object var4_3 = null;
                                                                    return object2;
                                                                }
                                                                catch (Throwable throwable) {
                                                                    Object var4_4 = null;
                                                                    throw throwable;
                                                                }
                                                            }
                                                        }

                                                        public Object setValue(Object object) {
                                                            Object object2 = 13.access$0(14.access$0(this.this$3)).sync;
                                                            synchronized (object2) {
                                                                try {
                                                                    Object object3 = this.val$e.setValue(object);
                                                                    Object var5_4 = null;
                                                                    return object3;
                                                                }
                                                                catch (Throwable throwable) {
                                                                    Object var5_5 = null;
                                                                    throw throwable;
                                                                }
                                                            }
                                                        }

                                                        public int hashCode() {
                                                            Object object = 13.access$0(14.access$0(this.this$3)).sync;
                                                            synchronized (object) {
                                                                try {
                                                                    int n = this.val$e.hashCode();
                                                                    Object var4_3 = null;
                                                                    return n;
                                                                }
                                                                catch (Throwable throwable) {
                                                                    Object var4_4 = null;
                                                                    throw throwable;
                                                                }
                                                            }
                                                        }

                                                        public boolean equals(Object object) {
                                                            Object object2 = 13.access$0(14.access$0(this.this$3)).sync;
                                                            synchronized (object2) {
                                                                try {
                                                                    boolean bl = this.val$e.equals(object);
                                                                    Object var5_4 = null;
                                                                    return bl;
                                                                }
                                                                catch (Throwable throwable) {
                                                                    Object var5_5 = null;
                                                                    throw throwable;
                                                                }
                                                            }
                                                        }
                                                    };
                                                    Object var4_5 = null;
                                                    return entry2;
                                                }
                                                catch (Throwable throwable) {
                                                    Object var4_6 = null;
                                                    throw throwable;
                                                }
                                            }
                                        }
                                    };
                                    Object var4_3 = null;
                                    return synchronizedIterator;
                                }
                                catch (Throwable throwable) {
                                    Object var4_4 = null;
                                    throw throwable;
                                }
                            }
                        }
                    };
                    Object var4_3 = null;
                    return synchronizedSet;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    throw throwable;
                }
            }
        }

        public boolean equals(Object object) {
            Object object2 = this.sync;
            synchronized (object2) {
                try {
                    boolean bl = this.m.equals(object);
                    Object var5_4 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    throw throwable;
                }
            }
        }

        public Object get(Object object) {
            Object object2 = this.sync;
            synchronized (object2) {
                try {
                    Object object3 = this.m.get(object);
                    Object var5_4 = null;
                    return object3;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    throw throwable;
                }
            }
        }

        public Object put(Object object, Object object2) {
            Object object3 = this.sync;
            synchronized (object3) {
                try {
                    Object object4 = this.m.put(object, object2);
                    Object var6_5 = null;
                    return object4;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    throw throwable;
                }
            }
        }

        public int hashCode() {
            Object object = this.sync;
            synchronized (object) {
                try {
                    int n = this.m.hashCode();
                    Object var4_3 = null;
                    return n;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    throw throwable;
                }
            }
        }

        public boolean isEmpty() {
            Object object = this.sync;
            synchronized (object) {
                try {
                    boolean bl = this.m.isEmpty();
                    Object var4_3 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    throw throwable;
                }
            }
        }

        public Set keySet() {
            Object object = this.sync;
            synchronized (object) {
                try {
                    SynchronizedSet synchronizedSet = new SynchronizedSet(this.sync, this.m.keySet());
                    Object var4_3 = null;
                    return synchronizedSet;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    throw throwable;
                }
            }
        }

        public void putAll(Map map) {
            Object object = this.sync;
            synchronized (object) {
                try {
                    this.m.putAll(map);
                }
                finally {
                    Object var4_3 = null;
                }
                return;
            }
        }

        public Object remove(Object object) {
            Object object2 = this.sync;
            synchronized (object2) {
                try {
                    Object object3 = this.m.remove(object);
                    Object var5_4 = null;
                    return object3;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    throw throwable;
                }
            }
        }

        public int size() {
            Object object = this.sync;
            synchronized (object) {
                try {
                    int n = this.m.size();
                    Object var4_3 = null;
                    return n;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    throw throwable;
                }
            }
        }

        public Collection values() {
            Object object = this.sync;
            synchronized (object) {
                try {
                    SynchronizedCollection synchronizedCollection = new SynchronizedCollection(this.sync, this.m.values());
                    Object var4_3 = null;
                    return synchronizedCollection;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    throw throwable;
                }
            }
        }

        public String toString() {
            Object object = this.sync;
            synchronized (object) {
                try {
                    String string = this.m.toString();
                    Object var4_3 = null;
                    return string;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    throw throwable;
                }
            }
        }
    }

    static class SynchronizedSortedSet
    extends SynchronizedSet
    implements SortedSet {
        private SortedSet ss;

        public SynchronizedSortedSet(Object object, SortedSet sortedSet) {
            super(object, sortedSet);
            this.ss = sortedSet;
        }

        public SynchronizedSortedSet(SortedSet sortedSet) {
            super(sortedSet);
            this.ss = sortedSet;
        }

        public Comparator comparator() {
            Object object = this.sync;
            synchronized (object) {
                try {
                    Comparator comparator = this.ss.comparator();
                    Object var4_3 = null;
                    return comparator;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    throw throwable;
                }
            }
        }

        public Object first() {
            Object object = this.sync;
            synchronized (object) {
                try {
                    Object object2 = this.ss.first();
                    Object var4_3 = null;
                    return object2;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    throw throwable;
                }
            }
        }

        public Object last() {
            Object object = this.sync;
            synchronized (object) {
                try {
                    Object object2 = this.ss.last();
                    Object var4_3 = null;
                    return object2;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    throw throwable;
                }
            }
        }

        public SortedSet headSet(Object object) {
            Object object2 = this.sync;
            synchronized (object2) {
                try {
                    SynchronizedSortedSet synchronizedSortedSet = new SynchronizedSortedSet(this.sync, this.ss.headSet(object));
                    Object var5_4 = null;
                    return synchronizedSortedSet;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    throw throwable;
                }
            }
        }

        public SortedSet tailSet(Object object) {
            Object object2 = this.sync;
            synchronized (object2) {
                try {
                    SynchronizedSortedSet synchronizedSortedSet = new SynchronizedSortedSet(this.sync, this.ss.tailSet(object));
                    Object var5_4 = null;
                    return synchronizedSortedSet;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    throw throwable;
                }
            }
        }

        public SortedSet subSet(Object object, Object object2) {
            Object object3 = this.sync;
            synchronized (object3) {
                try {
                    SynchronizedSortedSet synchronizedSortedSet = new SynchronizedSortedSet(this.sync, this.ss.subSet(object, object2));
                    Object var6_5 = null;
                    return synchronizedSortedSet;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    throw throwable;
                }
            }
        }
    }

    static class SynchronizedSet
    extends SynchronizedCollection
    implements Set {
        public SynchronizedSet(Object object, Set set) {
            super(object, set);
        }

        public SynchronizedSet(Set set) {
            super(set);
        }

        public boolean equals(Object object) {
            Object object2 = this.sync;
            synchronized (object2) {
                try {
                    boolean bl = this.c.equals(object);
                    Object var5_4 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    throw throwable;
                }
            }
        }

        public int hashCode() {
            Object object = this.sync;
            synchronized (object) {
                try {
                    int n = this.c.hashCode();
                    Object var4_3 = null;
                    return n;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    throw throwable;
                }
            }
        }
    }

    static class SynchronizedList
    extends SynchronizedCollection
    implements List {
        List l;

        public SynchronizedList(Object object, List list) {
            super(object, list);
            this.l = list;
        }

        public SynchronizedList(List list) {
            super(list);
            this.l = list;
        }

        public void add(int n, Object object) {
            Object object2 = this.sync;
            synchronized (object2) {
                try {
                    this.l.add(n, object);
                }
                finally {
                    Object var5_4 = null;
                }
                return;
            }
        }

        public boolean addAll(int n, Collection collection) {
            Object object = this.sync;
            synchronized (object) {
                try {
                    boolean bl = this.l.addAll(n, collection);
                    Object var6_5 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    throw throwable;
                }
            }
        }

        public boolean equals(Object object) {
            Object object2 = this.sync;
            synchronized (object2) {
                try {
                    boolean bl = this.l.equals(object);
                    Object var5_4 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    throw throwable;
                }
            }
        }

        public Object get(int n) {
            Object object = this.sync;
            synchronized (object) {
                try {
                    Object object2 = this.l.get(n);
                    Object var5_4 = null;
                    return object2;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    throw throwable;
                }
            }
        }

        public int hashCode() {
            Object object = this.sync;
            synchronized (object) {
                try {
                    int n = this.l.hashCode();
                    Object var4_3 = null;
                    return n;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    throw throwable;
                }
            }
        }

        public int indexOf(Object object) {
            Object object2 = this.sync;
            synchronized (object2) {
                try {
                    int n = this.l.indexOf(object);
                    Object var5_4 = null;
                    return n;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    throw throwable;
                }
            }
        }

        public int lastIndexOf(Object object) {
            Object object2 = this.sync;
            synchronized (object2) {
                try {
                    int n = this.l.lastIndexOf(object);
                    Object var5_4 = null;
                    return n;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    throw throwable;
                }
            }
        }

        public ListIterator listIterator() {
            Object object = this.sync;
            synchronized (object) {
                try {
                    SynchronizedListIterator synchronizedListIterator = new SynchronizedListIterator(this.sync, this.l.listIterator());
                    Object var4_3 = null;
                    return synchronizedListIterator;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    throw throwable;
                }
            }
        }

        public ListIterator listIterator(int n) {
            Object object = this.sync;
            synchronized (object) {
                try {
                    SynchronizedListIterator synchronizedListIterator = new SynchronizedListIterator(this.sync, this.l.listIterator(n));
                    Object var5_4 = null;
                    return synchronizedListIterator;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    throw throwable;
                }
            }
        }

        public Object remove(int n) {
            Object object = this.sync;
            synchronized (object) {
                try {
                    Object object2 = this.l.remove(n);
                    Object var5_4 = null;
                    return object2;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    throw throwable;
                }
            }
        }

        public boolean remove(Object object) {
            Object object2 = this.sync;
            synchronized (object2) {
                try {
                    boolean bl = this.l.remove(object);
                    Object var5_4 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    throw throwable;
                }
            }
        }

        public Object set(int n, Object object) {
            Object object2 = this.sync;
            synchronized (object2) {
                try {
                    Object object3 = this.l.set(n, object);
                    Object var6_5 = null;
                    return object3;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    throw throwable;
                }
            }
        }

        public List subList(int n, int n2) {
            Object object = this.sync;
            synchronized (object) {
                try {
                    SynchronizedList synchronizedList = new SynchronizedList(this.l.subList(n, n2));
                    Object var6_5 = null;
                    return synchronizedList;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    throw throwable;
                }
            }
        }
    }

    static class SynchronizedCollection
    implements Collection,
    Serializable {
        Object sync;
        Collection c;

        public SynchronizedCollection(Collection collection) {
            this.sync = this;
            this.c = collection;
        }

        public SynchronizedCollection(Object object, Collection collection) {
            this.c = collection;
            this.sync = object;
        }

        public boolean add(Object object) {
            Object object2 = this.sync;
            synchronized (object2) {
                try {
                    boolean bl = this.c.add(object);
                    Object var5_4 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    throw throwable;
                }
            }
        }

        public boolean addAll(Collection collection) {
            Object object = this.sync;
            synchronized (object) {
                try {
                    boolean bl = this.c.addAll(collection);
                    Object var5_4 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    throw throwable;
                }
            }
        }

        public void clear() {
            Object object = this.sync;
            synchronized (object) {
                try {
                    this.c.clear();
                }
                finally {
                    Object var3_2 = null;
                }
                return;
            }
        }

        public boolean contains(Object object) {
            Object object2 = this.sync;
            synchronized (object2) {
                try {
                    boolean bl = this.c.contains(object);
                    Object var5_4 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    throw throwable;
                }
            }
        }

        public boolean containsAll(Collection collection) {
            Object object = this.sync;
            synchronized (object) {
                try {
                    boolean bl = this.c.containsAll(collection);
                    Object var5_4 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    throw throwable;
                }
            }
        }

        public boolean isEmpty() {
            Object object = this.sync;
            synchronized (object) {
                try {
                    boolean bl = this.c.isEmpty();
                    Object var4_3 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    throw throwable;
                }
            }
        }

        public Iterator iterator() {
            Object object = this.sync;
            synchronized (object) {
                try {
                    SynchronizedIterator synchronizedIterator = new SynchronizedIterator(this.sync, this.c.iterator());
                    Object var4_3 = null;
                    return synchronizedIterator;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    throw throwable;
                }
            }
        }

        public boolean remove(Object object) {
            Object object2 = this.sync;
            synchronized (object2) {
                try {
                    boolean bl = this.c.remove(object);
                    Object var5_4 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    throw throwable;
                }
            }
        }

        public boolean removeAll(Collection collection) {
            Object object = this.sync;
            synchronized (object) {
                try {
                    boolean bl = this.c.removeAll(collection);
                    Object var5_4 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    throw throwable;
                }
            }
        }

        public boolean retainAll(Collection collection) {
            Object object = this.sync;
            synchronized (object) {
                try {
                    boolean bl = this.c.retainAll(collection);
                    Object var5_4 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    throw throwable;
                }
            }
        }

        public int size() {
            Object object = this.sync;
            synchronized (object) {
                try {
                    int n = this.c.size();
                    Object var4_3 = null;
                    return n;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    throw throwable;
                }
            }
        }

        public Object[] toArray() {
            Object object = this.sync;
            synchronized (object) {
                try {
                    Object[] objectArray = this.c.toArray();
                    Object var4_3 = null;
                    return objectArray;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    throw throwable;
                }
            }
        }

        public Object[] toArray(Object[] objectArray) {
            Object object = this.sync;
            synchronized (object) {
                try {
                    Object[] objectArray2 = this.c.toArray(objectArray);
                    Object var5_4 = null;
                    return objectArray2;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    throw throwable;
                }
            }
        }

        public String toString() {
            Object object = this.sync;
            synchronized (object) {
                try {
                    String string = this.c.toString();
                    Object var4_3 = null;
                    return string;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    throw throwable;
                }
            }
        }
    }

    static class SynchronizedListIterator
    extends SynchronizedIterator
    implements ListIterator {
        private ListIterator li;

        public SynchronizedListIterator(Object object, ListIterator listIterator) {
            super(object, listIterator);
            this.li = listIterator;
        }

        public boolean hasPrevious() {
            Object object = this.sync;
            synchronized (object) {
                try {
                    boolean bl = this.li.hasPrevious();
                    Object var4_3 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    throw throwable;
                }
            }
        }

        public Object previous() {
            Object object = this.sync;
            synchronized (object) {
                try {
                    Object object2 = this.li.previous();
                    Object var4_3 = null;
                    return object2;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    throw throwable;
                }
            }
        }

        public int nextIndex() {
            Object object = this.sync;
            synchronized (object) {
                try {
                    int n = this.li.nextIndex();
                    Object var4_3 = null;
                    return n;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    throw throwable;
                }
            }
        }

        public int previousIndex() {
            Object object = this.sync;
            synchronized (object) {
                try {
                    int n = this.li.previousIndex();
                    Object var4_3 = null;
                    return n;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    throw throwable;
                }
            }
        }

        public void add(Object object) {
            Object object2 = this.sync;
            synchronized (object2) {
                try {
                    this.li.add(object);
                }
                finally {
                    Object var4_3 = null;
                }
                return;
            }
        }

        public void set(Object object) {
            Object object2 = this.sync;
            synchronized (object2) {
                try {
                    this.li.set(object);
                }
                finally {
                    Object var4_3 = null;
                }
                return;
            }
        }
    }

    static class SynchronizedIterator
    implements Iterator {
        Object sync;
        private Iterator i;

        public SynchronizedIterator(Object object, Iterator iterator) {
            this.sync = object;
            this.i = iterator;
        }

        public Object next() {
            Object object = this.sync;
            synchronized (object) {
                try {
                    Object object2 = this.i.next();
                    Object var4_3 = null;
                    return object2;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    throw throwable;
                }
            }
        }

        public boolean hasNext() {
            Object object = this.sync;
            synchronized (object) {
                try {
                    boolean bl = this.i.hasNext();
                    Object var4_3 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    throw throwable;
                }
            }
        }

        public void remove() {
            Object object = this.sync;
            synchronized (object) {
                try {
                    this.i.remove();
                }
                finally {
                    Object var3_2 = null;
                }
                return;
            }
        }
    }

    static class UnmodifiableSortedMap
    extends UnmodifiableMap
    implements SortedMap {
        private SortedMap sm;

        public UnmodifiableSortedMap(SortedMap sortedMap) {
            super(sortedMap);
            this.sm = sortedMap;
        }

        public Comparator comparator() {
            return this.sm.comparator();
        }

        public Object firstKey() {
            return this.sm.firstKey();
        }

        public Object lastKey() {
            return this.sm.lastKey();
        }

        public SortedMap headMap(Object object) {
            return new UnmodifiableSortedMap(this.sm.headMap(object));
        }

        public SortedMap tailMap(Object object) {
            return new UnmodifiableSortedMap(this.sm.tailMap(object));
        }

        public SortedMap subMap(Object object, Object object2) {
            return new UnmodifiableSortedMap(this.sm.subMap(object, object2));
        }
    }

    static class UnmodifiableMap
    implements Map,
    Serializable {
        Map m;

        public UnmodifiableMap(Map map) {
            this.m = map;
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean containsKey(Object object) {
            return this.m.containsKey(object);
        }

        public boolean containsValue(Object object) {
            return this.m.containsValue(object);
        }

        public Set entrySet() {
            return new UnmodifiableSet(this, this.m.entrySet()){
                private /* synthetic */ UnmodifiableMap this$1;
                {
                    this.this$1 = unmodifiableMap;
                    super(set);
                }

                static UnmodifiableMap access$0(10 var0) {
                    return var0.this$1;
                }

                public Iterator iterator() {
                    return new UnmodifiableIterator(this, this.c.iterator()){
                        private /* synthetic */ 10 this$2;
                        {
                            this.this$2 = var1_1;
                            super(iterator);
                        }

                        public Object next() {
                            Map.Entry entry = (Map.Entry)super.next();
                            return new Map.Entry(this, entry){
                                private /* synthetic */ 11 this$3;
                                private /* synthetic */ Map.Entry val$e;
                                {
                                    this.this$3 = var1_1;
                                    this.finit$(entry);
                                }

                                private /* synthetic */ void finit$(Map.Entry entry) {
                                    this.val$e = entry;
                                }

                                public Object getKey() {
                                    return this.val$e.getKey();
                                }

                                public Object getValue() {
                                    return this.val$e.getValue();
                                }

                                public Object setValue(Object object) {
                                    throw new UnsupportedOperationException();
                                }

                                public int hashCode() {
                                    return this.val$e.hashCode();
                                }

                                public boolean equals(Object object) {
                                    return this.val$e.equals(object);
                                }
                            };
                        }
                    };
                }
            };
        }

        public boolean equals(Object object) {
            return this.m.equals(object);
        }

        public Object get(Object object) {
            return this.m.get(object);
        }

        public Object put(Object object, Object object2) {
            throw new UnsupportedOperationException();
        }

        public int hashCode() {
            return this.m.hashCode();
        }

        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        public Set keySet() {
            return new UnmodifiableSet(this.m.keySet());
        }

        public void putAll(Map map) {
            throw new UnsupportedOperationException();
        }

        public Object remove(Object object) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return this.m.size();
        }

        public Collection values() {
            return new UnmodifiableCollection(this.m.values());
        }

        public String toString() {
            return this.m.toString();
        }
    }

    static class UnmodifiableSortedSet
    extends UnmodifiableSet
    implements SortedSet {
        private SortedSet ss;

        public UnmodifiableSortedSet(SortedSet sortedSet) {
            super(sortedSet);
            this.ss = sortedSet;
        }

        public Comparator comparator() {
            return this.ss.comparator();
        }

        public Object first() {
            return this.ss.first();
        }

        public Object last() {
            return this.ss.last();
        }

        public SortedSet headSet(Object object) {
            return new UnmodifiableSortedSet(this.ss.headSet(object));
        }

        public SortedSet tailSet(Object object) {
            return new UnmodifiableSortedSet(this.ss.tailSet(object));
        }

        public SortedSet subSet(Object object, Object object2) {
            return new UnmodifiableSortedSet(this.ss.subSet(object, object2));
        }
    }

    static class UnmodifiableSet
    extends UnmodifiableCollection
    implements Set {
        public UnmodifiableSet(Set set) {
            super(set);
        }

        public boolean equals(Object object) {
            return this.c.equals(object);
        }

        public int hashCode() {
            return this.c.hashCode();
        }
    }

    static class UnmodifiableList
    extends UnmodifiableCollection
    implements List {
        List l;

        public UnmodifiableList(List list) {
            super(list);
            this.l = list;
        }

        public void add(int n, Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int n, Collection collection) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object object) {
            return this.l.equals(object);
        }

        public Object get(int n) {
            return this.l.get(n);
        }

        public int hashCode() {
            return this.l.hashCode();
        }

        public int indexOf(Object object) {
            return this.l.indexOf(object);
        }

        public int lastIndexOf(Object object) {
            return this.l.lastIndexOf(object);
        }

        public ListIterator listIterator() {
            return new UnmodifiableListIterator(this.l.listIterator());
        }

        public ListIterator listIterator(int n) {
            return new UnmodifiableListIterator(this.l.listIterator(n));
        }

        public Object remove(int n) {
            throw new UnsupportedOperationException();
        }

        public Object set(int n, Object object) {
            throw new UnsupportedOperationException();
        }

        public List subList(int n, int n2) {
            return new UnmodifiableList(this.l.subList(n, n2));
        }
    }

    static class UnmodifiableCollection
    implements Collection,
    Serializable {
        Collection c;

        public UnmodifiableCollection(Collection collection) {
            this.c = collection;
        }

        public boolean add(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean contains(Object object) {
            return this.c.contains(object);
        }

        public boolean containsAll(Collection collection) {
            return this.c.containsAll(collection);
        }

        public boolean isEmpty() {
            return this.c.isEmpty();
        }

        public Iterator iterator() {
            return new UnmodifiableIterator(this.c.iterator());
        }

        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return this.c.size();
        }

        public Object[] toArray() {
            return this.c.toArray();
        }

        public Object[] toArray(Object[] objectArray) {
            return this.c.toArray(objectArray);
        }

        public String toString() {
            return this.c.toString();
        }
    }

    static class UnmodifiableListIterator
    extends UnmodifiableIterator
    implements ListIterator {
        private ListIterator li;

        public UnmodifiableListIterator(ListIterator listIterator) {
            super(listIterator);
            this.li = listIterator;
        }

        public boolean hasPrevious() {
            return this.li.hasPrevious();
        }

        public Object previous() {
            return this.li.previous();
        }

        public int nextIndex() {
            return this.li.nextIndex();
        }

        public int previousIndex() {
            return this.li.previousIndex();
        }

        public void add(Object object) {
            throw new UnsupportedOperationException();
        }

        public void set(Object object) {
            throw new UnsupportedOperationException();
        }
    }

    static class UnmodifiableIterator
    implements Iterator {
        private Iterator i;

        public UnmodifiableIterator(Iterator iterator) {
            this.i = iterator;
        }

        public Object next() {
            return this.i.next();
        }

        public boolean hasNext() {
            return this.i.hasNext();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class ReverseComparator
    implements Comparator,
    Serializable {
        public int compare(Object object, Object object2) {
            return -((Comparable)object).compareTo(object2);
        }

        ReverseComparator() {
        }
    }
}

