/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;

public class BitSet
implements Cloneable,
Serializable {
    long[] bits;
    private static final long serialVersionUID = 7997698588986878753L;

    public BitSet() {
        this(64);
    }

    public BitSet(int n) {
        if (n < 0) {
            throw new NegativeArraySizeException();
        }
        int n2 = n / 64;
        if (n % 64 != 0) {
            ++n2;
        }
        this.bits = new long[n2];
    }

    public void and(BitSet bitSet) {
        int n;
        int n2 = Math.min(this.bits.length, bitSet.bits.length);
        for (n = 0; n < n2; ++n) {
            this.bits[n] = this.bits[n] & bitSet.bits[n];
        }
        while (n < this.bits.length) {
            this.bits[n] = 0L;
            ++n;
        }
    }

    public void andNot(BitSet bitSet) {
        int n = Math.min(this.bits.length, bitSet.bits.length);
        for (int i = 0; i < n; ++i) {
            this.bits[i] = this.bits[i] & (bitSet.bits[i] ^ (long)-1);
        }
    }

    public void clear(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException();
        }
        int n2 = n % 64;
        int n3 = n / 64;
        this.ensure(n3);
        this.bits[n3] = this.bits[n3] & (1L << (n2 & 0x3F) ^ (long)-1);
    }

    public Object clone() {
        BitSet bitSet = new BitSet(this.bits.length * 64);
        System.arraycopy(this.bits, 0, bitSet.bits, 0, this.bits.length);
        return bitSet;
    }

    public boolean equals(Object object) {
        int n;
        if (!(object instanceof BitSet)) {
            return false;
        }
        BitSet bitSet = (BitSet)object;
        int n2 = Math.min(this.bits.length, bitSet.bits.length);
        for (int i = 0; i < n2; ++i) {
            if (this.bits[i] == bitSet.bits[i]) continue;
            return false;
        }
        for (n = i; n < this.bits.length; ++n) {
            if (this.bits[n] == 0L) continue;
            return false;
        }
        for (n = i; n < bitSet.bits.length; ++n) {
            if (bitSet.bits[n] == 0L) continue;
            return false;
        }
        return true;
    }

    public boolean get(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException();
        }
        int n2 = n % 64;
        int n3 = n / 64;
        if (n3 >= this.bits.length) {
            return false;
        }
        return (this.bits[n3] & 1L << (n2 & 0x3F)) != 0L;
    }

    public int hashCode() {
        long l = 1234;
        for (int i = this.bits.length - 1; i >= 0; --i) {
            l ^= this.bits[i] * (long)(i + 1);
        }
        return (int)(l >> 32) ^ (int)l;
    }

    public int length() {
        int n;
        for (n = this.bits.length - 1; n >= 0 && this.bits[n] == 0L; --n) {
        }
        if (n < 0) {
            return 0;
        }
        int n2 = (n + 1) * 64;
        for (long i = this.bits[n]; i >= 0L; i <<= 1) {
            --n2;
        }
        return n2;
    }

    public void or(BitSet bitSet) {
        this.ensure(bitSet.bits.length - 1);
        for (int i = 0; i < bitSet.bits.length; ++i) {
            this.bits[i] = this.bits[i] | bitSet.bits[i];
        }
    }

    public void set(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException();
        }
        int n2 = n % 64;
        int n3 = n / 64;
        this.ensure(n3);
        this.bits[n3] = this.bits[n3] | 1L << (n2 & 0x3F);
    }

    public int size() {
        return this.bits.length * 64;
    }

    public String toString() {
        String string = "{";
        boolean bl = true;
        for (int i = 0; i < this.bits.length; ++i) {
            long l = 1L;
            long l2 = this.bits[i];
            if (l2 == 0L) continue;
            for (int j = 0; j < 64; ++j) {
                if ((l2 & l) != 0L) {
                    if (!bl) {
                        string = string + ", ";
                    }
                    string = string + Integer.toString(64 * i + j);
                    bl = false;
                }
                l <<= 1;
            }
        }
        string = string + "}";
        return string;
    }

    public void xor(BitSet bitSet) {
        this.ensure(bitSet.bits.length - 1);
        for (int i = 0; i < bitSet.bits.length; ++i) {
            this.bits[i] = this.bits[i] ^ bitSet.bits[i];
        }
    }

    private final void ensure(int n) {
        if (n + 1 > this.bits.length) {
            long[] lArray = new long[n + 1];
            System.arraycopy(this.bits, 0, lArray, 0, this.bits.length);
            this.bits = lArray;
        }
    }
}

