/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ArrayList
extends AbstractList
implements List,
Cloneable,
Serializable {
    private static final int DEFAULT_CAPACITY = 16;
    int size;
    transient Object[] data;

    public ArrayList(int n) {
        this.data = new Object[n];
    }

    public ArrayList() {
        this(16);
    }

    public ArrayList(Collection collection) {
        this((int)((double)collection.size() * 1.1));
        this.addAll(collection);
    }

    public void ensureCapacity(int n) {
        int n2 = this.data.length;
        if (n > n2) {
            Object[] objectArray = new Object[Math.max(n2 * 2, n)];
            System.arraycopy(this.data, 0, objectArray, 0, this.size);
            this.data = objectArray;
        }
    }

    public boolean add(Object object) {
        ++this.modCount;
        if (this.size == this.data.length) {
            this.ensureCapacity(this.size + 1);
        }
        this.data[this.size++] = object;
        return true;
    }

    public Object get(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size:" + this.size);
        }
        return this.data[n];
    }

    public int size() {
        return this.size;
    }

    public Object remove(int n) {
        ++this.modCount;
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size:" + this.size);
        }
        Object object = this.data[n];
        if (n != (this.size += -1)) {
            System.arraycopy(this.data, n + 1, this.data, n, this.size - n);
        }
        this.data[this.size] = null;
        return object;
    }

    protected void removeRange(int n, int n2) {
        ++this.modCount;
        if (n != n2) {
            System.arraycopy(this.data, n2, this.data, n, this.size - n2);
            this.size -= n2 - n;
        }
    }

    public void add(int n, Object object) {
        ++this.modCount;
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size:" + this.size);
        }
        if (this.size == this.data.length) {
            this.ensureCapacity(this.size + 1);
        }
        if (n != this.size) {
            System.arraycopy(this.data, n, this.data, n + 1, this.size - n);
        }
        this.data[n] = object;
        ++this.size;
    }

    public boolean addAll(Collection collection) {
        return this.addAll(this.size, collection);
    }

    public boolean addAll(int n, Collection collection) {
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size:" + this.size);
        }
        ++this.modCount;
        Iterator iterator = collection.iterator();
        int n2 = collection.size();
        if (n2 + this.size > this.data.length) {
            this.ensureCapacity(this.size + n2);
        }
        int n3 = n + n2;
        if (this.size > 0 && n != this.size) {
            System.arraycopy(this.data, n, this.data, n3, n2);
        }
        this.size += n2;
        while (n < n3) {
            this.data[n] = iterator.next();
            ++n;
        }
        return n2 > 0;
    }

    public Object clone() {
        ArrayList arrayList = null;
        try {
            arrayList = (ArrayList)super.clone();
            arrayList.data = new Object[this.data.length];
            System.arraycopy(this.data, 0, arrayList.data, 0, this.size);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return arrayList;
    }

    public boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    public int indexOf(Object object) {
        for (int i = 0; i < this.size; ++i) {
            if (!(object == null ? this.data[i] == null : object.equals(this.data[i]))) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(Object object) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (!(object == null ? this.data[i] == null : object.equals(this.data[i]))) continue;
            return i;
        }
        return -1;
    }

    public void clear() {
        ++this.modCount;
        for (int i = 0; i < this.size; ++i) {
            this.data[i] = null;
        }
        this.size = 0;
    }

    public Object set(int n, Object object) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size:" + this.size);
        }
        Object object2 = this.data[n];
        this.data[n] = object;
        return object2;
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.size];
        System.arraycopy(this.data, 0, objectArray, 0, this.size);
        return objectArray;
    }

    public Object[] toArray(Object[] objectArray) {
        if (objectArray.length < this.size) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.size);
        } else if (objectArray.length > this.size) {
            objectArray[this.size] = null;
        }
        System.arraycopy(this.data, 0, objectArray, 0, this.size);
        return objectArray;
    }

    public void trimToSize() {
        Object[] objectArray = new Object[this.size];
        System.arraycopy(this.data, 0, objectArray, 0, this.size);
        this.data = objectArray;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.data.length);
        for (int i = 0; i < this.data.length; ++i) {
            objectOutputStream.writeObject(this.data[i]);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.data = new Object[n];
        for (int i = 0; i < n; ++i) {
            this.data[i] = objectInputStream.readObject();
        }
    }
}

