/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;

public abstract class AbstractCollection
implements Collection {
    public abstract Iterator iterator();

    public abstract int size();

    public boolean add(Object object) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(Collection collection) {
        Iterator iterator = collection.iterator();
        int n = collection.size();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            bl |= this.add(iterator.next());
        }
        return bl;
    }

    public void clear() {
        Iterator iterator = this.iterator();
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            iterator.next();
            iterator.remove();
        }
    }

    public boolean contains(Object object) {
        Iterator iterator = this.iterator();
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (!(object == null ? iterator.next() == null : object.equals(iterator.next()))) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(Collection collection) {
        Iterator iterator = collection.iterator();
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean remove(Object object) {
        Iterator iterator = this.iterator();
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (!(object == null ? iterator.next() == null : object.equals(iterator.next()))) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public boolean removeAll(Collection collection) {
        Iterator iterator = this.iterator();
        int n = this.size();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            if (!collection.contains(iterator.next())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    public boolean retainAll(Collection collection) {
        Iterator iterator = this.iterator();
        int n = this.size();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            if (collection.contains(iterator.next())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    public Object[] toArray() {
        Iterator iterator = this.iterator();
        Object[] objectArray = new Object[this.size()];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = iterator.next();
        }
        return objectArray;
    }

    public Object[] toArray(Object[] objectArray) {
        int n = this.size();
        if (objectArray.length < n) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
        }
        Iterator iterator = this.iterator();
        for (int i = 0; i < n; ++i) {
            objectArray[i] = iterator.next();
        }
        if (objectArray.length > n) {
            objectArray[n] = null;
        }
        return objectArray;
    }

    public String toString() {
        Iterator iterator = this.iterator();
        int n = this.size();
        StringBuffer stringBuffer = new StringBuffer("[");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(iterator.next());
            if (i >= n - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

