/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.CharacterIterator;

public final class StringCharacterIterator
implements CharacterIterator {
    private String text;
    private int pos;
    private int begin;
    private int end;

    public Object clone() {
        return new StringCharacterIterator(this.text, this.begin, this.end, this.pos);
    }

    public char current() {
        if (this.pos < this.end) {
            return this.text.charAt(this.pos);
        }
        return '\uffff';
    }

    public boolean equals(Object object) {
        if (!(object instanceof StringCharacterIterator)) {
            return false;
        }
        StringCharacterIterator stringCharacterIterator = (StringCharacterIterator)object;
        return this.pos == stringCharacterIterator.pos && this.begin == stringCharacterIterator.begin && this.end == stringCharacterIterator.end && this.text.equals(stringCharacterIterator.text);
    }

    public char first() {
        this.pos = this.begin;
        return this.current();
    }

    public int getBeginIndex() {
        return this.begin;
    }

    public int getEndIndex() {
        return this.end;
    }

    public int getIndex() {
        return this.pos;
    }

    public int hashCode() {
        return this.text.hashCode() + this.pos + this.begin + this.end;
    }

    public char last() {
        this.pos = this.end;
        return this.current();
    }

    public char next() {
        if (this.pos == this.end) {
            return '\uffff';
        }
        ++this.pos;
        return this.current();
    }

    public char previous() {
        if (this.pos == this.begin) {
            return '\uffff';
        }
        this.pos += -1;
        return this.current();
    }

    public char setIndex(int n) {
        if (n < this.begin || n > this.end) {
            throw new IllegalArgumentException();
        }
        this.pos = n;
        return this.current();
    }

    public StringCharacterIterator(String string) {
        this(string, 0, string.length(), 0);
    }

    public StringCharacterIterator(String string, int n) {
        this(string, 0, string.length(), n);
    }

    public StringCharacterIterator(String string, int n, int n2, int n3) {
        if (n < 0 || n > n2 || n2 > string.length() || n3 < n || n3 > n2) {
            throw new IllegalArgumentException();
        }
        this.text = string;
        this.begin = n;
        this.end = n2;
        this.pos = n3;
    }

    public void setText(String string) {
        this.text = string;
        this.begin = 0;
        this.end = string.length();
        this.pos = 0;
    }
}

