/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.Vector;

public class SimpleDateFormat
extends DateFormat {
    private transient Vector tokens;
    private DateFormatSymbols formatData;
    private Date defaultCenturyStart;
    private String pattern;
    private int serialVersionOnStream;
    private static final long serialVersionUID = 4774881970558875024L;
    private static final String standardChars = "GyMdkHmsSEDFwWahKz";

    private /* synthetic */ void finit$() {
        this.defaultCenturyStart = new Date(System.currentTimeMillis() - 1734197248L);
        this.serialVersionOnStream = 1;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        if (this.serialVersionOnStream < 1) {
            this.defaultCenturyStart = new Date(System.currentTimeMillis() - 1734197248L);
            this.serialVersionOnStream = 1;
        }
        this.tokens = new Vector();
        this.compileFormat(this.pattern);
    }

    private void compileFormat(String string) {
        FieldSizePair fieldSizePair = null;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            int n = this.formatData.getLocalPatternChars().indexOf(c);
            if (n == -1) {
                fieldSizePair = null;
                if (Character.isLetter(c)) {
                    this.tokens.addElement(new FieldSizePair(this, -1, 0));
                    continue;
                }
                if (c == '\'') {
                    int n2 = string.indexOf(39, i + 1);
                    if (n2 == -1) {
                        this.tokens.addElement(new FieldSizePair(this, -1, 0));
                    }
                    if (n2 + 1 < string.length() && string.charAt(n2 + 1) == '\'') {
                        this.tokens.addElement(string.substring(i + 1, n2 + 1));
                    } else {
                        this.tokens.addElement(string.substring(i + 1, n2));
                    }
                    i = n2;
                    continue;
                }
                this.tokens.addElement(new Character(c));
                continue;
            }
            if (fieldSizePair != null && n == fieldSizePair.field) {
                ++fieldSizePair.size;
                continue;
            }
            fieldSizePair = new FieldSizePair(this, n, 1);
            this.tokens.addElement(fieldSizePair);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.tokens.elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(enumeration.nextElement().toString());
        }
        return stringBuffer.toString();
    }

    public SimpleDateFormat() {
        this.finit$();
        Locale locale = Locale.getDefault();
        this.calendar = new GregorianCalendar(locale);
        this.tokens = new Vector();
        this.formatData = new DateFormatSymbols(locale);
        this.pattern = this.formatData.dateFormats[2] + ' ' + this.formatData.timeFormats[2];
        this.compileFormat(this.pattern);
        this.numberFormat = NumberFormat.getInstance(locale);
    }

    public SimpleDateFormat(String string) {
        this(string, Locale.getDefault());
    }

    public SimpleDateFormat(String string, Locale locale) {
        this.finit$();
        this.calendar = new GregorianCalendar(locale);
        this.tokens = new Vector();
        this.formatData = new DateFormatSymbols(locale);
        this.compileFormat(string);
        this.pattern = string;
        this.numberFormat = NumberFormat.getInstance(locale);
    }

    public SimpleDateFormat(String string, DateFormatSymbols dateFormatSymbols) {
        this.finit$();
        this.calendar = new GregorianCalendar();
        this.calendar.setTimeZone(TimeZone.getDefault());
        this.tokens = new Vector();
        this.formatData = dateFormatSymbols;
        this.compileFormat(string);
        this.pattern = string;
        this.numberFormat = NumberFormat.getInstance();
    }

    public String toPattern() {
        return this.pattern;
    }

    public String toLocalizedPattern() {
        String string = this.formatData.getLocalPatternChars();
        return this.applyLocalizedPattern(this.pattern, standardChars, string);
    }

    public void applyPattern(String string) {
        this.tokens = new Vector();
        this.compileFormat(string);
        this.pattern = string;
    }

    public void applyLocalizedPattern(String string) {
        String string2 = this.formatData.getLocalPatternChars();
        string = this.applyLocalizedPattern(string, string2, standardChars);
        this.applyPattern(string);
    }

    private String applyLocalizedPattern(String string, String string2, String string3) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            int n2;
            char c = string.charAt(i);
            if (c == '\'') {
                bl ^= true;
            }
            if (!bl && (n2 = string2.indexOf(c)) >= 0) {
                c = string3.charAt(n2);
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public Date get2DigitYearStart() {
        return this.defaultCenturyStart;
    }

    public void set2DigitYearStart(Date date) {
        this.defaultCenturyStart = date;
    }

    public DateFormatSymbols getDateFormatSymbols() {
        return this.formatData;
    }

    public void setDateFormatSymbols(DateFormatSymbols dateFormatSymbols) {
        this.formatData = dateFormatSymbols;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof SimpleDateFormat)) {
            return false;
        }
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)object;
        if (!this.toPattern().equals(simpleDateFormat.toPattern())) {
            return false;
        }
        if (!this.get2DigitYearStart().equals(simpleDateFormat.get2DigitYearStart())) {
            return false;
        }
        return this.getDateFormatSymbols().equals(simpleDateFormat.getDateFormatSymbols());
    }

    public StringBuffer format(Date date, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        Calendar calendar = (Calendar)this.calendar.clone();
        calendar.setTime(date);
        Enumeration enumeration = this.tokens.elements();
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            if (object instanceof FieldSizePair) {
                FieldSizePair fieldSizePair = (FieldSizePair)object;
                int n = stringBuffer.length();
                switch (fieldSizePair.field) {
                    case 0: {
                        stringBuffer.append(this.formatData.eras[calendar.get(0)]);
                        break;
                    }
                    case 1: {
                        String string = String.valueOf(calendar.get(1));
                        if (fieldSizePair.size < 4) {
                            stringBuffer.append(string.substring(string.length() - 2));
                            break;
                        }
                        stringBuffer.append(string);
                        break;
                    }
                    case 2: {
                        if (fieldSizePair.size < 3) {
                            this.withLeadingZeros(calendar.get(2) + 1, fieldSizePair.size, stringBuffer);
                            break;
                        }
                        if (fieldSizePair.size < 4) {
                            stringBuffer.append(this.formatData.shortMonths[calendar.get(2)]);
                            break;
                        }
                        stringBuffer.append(this.formatData.months[calendar.get(2)]);
                        break;
                    }
                    case 3: {
                        this.withLeadingZeros(calendar.get(5), fieldSizePair.size, stringBuffer);
                        break;
                    }
                    case 4: {
                        this.withLeadingZeros((calendar.get(11) + 23) % 24 + 1, fieldSizePair.size, stringBuffer);
                        break;
                    }
                    case 5: {
                        this.withLeadingZeros(calendar.get(11), fieldSizePair.size, stringBuffer);
                        break;
                    }
                    case 6: {
                        this.withLeadingZeros(calendar.get(12), fieldSizePair.size, stringBuffer);
                        break;
                    }
                    case 7: {
                        this.withLeadingZeros(calendar.get(13), fieldSizePair.size, stringBuffer);
                        break;
                    }
                    case 8: {
                        this.withLeadingZeros(calendar.get(14), fieldSizePair.size, stringBuffer);
                        break;
                    }
                    case 9: {
                        if (fieldSizePair.size < 4) {
                            stringBuffer.append(this.formatData.shortWeekdays[calendar.get(7)]);
                            break;
                        }
                        stringBuffer.append(this.formatData.weekdays[calendar.get(7)]);
                        break;
                    }
                    case 10: {
                        this.withLeadingZeros(calendar.get(6), fieldSizePair.size, stringBuffer);
                        break;
                    }
                    case 11: {
                        this.withLeadingZeros(calendar.get(8), fieldSizePair.size, stringBuffer);
                        break;
                    }
                    case 12: {
                        this.withLeadingZeros(calendar.get(3), fieldSizePair.size, stringBuffer);
                        break;
                    }
                    case 13: {
                        this.withLeadingZeros(calendar.get(4), fieldSizePair.size, stringBuffer);
                        break;
                    }
                    case 14: {
                        stringBuffer.append(this.formatData.ampms[calendar.get(9)]);
                        break;
                    }
                    case 15: {
                        this.withLeadingZeros((calendar.get(10) + 11) % 12 + 1, fieldSizePair.size, stringBuffer);
                        break;
                    }
                    case 16: {
                        this.withLeadingZeros(calendar.get(10), fieldSizePair.size, stringBuffer);
                        break;
                    }
                    case 17: {
                        TimeZone timeZone = calendar.getTimeZone();
                        boolean bl = calendar.get(16) != 0;
                        String string = timeZone.getDisplayName(bl, fieldSizePair.size > 3 ? 1 : 0);
                        stringBuffer.append(string);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Illegal pattern character");
                    }
                }
                if (fieldPosition == null || fieldSizePair.field != fieldPosition.getField()) continue;
                fieldPosition.setBeginIndex(n);
                fieldPosition.setEndIndex(stringBuffer.length());
                continue;
            }
            stringBuffer.append(object.toString());
        }
        return stringBuffer;
    }

    private void withLeadingZeros(int n, int n2, StringBuffer stringBuffer) {
        String string = String.valueOf(n);
        n2 -= string.length();
        while (n2 > 0) {
            stringBuffer.append('0');
            --n2;
        }
        stringBuffer.append(string);
    }

    private final boolean expect(String string, ParsePosition parsePosition, char c) {
        boolean bl;
        int n = parsePosition.getIndex();
        boolean bl2 = bl = n < string.length() && string.charAt(n) == c;
        if (bl) {
            parsePosition.setIndex(n + 1);
        } else {
            parsePosition.setErrorIndex(n);
        }
        return bl;
    }

    public Date parse(String string, ParsePosition parsePosition) {
        int n = this.pattern.length();
        this.calendar.clear();
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            char c = this.pattern.charAt(i);
            if (c == '\'') {
                n7 = parsePosition.getIndex();
                if (i < n - 1 && this.pattern.charAt(i + 1) == '\'') {
                    if (!this.expect(string, parsePosition, c)) {
                        return null;
                    }
                    ++i;
                    continue;
                }
                n2 = n2 < 0 ? i : -1;
                continue;
            }
            if (n2 != -1 || (c < 'a' || c > 'z') && (c < 'A' || c > 'Z')) {
                if (this.expect(string, parsePosition, c)) continue;
                return null;
            }
            n7 = i;
            while (++i < n && this.pattern.charAt(i) == c) {
            }
            int n8 = i - n7;
            --i;
            boolean bl = true;
            String[] stringArray = null;
            int n9 = 0;
            int n10 = 0;
            switch (c) {
                case 'd': {
                    n6 = 5;
                    break;
                }
                case 'D': {
                    n6 = 6;
                    break;
                }
                case 'F': {
                    n6 = 8;
                    break;
                }
                case 'E': {
                    bl = false;
                    n9 = 1;
                    n6 = 7;
                    stringArray = n8 <= 3 ? this.formatData.getShortWeekdays() : this.formatData.getWeekdays();
                    break;
                }
                case 'w': {
                    n6 = 3;
                    break;
                }
                case 'W': {
                    n6 = 4;
                    break;
                }
                case 'M': {
                    n6 = 2;
                    if (n8 <= 2) {
                        n9 = -1;
                        break;
                    }
                    bl = false;
                    stringArray = n8 <= 3 ? this.formatData.getShortMonths() : this.formatData.getMonths();
                    break;
                }
                case 'y': {
                    n6 = 1;
                    if (n8 > 2) break;
                    n9 = 1900;
                    break;
                }
                case 'K': {
                    n6 = 10;
                    break;
                }
                case 'h': {
                    n6 = 10;
                    break;
                }
                case 'H': {
                    n6 = 11;
                    break;
                }
                case 'k': {
                    n6 = 11;
                    break;
                }
                case 'm': {
                    n6 = 12;
                    break;
                }
                case 's': {
                    n6 = 13;
                    break;
                }
                case 'S': {
                    n6 = 14;
                    break;
                }
                case 'a': {
                    bl = false;
                    n6 = 9;
                    stringArray = this.formatData.getAmPmStrings();
                    break;
                }
                case 'z': {
                    bl = false;
                    n6 = 16;
                    String[][] stringArray2 = this.formatData.getZoneStrings();
                    n5 = stringArray2.length;
                    n4 = parsePosition.getIndex();
                    boolean bl2 = false;
                    for (int j = 0; j < n5; ++j) {
                        int n11;
                        String[] stringArray3 = stringArray2[j];
                        for (n11 = 1; n11 < stringArray3.length && !string.startsWith(stringArray3[n11], n4); ++n11) {
                        }
                        if (n11 == stringArray3.length) continue;
                        if (n11 > 2) {
                            // empty if block
                        }
                        n10 = 0;
                        this.calendar.setTimeZone(new SimpleTimeZone(1, stringArray3[0]));
                        parsePosition.setIndex(n4 + stringArray3[n11].length());
                        break;
                    }
                    if (bl2) break;
                    parsePosition.setErrorIndex(parsePosition.getIndex());
                    return null;
                }
                default: {
                    parsePosition.setErrorIndex(parsePosition.getIndex());
                    return null;
                }
            }
            if (bl) {
                this.numberFormat.setMinimumIntegerDigits(n8);
                Number number = this.numberFormat.parse(string, parsePosition);
                if (parsePosition == null || !(number instanceof Long)) {
                    return null;
                }
                n3 = number.intValue() + n9;
            } else if (stringArray != null) {
                n5 = parsePosition.getIndex();
                for (n4 = n9; n4 < stringArray.length && !string.startsWith(stringArray[n4], n5); ++n4) {
                }
                if (n4 == stringArray.length) {
                    parsePosition.setErrorIndex(n5);
                    return null;
                }
                parsePosition.setIndex(n5 + stringArray[n4].length());
                n3 = n4;
            } else {
                n3 = n10;
            }
            this.calendar.set(n6, n3);
        }
        try {
            return this.calendar.getTime();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            parsePosition.setErrorIndex(parsePosition.getIndex());
            return null;
        }
    }

    class FieldSizePair {
        private /* synthetic */ SimpleDateFormat this$0;
        public int field;
        public int size;

        public FieldSizePair(SimpleDateFormat simpleDateFormat, int n, int n2) {
            this.this$0 = simpleDateFormat;
            this.field = n;
            this.size = n2;
        }
    }
}

