/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.CharacterIterator;
import java.text.CollationElementIterator;
import java.text.CollationKey;
import java.text.Collator;
import java.text.ParseException;
import java.text.RBCElement;
import java.util.Hashtable;
import java.util.Vector;

public class RuleBasedCollator
extends Collator {
    private boolean frenchAccents;
    private String rules;
    private Hashtable map;
    private Hashtable prefixes;

    public Object clone() {
        return new RuleBasedCollator(this);
    }

    int ceiNext(CollationElementIterator collationElementIterator) {
        int n;
        if (collationElementIterator.lookahead_set) {
            collationElementIterator.lookahead_set = false;
            return collationElementIterator.lookahead;
        }
        int n2 = collationElementIterator.index;
        int n3 = collationElementIterator.text.length();
        String string = null;
        boolean bl = false;
        for (n = n2 + 1; n <= n3 && this.prefixes.get(string = collationElementIterator.text.substring(n2, n)) != null; ++n) {
            bl = true;
        }
        Object object = this.map.get(string);
        while (bl && object == null && string.length() > 1) {
            string = collationElementIterator.text.substring(n2, --n);
            object = this.map.get(string);
        }
        collationElementIterator.index = n;
        if (object == null) {
            collationElementIterator.lookahead_set = true;
            collationElementIterator.lookahead = string.charAt(0) << 8;
            return 0x7FFF0000;
        }
        return (Integer)object;
    }

    static final int next(CollationElementIterator collationElementIterator, int n) {
        int n2;
        do {
            int n3;
            if ((n3 = collationElementIterator.next()) == -1) {
                return n3;
            }
            n2 = 0;
            switch (n) {
                case 0: {
                    n2 = n3 & 0xFFFF0000;
                    break;
                }
                case 1: {
                    n2 = n3 & 0xFFFFFF00;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = n3;
                }
            }
        } while (n2 == 0);
        return n2;
    }

    public int compare(String string, String string2) {
        block2: {
            int n;
            int n2;
            CollationElementIterator collationElementIterator = new CollationElementIterator(string, this);
            CollationElementIterator collationElementIterator2 = new CollationElementIterator(string2, this);
            do {
                n2 = RuleBasedCollator.next(collationElementIterator, this.strength);
                n = RuleBasedCollator.next(collationElementIterator2, this.strength);
                if (n2 == -1 && n == -1) break block2;
                if (n2 == -1) {
                    return -1;
                }
                if (n != -1) continue;
                return 1;
            } while (n2 == n);
            return n2 - n;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof RuleBasedCollator) || !super.equals(object)) {
            return false;
        }
        RuleBasedCollator ruleBasedCollator = (RuleBasedCollator)object;
        return this.frenchAccents == ruleBasedCollator.frenchAccents && this.rules.equals(ruleBasedCollator.rules);
    }

    public CollationElementIterator getCollationElementIterator(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            this.decomposeCharacter(string.charAt(i), stringBuffer);
        }
        return new CollationElementIterator(stringBuffer.toString(), this);
    }

    public CollationElementIterator getCollationElementIterator(CharacterIterator characterIterator) {
        StringBuffer stringBuffer = new StringBuffer();
        char c = characterIterator.first();
        while (c != '\uffff') {
            this.decomposeCharacter(c, stringBuffer);
            c = characterIterator.next();
        }
        return new CollationElementIterator(stringBuffer.toString(), this);
    }

    public CollationKey getCollationKey(String string) {
        return new CollationKey(this.getCollationElementIterator(string), string, this.strength);
    }

    public String getRules() {
        return this.rules;
    }

    public int hashCode() {
        if (this.frenchAccents) {
            return 1231;
        }
        return 0x4D5 ^ this.rules.hashCode() ^ this.map.hashCode() ^ this.prefixes.hashCode();
    }

    private final boolean is_special(char c) {
        return c > '\b' && c <= '\r' || c > '\u001f' && c <= '/' || c > '9' && c <= '@' || c > 'Z' && c <= '`' || c > 'z' && c <= '~';
    }

    private final int text_argument(String string, int n, StringBuffer stringBuffer) {
        stringBuffer.setLength(0);
        int n2 = string.length();
        while (n < n2) {
            char c = string.charAt(n);
            if (c == '\'' && n + 2 < n2 && string.charAt(n + 2) == '\'' && this.is_special(string.charAt(n + 1))) {
                n += 2;
            } else if (this.is_special(c) || Character.isWhitespace(c)) {
                return n;
            }
            stringBuffer.append(c);
            ++n;
        }
        return n;
    }

    public RuleBasedCollator(String string) throws ParseException {
        Object object;
        int n;
        char c;
        int n2;
        this.rules = string;
        this.frenchAccents = false;
        int n3 = 0;
        Vector vector = new Vector();
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = string.length();
        for (n2 = 0; n2 < n4; ++n2) {
            c = string.charAt(n2);
            if (Character.isWhitespace(c)) continue;
            if (c == '@') {
                this.frenchAccents = true;
                continue;
            }
            if (c != '<' && c != ';' && c != ',' && c != '=' && c != '&') {
                throw new ParseException("invalid character", n2);
            }
            ++n2;
            while (n2 < n4 && Character.isWhitespace(string.charAt(n2))) {
                ++n2;
            }
            if (n2 == n4) {
                throw new ParseException("missing argument", n2);
            }
            n = n2;
            n2 = this.text_argument(string, n2, stringBuffer);
            if (stringBuffer.length() == 0) {
                throw new ParseException("invalid character", n);
            }
            object = stringBuffer.toString();
            int n5 = vector.indexOf(object);
            if (c != '&') {
                if (n5 != -1) {
                    vector.removeElementAt(n5);
                    if (n3 >= n5) {
                        --n3;
                    }
                }
                RBCElement rBCElement = new RBCElement((String)object, c);
                vector.insertElementAt(rBCElement, n3);
                ++n3;
            } else {
                if (n5 == -1) {
                    throw new ParseException("argument to reset not previously seen", n);
                }
                n3 = n5 + 1;
            }
            --n2;
        }
        n2 = 0;
        c = '\u0000';
        n = 0;
        this.map = new Hashtable();
        this.prefixes = new Hashtable();
        object = vector.elements();
        while (object.hasMoreElements()) {
            RBCElement rBCElement = (RBCElement)object.nextElement();
            switch (rBCElement.relation) {
                case '<': {
                    ++n2;
                    c = '\u0000';
                    n = 0;
                    break;
                }
                case ';': {
                    ++c;
                    n = 0;
                    break;
                }
                case ',': {
                    ++n;
                    break;
                }
            }
            this.map.put(rBCElement.key, new Integer(n2 << 16 | c << 8 | n));
            for (int i = rBCElement.key.length() - 1; i >= 1; --i) {
                this.prefixes.put(rBCElement.key.substring(0, i), Boolean.TRUE);
            }
        }
    }

    private RuleBasedCollator(RuleBasedCollator ruleBasedCollator) {
        this.frenchAccents = ruleBasedCollator.frenchAccents;
        this.rules = ruleBasedCollator.rules;
        this.decmp = ruleBasedCollator.decmp;
        this.strength = ruleBasedCollator.strength;
        this.map = ruleBasedCollator.map;
        this.prefixes = ruleBasedCollator.prefixes;
    }
}

