/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class NumberFormat
extends Format
implements Cloneable {
    public static final int INTEGER_FIELD = 0;
    public static final int FRACTION_FIELD = 1;
    boolean groupingUsed;
    int maximumFractionDigits;
    private byte maxFractionDigits;
    int maximumIntegerDigits;
    private byte maxIntegerDigits;
    int minimumFractionDigits;
    private byte minFractionDigits;
    int minimumIntegerDigits;
    private byte minIntegerDigits;
    boolean parseIntegerOnly;
    private int serialVersionOnStream;
    private static final long serialVersionUID = -2308460125733713944L;

    public final String format(long l) {
        StringBuffer stringBuffer = new StringBuffer(50);
        this.format(l, stringBuffer, (FieldPosition)null);
        return stringBuffer.toString();
    }

    public final StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (object instanceof Number) {
            return this.format(((Number)object).doubleValue(), stringBuffer, fieldPosition);
        }
        throw new IllegalArgumentException("Cannot format given Object as a Number");
    }

    public abstract StringBuffer format(double var1, StringBuffer var3, FieldPosition var4);

    public abstract StringBuffer format(long var1, StringBuffer var3, FieldPosition var4);

    public Object clone() {
        return super.clone();
    }

    public boolean equals(Object object) {
        if (!(object instanceof NumberFormat)) {
            return false;
        }
        NumberFormat numberFormat = (NumberFormat)object;
        return this.groupingUsed == numberFormat.groupingUsed && this.maximumFractionDigits == numberFormat.maximumFractionDigits && this.maximumIntegerDigits == numberFormat.maximumIntegerDigits && this.minimumFractionDigits == numberFormat.minimumFractionDigits && this.minimumIntegerDigits == numberFormat.minimumIntegerDigits && this.parseIntegerOnly == numberFormat.parseIntegerOnly;
    }

    public static Locale[] getAvailableLocales() {
        return null;
    }

    private static final NumberFormat computeInstance(Locale locale, String string, String string2) {
        String string3;
        ResourceBundle resourceBundle;
        try {
            resourceBundle = ResourceBundle.getBundle("gnu.gcj.text.LocaleData", locale);
        }
        catch (MissingResourceException missingResourceException) {
            resourceBundle = null;
        }
        try {
            string3 = resourceBundle == null ? string2 : resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            string3 = string2;
        }
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(locale);
        return new DecimalFormat(string3, decimalFormatSymbols);
    }

    public static final NumberFormat getCurrencyInstance() {
        return NumberFormat.getCurrencyInstance(Locale.getDefault());
    }

    public static NumberFormat getCurrencyInstance(Locale locale) {
        return NumberFormat.computeInstance(locale, "currencyFormat", "$#,##0.00;($#,##0.00)");
    }

    public static final NumberFormat getInstance() {
        return NumberFormat.getInstance(Locale.getDefault());
    }

    public static NumberFormat getInstance(Locale locale) {
        return NumberFormat.getNumberInstance(locale);
    }

    public int getMaximumFractionDigits() {
        return this.maximumFractionDigits;
    }

    public int getMaximumIntegerDigits() {
        return this.maximumIntegerDigits;
    }

    public int getMinimumFractionDigits() {
        return this.minimumFractionDigits;
    }

    public int getMinimumIntegerDigits() {
        return this.minimumIntegerDigits;
    }

    public static final NumberFormat getNumberInstance() {
        return NumberFormat.getNumberInstance(Locale.getDefault());
    }

    public static NumberFormat getNumberInstance(Locale locale) {
        return NumberFormat.computeInstance(locale, "numberFormat", "#,##0.###");
    }

    public static final NumberFormat getPercentInstance() {
        return NumberFormat.getPercentInstance(Locale.getDefault());
    }

    public static NumberFormat getPercentInstance(Locale locale) {
        return NumberFormat.computeInstance(locale, "percentFormat", "#,##0%");
    }

    public int hashCode() {
        int n = super.hashCode();
        n ^= this.maximumFractionDigits + this.maximumIntegerDigits + this.minimumFractionDigits + this.minimumIntegerDigits;
        if (this.groupingUsed) {
            n ^= 0xF0F0;
        }
        if (this.parseIntegerOnly) {
            n ^= 0xF0F;
        }
        return n;
    }

    public boolean isGroupingUsed() {
        return this.groupingUsed;
    }

    public boolean isParseIntegerOnly() {
        return this.parseIntegerOnly;
    }

    public abstract Number parse(String var1, ParsePosition var2);

    public Number parse(String string) throws ParseException {
        ParsePosition parsePosition = new ParsePosition(0);
        Number number = this.parse(string, parsePosition);
        if (number == null) {
            int n = parsePosition.getErrorIndex();
            if (n < 0) {
                n = parsePosition.getIndex();
            }
            throw new ParseException("couldn't parse number", n);
        }
        return number;
    }

    public final Object parseObject(String string, ParsePosition parsePosition) {
        return this.parse(string, parsePosition);
    }

    public void setGroupingUsed(boolean bl) {
        this.groupingUsed = bl;
    }

    public void setMaximumFractionDigits(int n) {
        this.maximumFractionDigits = n;
    }

    public void setMaximumIntegerDigits(int n) {
        this.maximumIntegerDigits = n;
    }

    public void setMinimumFractionDigits(int n) {
        this.minimumFractionDigits = n;
    }

    public void setMinimumIntegerDigits(int n) {
        this.minimumIntegerDigits = n;
    }

    public void setParseIntegerOnly(boolean bl) {
        this.parseIntegerOnly = bl;
    }

    public final String format(double d) {
        StringBuffer stringBuffer = new StringBuffer(50);
        this.format(d, stringBuffer, (FieldPosition)null);
        return stringBuffer.toString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        if (this.serialVersionOnStream < 1) {
            this.maximumFractionDigits = this.maxFractionDigits;
            this.maximumIntegerDigits = this.maxIntegerDigits;
            this.minimumFractionDigits = this.minFractionDigits;
            this.minimumIntegerDigits = this.minIntegerDigits;
            this.serialVersionOnStream = 1;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.maxFractionDigits = (byte)(this.maximumFractionDigits < 127 ? (int)this.maximumFractionDigits : 127);
        this.maxIntegerDigits = (byte)(this.maximumIntegerDigits < 127 ? (int)this.maximumIntegerDigits : 127);
        this.minFractionDigits = (byte)(this.minimumFractionDigits < 127 ? (int)this.minimumFractionDigits : 127);
        this.minIntegerDigits = (byte)(this.minimumIntegerDigits < 127 ? (int)this.minimumIntegerDigits : 127);
        this.serialVersionOnStream = 1;
        objectOutputStream.defaultWriteObject();
    }
}

