/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.ChoiceFormat;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;

final class MessageFormatElement {
    int argNumber;
    Format setFormat;
    Format format;
    Class formatClass;
    String type;
    String style;
    String trailer;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    void setLocale(Locale locale) {
        if (this.type != null) {
            if (this.type.equals("number")) {
                this.formatClass = MessageFormatElement.class$("java.lang.Number");
                if (this.style == null) {
                    this.format = NumberFormat.getInstance(locale);
                } else if (this.style.equals("currency")) {
                    this.format = NumberFormat.getCurrencyInstance(locale);
                } else if (this.style.equals("percent")) {
                    this.format = NumberFormat.getPercentInstance(locale);
                } else if (this.style.equals("integer")) {
                    NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
                    numberFormat.setMaximumFractionDigits(0);
                    numberFormat.setGroupingUsed(false);
                    this.format = numberFormat;
                } else {
                    this.format = NumberFormat.getNumberInstance(locale);
                    DecimalFormat decimalFormat = (DecimalFormat)this.format;
                    try {
                        decimalFormat.applyPattern(this.style);
                    }
                    catch (ParseException parseException) {
                        throw new IllegalArgumentException(parseException.getMessage());
                    }
                }
            } else if (this.type.equals("time") || this.type.equals("date")) {
                this.formatClass = MessageFormatElement.class$("java.util.Date");
                int n = 2;
                if (this.style != null) {
                    if (this.style.equals("short")) {
                        n = 3;
                    } else if (this.style.equals("medium")) {
                        n = 2;
                    } else if (this.style.equals("long")) {
                        n = 1;
                    } else if (this.style.equals("full")) {
                        n = 0;
                    }
                }
                this.format = this.type.equals("time") ? DateFormat.getTimeInstance(n, locale) : DateFormat.getDateInstance(n, locale);
                if (this.style != null && n == 2) {
                    SimpleDateFormat simpleDateFormat = (SimpleDateFormat)this.format;
                    simpleDateFormat.applyPattern(this.style);
                }
            } else if (this.type.equals("choice")) {
                this.formatClass = MessageFormatElement.class$("java.lang.Number");
                if (this.style == null) {
                    throw new IllegalArgumentException("style required for choice format");
                }
                this.format = new ChoiceFormat(this.style);
            }
        }
    }

    MessageFormatElement() {
    }
}

