/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.ChoiceFormat;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.MessageFormatElement;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Date;
import java.util.Locale;
import java.util.Vector;

public class MessageFormat
extends Format {
    private String pattern;
    private Locale locale;
    private MessageFormatElement[] elements;
    private String leader;

    private static final int scanString(String string, int n, StringBuffer stringBuffer) {
        int n2 = string.length();
        stringBuffer.setLength(0);
        while (n < n2) {
            char c = string.charAt(n);
            if (c == '\'' && n + 2 < n2 && string.charAt(n + 2) == '\'') {
                stringBuffer.append(string.charAt(n + 1));
                n += 2;
            } else if (c == '\'' && n + 1 < n2 && string.charAt(n + 1) == '\'') {
                stringBuffer.append(c);
                ++n;
            } else {
                if (c == '{') break;
                if (c == '}') {
                    throw new IllegalArgumentException();
                }
                stringBuffer.append(c);
            }
            ++n;
        }
        return n;
    }

    private static final int scanFormatElement(String string, int n, StringBuffer stringBuffer, char c) {
        int n2 = string.length();
        stringBuffer.setLength(0);
        int n3 = 1;
        while (n < n2) {
            char c2 = string.charAt(n);
            if (c2 == '\'' && n + 2 < n2 && string.charAt(n + 2) == '\'') {
                stringBuffer.append(c2);
                stringBuffer.append(string.charAt(n + 1));
                stringBuffer.append(c2);
                n += 2;
            } else if (c2 == '\'' && n + 1 < n2 && string.charAt(n + 1) == '\'') {
                stringBuffer.append(c2);
                ++n;
            } else if (c2 == '{') {
                stringBuffer.append(c2);
                ++n3;
            } else if (c2 == '}') {
                if (--n3 == 0) break;
                stringBuffer.append(c2);
            } else {
                if (c2 == c) break;
                stringBuffer.append(c2);
            }
            ++n;
        }
        return n;
    }

    private static final int scanFormat(String string, int n, StringBuffer stringBuffer, Vector vector, Locale locale) {
        MessageFormatElement messageFormatElement = new MessageFormatElement();
        vector.addElement(messageFormatElement);
        int n2 = string.length();
        ++n;
        n = MessageFormat.scanFormatElement(string, n, stringBuffer, ',');
        try {
            messageFormatElement.argNumber = Integer.parseInt(stringBuffer.toString());
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException();
        }
        if (n < n2 && string.charAt(n) == ',') {
            n = MessageFormat.scanFormatElement(string, n + 1, stringBuffer, ',');
            messageFormatElement.type = stringBuffer.toString();
            if (n < n2 && string.charAt(n) == ',') {
                n = MessageFormat.scanFormatElement(string, n + 1, stringBuffer, '}');
                messageFormatElement.style = stringBuffer.toString();
            }
        }
        if (n >= n2 || string.charAt(n) != '}') {
            throw new IllegalArgumentException();
        }
        ++n;
        n = MessageFormat.scanString(string, n, stringBuffer);
        messageFormatElement.trailer = stringBuffer.toString();
        messageFormatElement.setLocale(locale);
        return n;
    }

    public void applyPattern(String string) {
        this.pattern = string;
        StringBuffer stringBuffer = new StringBuffer();
        int n = MessageFormat.scanString(string, 0, stringBuffer);
        this.leader = stringBuffer.toString();
        Vector vector = new Vector();
        while (n < string.length()) {
            n = MessageFormat.scanFormat(string, n, stringBuffer, vector, this.locale);
        }
        this.elements = new MessageFormatElement[vector.size()];
        vector.copyInto(this.elements);
    }

    public Object clone() {
        MessageFormat messageFormat = new MessageFormat();
        messageFormat.setLocale(this.locale);
        messageFormat.applyPattern(this.pattern);
        return messageFormat;
    }

    public boolean equals(Object object) {
        if (!(object instanceof MessageFormat)) {
            return false;
        }
        MessageFormat messageFormat = (MessageFormat)object;
        return this.pattern.equals(messageFormat.pattern) && this.locale.equals(messageFormat.locale);
    }

    public static String format(String string, Object[] objectArray) {
        MessageFormat messageFormat = new MessageFormat(string);
        StringBuffer stringBuffer = new StringBuffer();
        FieldPosition fieldPosition = new FieldPosition(0);
        return messageFormat.format(objectArray, stringBuffer, fieldPosition).toString();
    }

    public final StringBuffer format(Object[] objectArray, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        stringBuffer.append(this.leader);
        for (int i = 0; i < this.elements.length; ++i) {
            if (this.elements[i].argNumber >= objectArray.length) {
                throw new IllegalArgumentException();
            }
            Object object = objectArray[this.elements[i].argNumber];
            Format format = null;
            if (this.elements[i].setFormat != null) {
                format = this.elements[i].setFormat;
            } else if (this.elements[i].format != null) {
                if (this.elements[i].formatClass != null && !this.elements[i].formatClass.isInstance(object)) {
                    throw new IllegalArgumentException();
                }
                format = this.elements[i].format;
            } else if (object instanceof Number) {
                format = NumberFormat.getInstance(this.locale);
            } else if (object instanceof Date) {
                format = DateFormat.getTimeInstance(2, this.locale);
            } else {
                stringBuffer.append(object);
            }
            if (format != null) {
                if (format instanceof ChoiceFormat) {
                    StringBuffer stringBuffer2 = new StringBuffer();
                    format.format(object, stringBuffer2, fieldPosition);
                    MessageFormat messageFormat = new MessageFormat();
                    messageFormat.setLocale(this.locale);
                    messageFormat.applyPattern(stringBuffer2.toString());
                    format = messageFormat;
                }
                format.format(object, stringBuffer, fieldPosition);
            }
            stringBuffer.append(this.elements[i].trailer);
        }
        return stringBuffer;
    }

    public final StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        Object[] objectArray = object instanceof Object[] ? (Object[])object : new Object[]{object};
        return this.format(objectArray, stringBuffer, fieldPosition);
    }

    public Format[] getFormats() {
        Format[] formatArray = new Format[this.elements.length];
        for (int i = this.elements.length - 1; i >= 0; --i) {
            formatArray[i] = this.elements[i].setFormat;
        }
        return formatArray;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public int hashCode() {
        return this.pattern.hashCode() + this.locale.hashCode();
    }

    private MessageFormat() {
    }

    public MessageFormat(String string) {
        this.locale = Locale.getDefault();
        this.applyPattern(string);
    }

    public Object[] parse(String string, ParsePosition parsePosition) {
        int n = parsePosition.getIndex();
        if (!string.startsWith(this.leader, n)) {
            parsePosition.setErrorIndex(n);
            return null;
        }
        n += this.leader.length();
        Vector vector = new Vector(this.elements.length, 1);
        for (int i = 0; i < this.elements.length; ++i) {
            Format format = null;
            if (this.elements[i].setFormat != null) {
                format = this.elements[i].setFormat;
            } else if (this.elements[i].format != null) {
                format = this.elements[i].format;
            }
            Object[] objectArray = null;
            if (format instanceof ChoiceFormat) {
                int n2;
                ChoiceFormat choiceFormat = (ChoiceFormat)format;
                String[] stringArray = (String[])choiceFormat.getFormats();
                double[] dArray = choiceFormat.getLimits();
                MessageFormat messageFormat = new MessageFormat();
                messageFormat.setLocale(this.locale);
                ParsePosition parsePosition2 = new ParsePosition(n);
                for (n2 = 0; objectArray == null && n2 < dArray.length; ++n2) {
                    messageFormat.applyPattern(stringArray[n2]);
                    parsePosition2.setIndex(n);
                    objectArray = messageFormat.parse(string, parsePosition2);
                }
                if (objectArray != null) {
                    n = parsePosition2.getIndex();
                    objectArray = new Double(dArray[n2]);
                }
            } else if (format != null) {
                parsePosition.setIndex(n);
                objectArray = format.parseObject(string, parsePosition);
                if (objectArray != null) {
                    n = parsePosition.getIndex();
                }
            } else {
                int n3 = string.indexOf(this.elements[i].trailer, n);
                if (n3 == -1) {
                    parsePosition.setErrorIndex(n);
                    return null;
                }
                objectArray = string.substring(n, n3);
                n = n3;
            }
            if (objectArray == null || !string.startsWith(this.elements[i].trailer, n)) {
                parsePosition.setErrorIndex(n);
                return null;
            }
            if (this.elements[i].argNumber >= vector.size()) {
                vector.setSize(this.elements[i].argNumber + 1);
            }
            vector.setElementAt(objectArray, this.elements[i].argNumber);
            n += this.elements[i].trailer.length();
        }
        Object[] objectArray = new Object[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Object[] parse(String string) throws ParseException {
        ParsePosition parsePosition = new ParsePosition(0);
        Object[] objectArray = this.parse(string, parsePosition);
        if (objectArray == null) {
            throw new ParseException("couldn't parse string", parsePosition.getErrorIndex());
        }
        return objectArray;
    }

    public Object parseObject(String string, ParsePosition parsePosition) {
        return this.parse(string, parsePosition);
    }

    public void setFormat(int n, Format format) {
        this.elements[n].setFormat = format;
    }

    public void setFormats(Format[] formatArray) {
        if (formatArray.length < this.elements.length) {
            throw new IllegalArgumentException();
        }
        int n = Math.min(formatArray.length, this.elements.length);
        for (int i = 0; i < n; ++i) {
            this.elements[i].setFormat = formatArray[i];
        }
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        if (this.elements != null) {
            for (int i = 0; i < this.elements.length; ++i) {
                this.elements[i].setLocale(locale);
            }
        }
    }

    public String toPattern() {
        return this.pattern;
    }
}

