/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;

public class DecimalFormat
extends NumberFormat {
    private boolean decimalSeparatorAlwaysShown;
    private byte groupingSize;
    private byte minExponentDigits;
    private int multiplier;
    private String negativePrefix;
    private String negativeSuffix;
    private String positivePrefix;
    private String positiveSuffix;
    private int serialVersionOnStream;
    private DecimalFormatSymbols symbols;
    private boolean useExponentialNotation;
    private static final long serialVersionUID = 864413376551465018L;
    private static final DecimalFormatSymbols nonLocalizedSymbols = new DecimalFormatSymbols(Locale.US);

    private /* synthetic */ void finit$() {
        this.serialVersionOnStream = 1;
    }

    private final int scanFix(String string, int n, StringBuffer stringBuffer, String string2, DecimalFormatSymbols decimalFormatSymbols, boolean bl) {
        int n2 = string.length();
        stringBuffer.setLength(0);
        boolean bl2 = false;
        while (n < n2) {
            char c = string.charAt(n);
            if (c == '\'' && n + 1 < n2 && string.charAt(n + 1) == '\'') {
                stringBuffer.append(c);
                ++n;
            } else if (c == '\'' && n + 2 < n2 && string.charAt(n + 2) == '\'') {
                stringBuffer.append(string.charAt(n + 1));
                n += 2;
            } else if (c == '\u00a4') {
                if (n + 1 < n2 && string.charAt(n + 1) == '\u00a4') {
                    stringBuffer.append(decimalFormatSymbols.getInternationalCurrencySymbol());
                    ++n;
                } else {
                    stringBuffer.append(decimalFormatSymbols.getCurrencySymbol());
                }
            } else if (bl && c == decimalFormatSymbols.getPercent()) {
                if (bl2) {
                    throw new IllegalArgumentException("multiplier already set - index: " + n);
                }
                bl2 = true;
                this.multiplier = 100;
                stringBuffer.append(c);
            } else if (bl && c == decimalFormatSymbols.getPerMill()) {
                if (bl2) {
                    throw new IllegalArgumentException("multiplier already set - index: " + n);
                }
                bl2 = true;
                this.multiplier = 1000;
                stringBuffer.append(c);
            } else {
                if (string2.indexOf(c) != -1) break;
                stringBuffer.append(c);
            }
            ++n;
        }
        return n;
    }

    private final int scanFormat(String string, int n, String string2, DecimalFormatSymbols decimalFormatSymbols, boolean bl) {
        int n2;
        int n3 = string.length();
        int n4 = 0;
        int n5 = 0;
        boolean bl2 = false;
        while (n < n3) {
            n2 = string.charAt(n);
            if (n2 == decimalFormatSymbols.getDigit()) {
                if (n5 > 0) {
                    throw new IllegalArgumentException("digit mark following zero - index: " + n);
                }
                ++n4;
            } else if (n2 == decimalFormatSymbols.getZeroDigit()) {
                ++n5;
                ++n4;
            } else {
                if (n2 != decimalFormatSymbols.getGroupingSeparator()) break;
                n4 = 0;
                bl2 = true;
            }
            ++n;
        }
        if (bl) {
            this.groupingUsed = bl2;
            this.groupingSize = (byte)n4;
            this.minimumIntegerDigits = n5;
        }
        if (n == n3 || string.charAt(n) == decimalFormatSymbols.getGroupingSeparator()) {
            if (bl) {
                this.decimalSeparatorAlwaysShown = false;
            }
            return n;
        }
        if (string.charAt(n) == decimalFormatSymbols.getDecimalSeparator()) {
            ++n;
            n2 = 0;
            n5 = 0;
            while (n < n3) {
                char c = string.charAt(n);
                if (c == decimalFormatSymbols.getZeroDigit()) {
                    if (n2 > 0) {
                        throw new IllegalArgumentException("zero mark following digit - index: " + n);
                    }
                    ++n5;
                } else if (c == decimalFormatSymbols.getDigit()) {
                    ++n2;
                } else {
                    if (c == decimalFormatSymbols.getExponential() || c == decimalFormatSymbols.getPatternSeparator() || string2.indexOf(c) == -1) break;
                    throw new IllegalArgumentException("unexpected special character - index: " + n);
                }
                ++n;
            }
            if (bl) {
                this.maximumFractionDigits = n2 + n5;
                this.minimumFractionDigits = n5;
            }
            if (n == n3) {
                return n;
            }
        }
        if (string.charAt(n) == decimalFormatSymbols.getExponential()) {
            n5 = 0;
            ++n;
            while (n < n3) {
                n2 = string.charAt(n);
                if (n2 == decimalFormatSymbols.getZeroDigit()) {
                    ++n5;
                } else if (n2 == decimalFormatSymbols.getDigit()) {
                    if (n5 > 0) {
                        throw new IllegalArgumentException("digit mark following zero in exponent - index: " + n);
                    }
                } else {
                    if (string2.indexOf(n2) == -1) break;
                    throw new IllegalArgumentException("unexpected special character - index: " + n);
                }
                ++n;
            }
            if (bl) {
                this.useExponentialNotation = true;
                this.minExponentDigits = (byte)n5;
            }
        }
        return n;
    }

    private final String patternChars(DecimalFormatSymbols decimalFormatSymbols) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(decimalFormatSymbols.getDecimalSeparator());
        stringBuffer.append(decimalFormatSymbols.getDigit());
        stringBuffer.append(decimalFormatSymbols.getExponential());
        stringBuffer.append(decimalFormatSymbols.getGroupingSeparator());
        stringBuffer.append(decimalFormatSymbols.getPatternSeparator());
        stringBuffer.append(decimalFormatSymbols.getPercent());
        stringBuffer.append(decimalFormatSymbols.getPerMill());
        stringBuffer.append(decimalFormatSymbols.getZeroDigit());
        stringBuffer.append('\u00a4');
        return stringBuffer.toString();
    }

    private final void applyPatternWithSymbols(String string, DecimalFormatSymbols decimalFormatSymbols) {
        this.negativePrefix = "";
        this.negativeSuffix = "";
        this.positivePrefix = "";
        this.positiveSuffix = "";
        this.decimalSeparatorAlwaysShown = false;
        this.groupingSize = 0;
        this.minExponentDigits = 0;
        this.multiplier = 1;
        this.useExponentialNotation = false;
        this.groupingUsed = false;
        this.maximumFractionDigits = 0;
        this.maximumIntegerDigits = 309;
        this.minimumFractionDigits = 0;
        this.minimumIntegerDigits = 1;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = this.patternChars(decimalFormatSymbols);
        int n = string.length();
        int n2 = this.scanFix(string, 0, stringBuffer, string2, decimalFormatSymbols, false);
        this.positivePrefix = stringBuffer.toString();
        n2 = this.scanFormat(string, n2, string2, decimalFormatSymbols, true);
        n2 = this.scanFix(string, n2, stringBuffer, string2, decimalFormatSymbols, true);
        this.positiveSuffix = stringBuffer.toString();
        if (n2 == string.length()) {
            this.negativePrefix = null;
            this.negativeSuffix = null;
        } else {
            if (string.charAt(n2) != decimalFormatSymbols.getPatternSeparator()) {
                throw new IllegalArgumentException("separator character expected - index: " + n2);
            }
            n2 = this.scanFix(string, n2 + 1, stringBuffer, string2, decimalFormatSymbols, false);
            this.negativePrefix = stringBuffer.toString();
            n2 = this.scanFormat(string, n2, string2, decimalFormatSymbols, false);
            n2 = this.scanFix(string, n2, stringBuffer, string2, decimalFormatSymbols, true);
            this.negativeSuffix = stringBuffer.toString();
            if (n2 != string.length()) {
                throw new IllegalArgumentException("end of pattern expected - index: " + n2);
            }
        }
    }

    public void applyLocalizedPattern(String string) {
        this.applyPatternWithSymbols(string, this.symbols);
    }

    public void applyPattern(String string) {
        this.applyPatternWithSymbols(string, nonLocalizedSymbols);
    }

    public Object clone() {
        return new DecimalFormat(this);
    }

    private DecimalFormat(DecimalFormat decimalFormat) {
        this.finit$();
        this.decimalSeparatorAlwaysShown = decimalFormat.decimalSeparatorAlwaysShown;
        this.groupingSize = decimalFormat.groupingSize;
        this.minExponentDigits = decimalFormat.minExponentDigits;
        this.multiplier = decimalFormat.multiplier;
        this.negativePrefix = decimalFormat.negativePrefix;
        this.negativeSuffix = decimalFormat.negativeSuffix;
        this.positivePrefix = decimalFormat.positivePrefix;
        this.positiveSuffix = decimalFormat.positiveSuffix;
        this.symbols = (DecimalFormatSymbols)decimalFormat.symbols.clone();
        this.useExponentialNotation = decimalFormat.useExponentialNotation;
    }

    public DecimalFormat() {
        this("#,##0.###");
    }

    public DecimalFormat(String string) {
        this(string, new DecimalFormatSymbols());
    }

    public DecimalFormat(String string, DecimalFormatSymbols decimalFormatSymbols) {
        this.finit$();
        this.symbols = decimalFormatSymbols;
        this.applyPattern(string);
    }

    private final boolean equals(String string, String string2) {
        if (string == null || string2 == null) {
            return string == string2;
        }
        return string.equals(string2);
    }

    public boolean equals(Object object) {
        if (!(object instanceof DecimalFormat)) {
            return false;
        }
        DecimalFormat decimalFormat = (DecimalFormat)object;
        return this.decimalSeparatorAlwaysShown == decimalFormat.decimalSeparatorAlwaysShown && this.groupingSize == decimalFormat.groupingSize && this.minExponentDigits == decimalFormat.minExponentDigits && this.multiplier == decimalFormat.multiplier && this.equals(this.negativePrefix, decimalFormat.negativePrefix) && this.equals(this.negativeSuffix, decimalFormat.negativeSuffix) && this.equals(this.positivePrefix, decimalFormat.positivePrefix) && this.equals(this.positiveSuffix, decimalFormat.positiveSuffix) && this.symbols.equals(decimalFormat.symbols) && this.useExponentialNotation == decimalFormat.useExponentialNotation;
    }

    public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        boolean bl;
        if (Double.isNaN(d)) {
            stringBuffer.append(this.symbols.getNaN());
            if (fieldPosition != null && fieldPosition.getField() == 0) {
                int n = stringBuffer.length();
                fieldPosition.setBeginIndex(n - this.symbols.getNaN().length());
                fieldPosition.setEndIndex(n);
            }
            return stringBuffer;
        }
        boolean bl2 = bl = d < 0.0;
        if (bl) {
            if (this.negativePrefix != null) {
                stringBuffer.append(this.negativePrefix);
            } else {
                stringBuffer.append(this.symbols.getMinusSign());
                stringBuffer.append(this.positivePrefix);
            }
            d = -d;
        } else {
            stringBuffer.append(this.positivePrefix);
        }
        int n = stringBuffer.length();
        int n2 = 0;
        if (Double.isInfinite(d)) {
            stringBuffer.append(this.symbols.getInfinity());
            n2 = stringBuffer.length();
        } else {
            int n3;
            double d2;
            d *= (double)this.multiplier;
            long l = 0L;
            if (this.useExponentialNotation) {
                l = (long)(Math.log(d) / Math.log(10.0));
                if (this.minimumIntegerDigits > 0) {
                    l -= (long)(this.minimumIntegerDigits - 1);
                }
                d2 = (long)(d / Math.pow(10.0, l));
            } else {
                d2 = d;
            }
            int n4 = stringBuffer.length();
            double d3 = Math.floor(d2 += 5.0 * Math.pow(10.0, -this.maximumFractionDigits - 1));
            for (n3 = 0; n3 < this.maximumIntegerDigits && (d3 > 0.0 || n3 < this.minimumIntegerDigits); ++n3) {
                long l2 = (long)(d3 % 10.0);
                d3 = Math.floor(d3 / 10.0);
                if (this.groupingUsed && n3 > 0 && n3 % this.groupingSize == 0) {
                    stringBuffer.insert(n4, this.symbols.getGroupingSeparator());
                }
                stringBuffer.insert(n4, (char)((long)this.symbols.getZeroDigit() + l2));
            }
            int n5 = n2 = stringBuffer.length();
            int n6 = 0;
            int n7 = 0;
            double d4 = d2 - Math.floor(d2);
            for (n3 = 0; n3 < this.maximumFractionDigits && (d4 != 0.0 || n3 < this.minimumFractionDigits); d4 -= Math.floor(d4), ++n3) {
                ++n7;
                long l3 = (long)(d4 *= 10.0);
                n6 = l3 == 0L ? ++n6 : 0;
                stringBuffer.append((char)((long)this.symbols.getZeroDigit() + l3));
            }
            int n8 = Math.min(n6, n7 - this.minimumFractionDigits);
            if (n8 > 0) {
                stringBuffer.setLength(stringBuffer.length() - n8);
                n7 -= n8;
            }
            if (this.decimalSeparatorAlwaysShown || n7 > 0) {
                stringBuffer.insert(n5, this.symbols.getDecimalSeparator());
                if (fieldPosition != null && fieldPosition.getField() == 1) {
                    fieldPosition.setBeginIndex(n5 + 1);
                    fieldPosition.setEndIndex(stringBuffer.length());
                }
            }
            if (this.useExponentialNotation) {
                stringBuffer.append(this.symbols.getExponential());
                stringBuffer.append(l < 0L ? (char)'-' : '+');
                n4 = stringBuffer.length();
                for (n3 = 0; l > 0L || n3 < this.minExponentDigits; l /= (long)10, ++n3) {
                    long l4 = l % (long)10;
                    stringBuffer.insert(n4, (char)((long)this.symbols.getZeroDigit() + l4));
                }
            }
        }
        if (fieldPosition != null && fieldPosition.getField() == 0) {
            fieldPosition.setBeginIndex(n);
            fieldPosition.setEndIndex(n2);
        }
        stringBuffer.append(bl && this.negativeSuffix != null ? this.negativeSuffix : this.positiveSuffix);
        return stringBuffer;
    }

    public StringBuffer format(long l, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        int n;
        boolean bl;
        if (this.useExponentialNotation) {
            return this.format((double)l, stringBuffer, fieldPosition);
        }
        boolean bl2 = bl = l < 0L;
        if (bl) {
            if (this.negativePrefix != null) {
                stringBuffer.append(this.negativePrefix);
            } else {
                stringBuffer.append(this.symbols.getMinusSign());
                stringBuffer.append(this.positivePrefix);
            }
            l = -l;
        } else {
            stringBuffer.append(this.positivePrefix);
        }
        int n2 = stringBuffer.length();
        int n3 = stringBuffer.length();
        for (n = 0; n < this.maximumIntegerDigits && (l > 0L || n < this.minimumIntegerDigits); ++n) {
            long l2 = l % (long)10;
            l /= (long)10;
            if (l2 < 0L) {
                l2 = -l2;
                l = -l;
            }
            if (this.groupingUsed && n > 0 && n % this.groupingSize == 0) {
                stringBuffer.insert(n3, this.symbols.getGroupingSeparator());
            }
            stringBuffer.insert(n3, (char)((long)this.symbols.getZeroDigit() + l2));
        }
        if (fieldPosition != null && fieldPosition.getField() == 0) {
            fieldPosition.setBeginIndex(n2);
            fieldPosition.setEndIndex(stringBuffer.length());
        }
        if (this.decimalSeparatorAlwaysShown || this.minimumFractionDigits > 0) {
            stringBuffer.append(this.symbols.getDecimalSeparator());
            if (fieldPosition != null && fieldPosition.getField() == 1) {
                fieldPosition.setBeginIndex(stringBuffer.length());
                fieldPosition.setEndIndex(stringBuffer.length() + this.minimumFractionDigits);
            }
        }
        for (n = 0; n < this.minimumFractionDigits; ++n) {
            stringBuffer.append(this.symbols.getZeroDigit());
        }
        stringBuffer.append(bl && this.negativeSuffix != null ? this.negativeSuffix : this.positiveSuffix);
        return stringBuffer;
    }

    public DecimalFormatSymbols getDecimalFormatSymbols() {
        return this.symbols;
    }

    public int getGroupingSize() {
        return this.groupingSize;
    }

    public int getMultiplier() {
        return this.multiplier;
    }

    public String getNegativePrefix() {
        return this.negativePrefix;
    }

    public String getNegativeSuffix() {
        return this.negativeSuffix;
    }

    public String getPositivePrefix() {
        return this.positivePrefix;
    }

    public String getPositiveSuffix() {
        return this.positiveSuffix;
    }

    public int hashCode() {
        int n = this.negativeSuffix.hashCode() ^ this.negativePrefix.hashCode() ^ this.positivePrefix.hashCode() ^ this.positiveSuffix.hashCode();
        return n;
    }

    public boolean isDecimalSeparatorAlwaysShown() {
        return this.decimalSeparatorAlwaysShown;
    }

    public Number parse(String string, ParsePosition parsePosition) {
        String string2;
        char c;
        boolean bl = false;
        int n = parsePosition.getIndex();
        StringBuffer stringBuffer = new StringBuffer();
        char c2 = string.startsWith(this.positivePrefix, n);
        String string3 = this.negativePrefix != null ? this.negativePrefix : this.positivePrefix + this.symbols.getMinusSign();
        boolean bl2 = string.startsWith(string3, n);
        if (c2 != '\u0000' && bl2) {
            if (string3.length() > this.positivePrefix.length()) {
                bl = true;
                n += string3.length();
            } else {
                n += this.positivePrefix.length();
            }
        } else if (bl2) {
            bl = true;
            n += string3.length();
        } else if (c2 != '\u0000') {
            n += this.positivePrefix.length();
        } else {
            parsePosition.setErrorIndex(n);
            return null;
        }
        int n2 = n;
        int n3 = string.length();
        char c3 = this.symbols.getZeroDigit();
        int n4 = -1;
        boolean bl3 = true;
        boolean bl4 = false;
        while (n < n3) {
            c = string.charAt(n);
            if (this.groupingUsed && c == this.symbols.getGroupingSeparator()) {
                if (n4 != -1 && (n - n4) % this.groupingSize != 0) {
                    parsePosition.setErrorIndex(n);
                    return null;
                }
                n4 = n;
            } else if (c >= c3 && c <= c3 + 9) {
                stringBuffer.append((char)(c - c3 + 48));
                bl4 = false;
            } else {
                if (this.parseIntegerOnly) break;
                if (c == this.symbols.getDecimalSeparator()) {
                    if (n4 != -1 && (n - n4) % this.groupingSize != 0) {
                        parsePosition.setErrorIndex(n);
                        return null;
                    }
                    stringBuffer.append('.');
                    bl3 = false;
                } else if (c == this.symbols.getExponential()) {
                    stringBuffer.append('E');
                    bl3 = false;
                    bl4 = true;
                } else {
                    if (!bl4 || c != '+' && c != '-' && c != this.symbols.getMinusSign()) break;
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        if (n == n2) {
            parsePosition.setErrorIndex(n);
            return null;
        }
        c = (char)(string.startsWith(this.positiveSuffix, n) ? 1 : 0);
        String string4 = this.negativePrefix == null ? this.positiveSuffix : this.negativeSuffix;
        boolean bl5 = string.startsWith(string4, n);
        if (bl) {
            if (!bl5) {
                parsePosition.setErrorIndex(n);
                return null;
            }
        } else if (c2 != '\u0000' && bl2 && bl5) {
            bl = true;
        } else if (c2 != c && bl2 != bl5) {
            parsePosition.setErrorIndex(n);
            return null;
        }
        String string5 = string2 = bl ? string4 : this.positiveSuffix;
        if (bl) {
            stringBuffer.insert(0, '-');
        }
        String string6 = stringBuffer.toString();
        Number number = null;
        try {
            number = new Long(string6);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                number = new Double(string6);
            }
            catch (NumberFormatException numberFormatException2) {
                // empty catch block
            }
        }
        if (number == null) {
            parsePosition.setErrorIndex(n);
            return null;
        }
        parsePosition.setIndex(n + string2.length());
        return number;
    }

    public void setDecimalFormatSymbols(DecimalFormatSymbols decimalFormatSymbols) {
        this.symbols = decimalFormatSymbols;
    }

    public void setDecimalSeparatorAlwaysShown(boolean bl) {
        this.decimalSeparatorAlwaysShown = bl;
    }

    public void setGroupingSize(int n) {
        this.groupingSize = (byte)n;
    }

    public void setMaximumFractionDigits(int n) {
        this.maximumFractionDigits = Math.min(n, 340);
    }

    public void setMaximumIntegerDigits(int n) {
        this.maximumIntegerDigits = Math.min(n, 309);
    }

    public void setMinimumFractionDigits(int n) {
        this.minimumFractionDigits = Math.min(n, 340);
    }

    public void setMinimumIntegerDigits(int n) {
        this.minimumIntegerDigits = Math.min(n, 309);
    }

    public void setMultiplier(int n) {
        this.multiplier = n;
    }

    public void setNegativePrefix(String string) {
        this.negativePrefix = string;
    }

    public void setNegativeSuffix(String string) {
        this.negativeSuffix = string;
    }

    public void setPositivePrefix(String string) {
        this.positivePrefix = string;
    }

    public void setPositiveSuffix(String string) {
        this.positiveSuffix = string;
    }

    private final void quoteFix(StringBuffer stringBuffer, String string, String string2) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (string2.indexOf(c) != -1) {
                stringBuffer.append('\'');
                stringBuffer.append(c);
                stringBuffer.append('\'');
                continue;
            }
            stringBuffer.append(c);
        }
    }

    private final String computePattern(DecimalFormatSymbols decimalFormatSymbols) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = Math.max(this.minimumIntegerDigits, this.groupingUsed ? this.groupingSize + 1 : 0);
        for (n = 0; n < n2 - this.minimumIntegerDigits; ++n) {
            stringBuffer.append(decimalFormatSymbols.getDigit());
        }
        for (n = n2 - this.minimumIntegerDigits; n < n2; ++n) {
            stringBuffer.append(decimalFormatSymbols.getZeroDigit());
        }
        if (this.groupingUsed) {
            stringBuffer.insert(stringBuffer.length() - this.groupingSize, decimalFormatSymbols.getGroupingSeparator());
        }
        if (this.minimumFractionDigits > 0 || this.maximumFractionDigits > 0 || this.decimalSeparatorAlwaysShown) {
            stringBuffer.append(decimalFormatSymbols.getDecimalSeparator());
        }
        for (n = 0; n < this.minimumFractionDigits; ++n) {
            stringBuffer.append(decimalFormatSymbols.getZeroDigit());
        }
        for (n = this.minimumFractionDigits; n < this.maximumFractionDigits; ++n) {
            stringBuffer.append(decimalFormatSymbols.getDigit());
        }
        if (this.useExponentialNotation) {
            stringBuffer.append(decimalFormatSymbols.getExponential());
            for (n = 0; n < this.minExponentDigits; ++n) {
                stringBuffer.append(decimalFormatSymbols.getZeroDigit());
            }
            if (this.minExponentDigits == 0) {
                stringBuffer.append(decimalFormatSymbols.getDigit());
            }
        }
        String string = stringBuffer.toString();
        String string2 = this.patternChars(decimalFormatSymbols);
        stringBuffer.setLength(0);
        this.quoteFix(stringBuffer, this.positivePrefix, string2);
        stringBuffer.append(string);
        this.quoteFix(stringBuffer, this.positiveSuffix, string2);
        if (this.negativePrefix != null) {
            this.quoteFix(stringBuffer, this.negativePrefix, string2);
            stringBuffer.append(string);
            this.quoteFix(stringBuffer, this.negativeSuffix, string2);
        }
        return stringBuffer.toString();
    }

    public String toLocalizedPattern() {
        return this.computePattern(this.symbols);
    }

    public String toPattern() {
        return this.computePattern(nonLocalizedSymbols);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        if (this.serialVersionOnStream < 1) {
            this.useExponentialNotation = false;
            this.serialVersionOnStream = 1;
        }
    }
}

