/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.Serializable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class DateFormatSymbols
implements Serializable,
Cloneable {
    String[] ampms;
    String[] eras;
    private String localPatternChars;
    String[] months;
    String[] shortMonths;
    String[] shortWeekdays;
    String[] weekdays;
    private String[][] zoneStrings;
    private static final long serialVersionUID = -5987973545549424702L;
    private static final String[] formatPrefixes = new String[]{"full", "long", "medium", "short"};
    private static final String[] ampmsDefault = new String[]{"AM", "PM"};
    private static final String[] erasDefault = new String[]{"BC", "AD"};
    private static final String localPatternCharsDefault = "GyMdkHmsSEDFwWahKz";
    private static final String[] monthsDefault;
    private static final String[] shortMonthsDefault;
    private static final String[] shortWeekdaysDefault;
    private static final String[] weekdaysDefault;
    private static String[][] zoneStringsDefault;
    transient String[] dateFormats;
    transient String[] timeFormats;

    private String[] formatsForKey(ResourceBundle resourceBundle, String string) {
        String[] stringArray = new String[formatPrefixes.length];
        for (int i = 0; i < formatPrefixes.length; ++i) {
            stringArray[i] = resourceBundle.getString(formatPrefixes[i] + string);
        }
        return stringArray;
    }

    private final Object safeGetResource(ResourceBundle resourceBundle, String string, Object object) {
        if (resourceBundle != null) {
            try {
                return resourceBundle.getObject(string);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return object;
    }

    public DateFormatSymbols(Locale locale) {
        ResourceBundle resourceBundle;
        try {
            resourceBundle = ResourceBundle.getBundle("gnu.gcj.text.LocaleData", locale);
        }
        catch (MissingResourceException missingResourceException) {
            resourceBundle = null;
        }
        this.ampms = (String[])this.safeGetResource(resourceBundle, "ampm", ampmsDefault);
        this.eras = (String[])this.safeGetResource(resourceBundle, "eras", erasDefault);
        this.localPatternChars = (String)this.safeGetResource(resourceBundle, "datePatternChars", localPatternCharsDefault);
        this.months = (String[])this.safeGetResource(resourceBundle, "months", monthsDefault);
        this.shortMonths = (String[])this.safeGetResource(resourceBundle, "shortMonths", shortMonthsDefault);
        this.shortWeekdays = (String[])this.safeGetResource(resourceBundle, "shortWeekdays", shortWeekdaysDefault);
        this.weekdays = (String[])this.safeGetResource(resourceBundle, "weekdays", weekdaysDefault);
        this.zoneStrings = (String[][])this.safeGetResource(resourceBundle, "zoneStrings", zoneStringsDefault);
        this.dateFormats = this.formatsForKey(resourceBundle, "DateFormat");
        this.timeFormats = this.formatsForKey(resourceBundle, "TimeFormat");
    }

    public DateFormatSymbols() {
        this(Locale.getDefault());
    }

    private DateFormatSymbols(DateFormatSymbols dateFormatSymbols) {
        this.ampms = dateFormatSymbols.ampms;
        this.eras = dateFormatSymbols.eras;
        this.localPatternChars = dateFormatSymbols.localPatternChars;
        this.months = dateFormatSymbols.months;
        this.shortMonths = dateFormatSymbols.shortMonths;
        this.shortWeekdays = dateFormatSymbols.shortWeekdays;
        this.weekdays = dateFormatSymbols.weekdays;
        this.zoneStrings = dateFormatSymbols.zoneStrings;
        this.dateFormats = dateFormatSymbols.dateFormats;
        this.timeFormats = dateFormatSymbols.timeFormats;
    }

    public String[] getAmPmStrings() {
        return this.ampms;
    }

    public String[] getEras() {
        return this.eras;
    }

    public String getLocalPatternChars() {
        return this.localPatternChars;
    }

    public String[] getMonths() {
        return this.months;
    }

    public String[] getShortMonths() {
        return this.shortMonths;
    }

    public String[] getShortWeekdays() {
        return this.shortWeekdays;
    }

    public String[] getWeekdays() {
        return this.weekdays;
    }

    public String[][] getZoneStrings() {
        return this.zoneStrings;
    }

    public void setAmPmStrings(String[] stringArray) {
        this.ampms = stringArray;
    }

    public void setEras(String[] stringArray) {
        this.eras = stringArray;
    }

    public void setLocalPatternChars(String string) {
        this.localPatternChars = string;
    }

    public void setMonths(String[] stringArray) {
        this.months = stringArray;
    }

    public void setShortMonths(String[] stringArray) {
        this.shortMonths = stringArray;
    }

    public void setShortWeekdays(String[] stringArray) {
        this.shortWeekdays = stringArray;
    }

    public void setWeekdays(String[] stringArray) {
        this.weekdays = stringArray;
    }

    public void setZoneStrings(String[][] stringArray) {
        this.zoneStrings = stringArray;
    }

    private static boolean equals(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        if (!(object instanceof Object[]) || !(object2 instanceof Object[])) {
            return object.equals(object2);
        }
        Object[] objectArray = (Object[])object;
        Object[] objectArray2 = (Object[])object2;
        if (objectArray.length != objectArray2.length) {
            return false;
        }
        int n = objectArray.length;
        while (--n >= 0) {
            if (DateFormatSymbols.equals(objectArray[n], objectArray2[n])) continue;
            return false;
        }
        return true;
    }

    private static int hashCode(Object object) {
        if (object == null) {
            return 0;
        }
        if (!(object instanceof Object[])) {
            return object.hashCode();
        }
        Object[] objectArray = (Object[])object;
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            n = 37 * DateFormatSymbols.hashCode(objectArray[i]);
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof DateFormatSymbols)) {
            return false;
        }
        DateFormatSymbols dateFormatSymbols = (DateFormatSymbols)object;
        return DateFormatSymbols.equals(this.ampms, dateFormatSymbols.ampms) && DateFormatSymbols.equals(this.eras, dateFormatSymbols.eras) && DateFormatSymbols.equals(this.localPatternChars, dateFormatSymbols.localPatternChars) && DateFormatSymbols.equals(this.months, dateFormatSymbols.months) && DateFormatSymbols.equals(this.shortMonths, dateFormatSymbols.shortMonths) && DateFormatSymbols.equals(this.shortWeekdays, dateFormatSymbols.shortWeekdays) && DateFormatSymbols.equals(this.weekdays, dateFormatSymbols.weekdays) && DateFormatSymbols.equals(this.zoneStrings, dateFormatSymbols.zoneStrings);
    }

    public Object clone() {
        return new DateFormatSymbols(this);
    }

    public int hashCode() {
        return DateFormatSymbols.hashCode(this.ampms) ^ DateFormatSymbols.hashCode(this.eras) ^ DateFormatSymbols.hashCode(this.localPatternChars) ^ DateFormatSymbols.hashCode(this.months) ^ DateFormatSymbols.hashCode(this.shortMonths) ^ DateFormatSymbols.hashCode(this.shortWeekdays) ^ DateFormatSymbols.hashCode(this.weekdays) ^ DateFormatSymbols.hashCode(this.zoneStrings);
    }

    static {
        localPatternCharsDefault = localPatternCharsDefault;
        monthsDefault = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December", ""};
        shortMonthsDefault = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec", ""};
        shortWeekdaysDefault = new String[]{"", "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
        weekdaysDefault = new String[]{"", "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
        zoneStringsDefault = new String[][]{{"GMT", "Greenwich Mean Time", "GMT", "Greenwich Mean Time", "GMT", "GMT"}, {"PST", "Pacific Standard Time", "PST", "Pacific Daylight Time", "PDT", "San Francisco"}, {"MST", "Mountain Standard Time", "MST", "Mountain Daylight Time", "MDT", "Denver"}, {"PNT", "Mountain Standard Time", "MST", "Mountain Standard Time", "MST", "Phoenix"}, {"CST", "Central Standard Time", "CST", "Central Daylight Time", "CDT", "Chicago"}, {"EST", "Eastern Standard Time", "EST", "Eastern Daylight Time", "EDT", "Boston"}, {"IET", "Eastern Standard Time", "EST", "Eastern Standard Time", "EST", "Indianapolis"}, {"PRT", "Atlantic Standard Time", "AST", "Atlantic Daylight Time", "ADT", "Halifax"}, {"CNT", "Newfoundland Standard Time", "NST", "Newfoundland Daylight Time", "NDT", "St. Johns"}, {"ECT", "Central European Standard Time", "CET", "Central European Daylight Time", "CEST", "Paris"}, {"CTT", "China Standard Time", "CST", "China Standard Time", "CST", "Shanghai"}, {"JST", "Japan Standard Time", "JST", "Japan Standard Time", "JST", "Tokyo"}, {"HST", "Hawaii Standard Time", "HST", "Hawaii Standard Time", "HST", "Honolulu"}, {"AST", "Alaska Standard Time", "AKST", "Alaska Daylight Time", "AKDT", "Anchorage"}};
    }
}

