/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TimeZone;

public abstract class DateFormat
extends Format
implements Cloneable {
    protected Calendar calendar;
    protected NumberFormat numberFormat;
    public static final int FULL = 0;
    public static final int LONG = 1;
    public static final int MEDIUM = 2;
    public static final int SHORT = 3;
    public static final int DEFAULT = 2;
    public static final int ERA_FIELD = 0;
    public static final int YEAR_FIELD = 1;
    public static final int MONTH_FIELD = 2;
    public static final int DATE_FIELD = 3;
    public static final int HOUR_OF_DAY1_FIELD = 4;
    public static final int HOUR_OF_DAY0_FIELD = 5;
    public static final int MINUTE_FIELD = 6;
    public static final int SECOND_FIELD = 7;
    public static final int MILLISECOND_FIELD = 8;
    public static final int DAY_OF_WEEK_FIELD = 9;
    public static final int DAY_OF_YEAR_FIELD = 10;
    public static final int DAY_OF_WEEK_IN_MONTH_FIELD = 11;
    public static final int WEEK_OF_YEAR_FIELD = 12;
    public static final int WEEK_OF_MONTH_FIELD = 13;
    public static final int AM_PM_FIELD = 14;
    public static final int HOUR1_FIELD = 15;
    public static final int HOUR0_FIELD = 16;
    public static final int TIMEZONE_FIELD = 17;

    protected DateFormat() {
    }

    public boolean equals(Object object) {
        if (!(object instanceof DateFormat)) {
            return false;
        }
        DateFormat dateFormat = (DateFormat)object;
        return this.calendar.equals(dateFormat.calendar) && this.numberFormat.equals(dateFormat.numberFormat);
    }

    public Object clone() {
        return super.clone();
    }

    public final StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (object instanceof Number) {
            return this.format(new Date(((Number)object).longValue()), stringBuffer, fieldPosition);
        }
        return this.format((Date)object, stringBuffer, fieldPosition);
    }

    public final String format(Date date) {
        StringBuffer stringBuffer = new StringBuffer();
        this.format(date, stringBuffer, new FieldPosition(2));
        return stringBuffer.toString();
    }

    public abstract StringBuffer format(Date var1, StringBuffer var2, FieldPosition var3);

    public static Locale[] getAvailableLocales() {
        return null;
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    private static final DateFormat computeInstance(int n, Locale locale, boolean bl, boolean bl2) {
        return DateFormat.computeInstance(n, n, locale, bl, bl2);
    }

    private static final DateFormat computeInstance(int n, int n2, Locale locale, boolean bl, boolean bl2) {
        String string;
        String string2;
        ResourceBundle resourceBundle;
        try {
            resourceBundle = ResourceBundle.getBundle("gnu.gcj.text.LocaleData", locale);
        }
        catch (MissingResourceException missingResourceException) {
            resourceBundle = null;
        }
        String string3 = null;
        if (bl) {
            switch (n) {
                case 0: {
                    string2 = "fullDateFormat";
                    string = "EEEE MMMM d, yyyy G";
                    break;
                }
                case 1: {
                    string2 = "longDateFormat";
                    string = "MMMM d, yyyy";
                    break;
                }
                case 2: {
                    string2 = "mediumDateFormat";
                    string = "d-MMM-yy";
                    break;
                }
                case 3: {
                    string2 = "shortDateFormat";
                    string = "M/d/yy";
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            try {
                string3 = resourceBundle == null ? string : resourceBundle.getString(string2);
            }
            catch (MissingResourceException missingResourceException) {
                string3 = string;
            }
        }
        if (bl2) {
            String string4;
            string3 = string3 == null ? "" : string3 + " ";
            switch (n2) {
                case 0: {
                    string2 = "fullTimeFormat";
                    string = "h:mm:ss;S 'o''clock' a z";
                    break;
                }
                case 1: {
                    string2 = "longTimeFormat";
                    string = "h:mm:ss a z";
                    break;
                }
                case 2: {
                    string2 = "mediumTimeFormat";
                    string = "h:mm:ss a";
                    break;
                }
                case 3: {
                    string2 = "shortTimeFormat";
                    string = "h:mm a";
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            try {
                string4 = resourceBundle == null ? string : resourceBundle.getString(string2);
            }
            catch (MissingResourceException missingResourceException) {
                string4 = string;
            }
            string3 = string3 + string4;
        }
        return new SimpleDateFormat(string3, locale);
    }

    public static final DateFormat getDateInstance() {
        return DateFormat.getDateInstance(2, Locale.getDefault());
    }

    public static final DateFormat getDateInstance(int n) {
        return DateFormat.getDateInstance(n, Locale.getDefault());
    }

    public static final DateFormat getDateInstance(int n, Locale locale) {
        return DateFormat.computeInstance(n, locale, true, false);
    }

    public static final DateFormat getDateTimeInstance() {
        return DateFormat.getDateTimeInstance(2, 2, Locale.getDefault());
    }

    public static final DateFormat getDateTimeInstance(int n, int n2) {
        return DateFormat.getDateTimeInstance(n, n2, Locale.getDefault());
    }

    public static final DateFormat getDateTimeInstance(int n, int n2, Locale locale) {
        return DateFormat.computeInstance(n, n2, locale, true, true);
    }

    public static final DateFormat getInstance() {
        return DateFormat.getDateTimeInstance(3, 3, Locale.getDefault());
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public static final DateFormat getTimeInstance() {
        return DateFormat.getTimeInstance(2, Locale.getDefault());
    }

    public static final DateFormat getTimeInstance(int n) {
        return DateFormat.getTimeInstance(n, Locale.getDefault());
    }

    public static final DateFormat getTimeInstance(int n, Locale locale) {
        return DateFormat.computeInstance(n, locale, false, true);
    }

    public TimeZone getTimeZone() {
        return this.calendar.getTimeZone();
    }

    public int hashCode() {
        int n = this.calendar.hashCode();
        if (this.numberFormat != null) {
            n ^= this.numberFormat.hashCode();
        }
        return n;
    }

    public boolean isLenient() {
        return this.calendar.isLenient();
    }

    public Date parse(String string) throws ParseException {
        ParsePosition parsePosition = new ParsePosition(0);
        Date date = this.parse(string, parsePosition);
        if (date == null) {
            int n = parsePosition.getErrorIndex();
            if (n < 0) {
                n = parsePosition.getIndex();
            }
            throw new ParseException("invalid Date syntax", n);
        }
        return date;
    }

    public abstract Date parse(String var1, ParsePosition var2);

    public Object parseObject(String string, ParsePosition parsePosition) {
        return this.parse(string, parsePosition);
    }

    public void setCalendar(Calendar calendar) {
        this.calendar = calendar;
    }

    public void setLenient(boolean bl) {
        this.calendar.setLenient(bl);
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.calendar.setTimeZone(timeZone);
    }
}

