/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.CollationKey;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.util.Comparator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class Collator
implements Comparator,
Cloneable {
    public static final int NO_DECOMPOSITION = 0;
    public static final int CANONICAL_DECOMPOSITION = 1;
    public static final int FULL_DECOMPOSITION = 2;
    public static final int PRIMARY = 0;
    public static final int SECONDARY = 1;
    public static final int TERTIARY = 2;
    public static final int IDENTICAL = 3;
    int decmp = 1;
    int strength = 2;

    protected Collator() {
    }

    public abstract int compare(String var1, String var2);

    public int compare(Object object, Object object2) {
        return this.compare((String)object, (String)object2);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Collator)) {
            return false;
        }
        Collator collator = (Collator)object;
        return this.decmp == collator.decmp && this.strength == collator.strength;
    }

    public boolean equals(String string, String string2) {
        return this.compare(string, string2) == 0;
    }

    public Object clone() {
        return super.clone();
    }

    public static synchronized Locale[] getAvailableLocales() {
        return null;
    }

    public abstract CollationKey getCollationKey(String var1);

    public synchronized int getDecomposition() {
        return this.decmp;
    }

    public static Collator getInstance() {
        return Collator.getInstance(Locale.getDefault());
    }

    public static Collator getInstance(Locale locale) {
        String string;
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("gnu.gcj.text.LocaleData", locale);
            string = resourceBundle.getString("collatorRule");
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
        try {
            return new RuleBasedCollator(string);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public synchronized int getStrength() {
        return this.strength;
    }

    public abstract int hashCode();

    public synchronized void setDecomposition(int n) {
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException();
        }
        this.decmp = n;
    }

    public synchronized void setStrength(int n) {
        if (n != 0 && n != 1 && n != 2 && n != 3) {
            throw new IllegalArgumentException();
        }
        this.strength = n;
    }

    final native void decomposeCharacter(char var1, StringBuffer var2);
}

