/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.CollationElementIterator;
import java.text.RuleBasedCollator;

public final class CollationKey
implements Comparable {
    private String originalText;
    private int[] key;

    public int compareTo(CollationKey collationKey) {
        int n = Math.min(this.key.length, collationKey.key.length);
        for (int i = 0; i < n; ++i) {
            if (this.key[i] == collationKey.key[i]) continue;
            return this.key[i] - collationKey.key[i];
        }
        return this.key.length - collationKey.key.length;
    }

    public int compareTo(Object object) {
        return this.compareTo((CollationKey)object);
    }

    public boolean equals(Object object) {
        if (!(object instanceof CollationKey)) {
            return false;
        }
        CollationKey collationKey = (CollationKey)object;
        if (this.key.length != collationKey.key.length) {
            return false;
        }
        for (int i = 0; i < this.key.length; ++i) {
            if (this.key[i] == collationKey.key[i]) continue;
            return false;
        }
        return true;
    }

    public String getSourceString() {
        return this.originalText;
    }

    public int hashCode() {
        long l = this.originalText.hashCode();
        for (int i = this.key.length - 1; i >= 0; --i) {
            l ^= (long)(this.key[i] * (i + 1));
        }
        return (int)(l >> 32) ^ (int)l;
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[4 * this.key.length];
        int n = 0;
        for (int i = 0; i < this.key.length; ++i) {
            byArray[n++] = (byte)(this.key[i] >>> 24) & 0xFFFFFFFF;
            byArray[n++] = (byte)(this.key[i] >>> 16) & 0xFFFFFFFF;
            byArray[n++] = (byte)(this.key[i] >>> 8) & 0xFFFFFFFF;
            byArray[n++] = (byte)this.key[i] & 0xFFFFFFFF;
        }
        return byArray;
    }

    CollationKey(CollationElementIterator collationElementIterator, String string, int n) {
        this.originalText = string;
        int n2 = 0;
        while (RuleBasedCollator.next(collationElementIterator, n) != -1) {
            ++n2;
        }
        collationElementIterator.reset();
        this.key = new int[n2];
        for (int i = 0; i < n2; ++i) {
            this.key[i] = RuleBasedCollator.next(collationElementIterator, n);
        }
    }
}

