/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.io.InputStream;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactorySpi;
import java.util.Collection;

public class CertificateFactory {
    private CertificateFactorySpi certFacSpi;
    private Provider provider;
    private String type;

    protected CertificateFactory(CertificateFactorySpi certificateFactorySpi, Provider provider, String string) {
        this.certFacSpi = certificateFactorySpi;
        this.provider = provider;
        this.type = string;
    }

    public static final CertificateFactory getInstance(String string) throws CertificateException {
        Provider[] providerArray = Security.getProviders();
        for (int i = 0; i < providerArray.length; ++i) {
            String string2 = providerArray[i].getProperty("CertificateFactory." + string);
            if (string2 == null) continue;
            return CertificateFactory.getInstance(string2, string, providerArray[i]);
        }
        throw new CertificateException(string);
    }

    public static final CertificateFactory getInstance(String string, String string2) throws NoSuchProviderException, CertificateException {
        Provider provider = Security.getProvider(string2);
        if (provider == null) {
            throw new NoSuchProviderException();
        }
        return CertificateFactory.getInstance(provider.getProperty("CertificateFactory." + string), string, provider);
    }

    private static CertificateFactory getInstance(String string, String string2, Provider provider) throws CertificateException {
        try {
            return new CertificateFactory((CertificateFactorySpi)Class.forName(string).newInstance(), provider, string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new CertificateException("Class not found");
        }
        catch (InstantiationException instantiationException) {
            throw new CertificateException("Class instantiation failed");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new CertificateException("Illegal Access");
        }
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final String getType() {
        return this.type;
    }

    public final Certificate generateCertificate(InputStream inputStream) throws CertificateException {
        return this.certFacSpi.engineGenerateCertificate(inputStream);
    }

    public final Collection generateCertificates(InputStream inputStream) throws CertificateException {
        return this.certFacSpi.engineGenerateCertificates(inputStream);
    }

    public final CRL generateCRL(InputStream inputStream) throws CRLException {
        return this.certFacSpi.engineGenerateCRL(inputStream);
    }

    public final Collection generateCRLs(InputStream inputStream) throws CRLException {
        return this.certFacSpi.engineGenerateCRLs(inputStream);
    }
}

