/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.SignatureException;

public abstract class Signature {
    protected static final int UNINITIALIZED = 0;
    protected static final int SIGN = 2;
    protected static final int VERIFY = 3;
    protected int state = 0;
    private String name;

    protected Signature(String string) {
        this.name = string;
    }

    public static Signature getInstance(String string) throws NoSuchAlgorithmException {
        String string2 = "Signature." + string;
        Provider[] providerArray = Security.getProviders();
        for (int i = 0; i < providerArray.length; ++i) {
            String string3 = providerArray[i].getProperty(string2);
            if (string3 == null) continue;
            try {
                return (Signature)Class.forName(string3).newInstance();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        throw new NoSuchAlgorithmException(string);
    }

    public static Signature getInstance(String string, String string2) throws NoSuchProviderException, NoSuchAlgorithmException {
        String string3 = "Signature." + string;
        Provider provider = Security.getProvider(string2);
        if (provider == null) {
            throw new NoSuchProviderException(string2);
        }
        String string4 = provider.getProperty(string3);
        if (string4 != null) {
            try {
                return (Signature)Class.forName(string4).newInstance();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        throw new NoSuchAlgorithmException(string);
    }

    public final void initVerify(PublicKey publicKey) throws InvalidKeyException {
        this.engineInitVerify(publicKey);
    }

    public final void initSign(PrivateKey privateKey) throws InvalidKeyException {
        this.engineInitSign(privateKey);
    }

    public final byte[] sign() throws SignatureException {
        return this.engineSign();
    }

    public final boolean verify(byte[] byArray) throws SignatureException {
        return this.engineVerify(byArray);
    }

    public final void update(byte by) throws SignatureException {
        this.engineUpdate(by);
    }

    public final void update(byte[] byArray) throws SignatureException {
        this.engineUpdate(byArray, 0, byArray.length);
    }

    public final void update(byte[] byArray, int n, int n2) throws SignatureException {
        this.engineUpdate(byArray, n, n2);
    }

    public final String getAlgorithm() {
        return this.name;
    }

    public String toString() {
        return this.name + "; state = " + this.state;
    }

    public final void setParameter(String string, Object object) {
        this.engineSetParameter(string, object);
    }

    public final Object getParameter(String string) {
        return this.engineGetParameter(string);
    }

    protected abstract void engineInitVerify(PublicKey var1) throws InvalidKeyException;

    protected abstract void engineInitSign(PrivateKey var1) throws InvalidKeyException;

    protected abstract void engineUpdate(byte var1) throws SignatureException;

    protected abstract void engineUpdate(byte[] var1, int var2, int var3) throws SignatureException;

    protected abstract byte[] engineSign() throws SignatureException;

    protected abstract boolean engineVerify(byte[] var1) throws SignatureException;

    protected abstract void engineSetParameter(String var1, Object var2) throws InvalidParameterException;

    protected abstract Object engineGetParameter(String var1) throws InvalidParameterException;

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

