/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;

public abstract class MessageDigest {
    private String name;

    protected MessageDigest(String string) {
        this.name = string;
    }

    public static MessageDigest getInstance(String string) throws NoSuchAlgorithmException {
        String string2 = "MessageDigest." + string;
        Provider[] providerArray = Security.getProviders();
        for (int i = 0; i < providerArray.length; ++i) {
            String string3 = providerArray[i].getProperty(string2);
            if (string3 == null) continue;
            try {
                return (MessageDigest)Class.forName(string3).newInstance();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        throw new NoSuchAlgorithmException(string);
    }

    public static MessageDigest getInstance(String string, String string2) throws NoSuchProviderException, NoSuchAlgorithmException {
        String string3 = "MessageDigest." + string;
        Provider provider = Security.getProvider(string2);
        if (provider == null) {
            throw new NoSuchProviderException(string2);
        }
        String string4 = provider.getProperty(string3);
        if (string4 != null) {
            try {
                return (MessageDigest)Class.forName(string4).newInstance();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        throw new NoSuchAlgorithmException(string);
    }

    public void update(byte by) {
        this.engineUpdate(by);
    }

    public void update(byte[] byArray, int n, int n2) {
        this.engineUpdate(byArray, n, n2);
    }

    public void update(byte[] byArray) {
        this.engineUpdate(byArray, 0, byArray.length);
    }

    public byte[] digest() {
        return this.engineDigest();
    }

    public byte[] digest(byte[] byArray) {
        this.update(byArray);
        return this.engineDigest();
    }

    public String toString() {
        return "[MessageDigest: " + this.name + "]";
    }

    public static boolean isEqual(byte[] byArray, byte[] byArray2) {
        if (byArray == byArray2) {
            return true;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = byArray.length - 1; i >= 0; --i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public void reset() {
        this.engineReset();
    }

    public final String getAlgorithm() {
        return this.name;
    }

    protected abstract void engineUpdate(byte var1);

    protected abstract void engineUpdate(byte[] var1, int var2, int var3);

    protected abstract byte[] engineDigest();

    protected abstract void engineReset();

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

