/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;

public abstract class KeyPairGenerator
extends KeyPairGeneratorSpi {
    private String name;

    protected KeyPairGenerator(String string) {
        this.name = string;
    }

    public static KeyPairGenerator getInstance(String string) throws NoSuchAlgorithmException {
        String string2 = "KeyPairGenerator." + string;
        Provider[] providerArray = Security.getProviders();
        for (int i = 0; i < providerArray.length; ++i) {
            String string3 = providerArray[i].getProperty(string2);
            if (string3 == null) continue;
            try {
                return (KeyPairGenerator)Class.forName(string3).newInstance();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        throw new NoSuchAlgorithmException(string);
    }

    public static KeyPairGenerator getInstance(String string, String string2) throws NoSuchProviderException, NoSuchAlgorithmException {
        String string3 = "KeyPairGenerator." + string;
        Provider provider = Security.getProvider(string2);
        if (provider == null) {
            throw new NoSuchProviderException(string2);
        }
        String string4 = provider.getProperty(string3);
        if (string4 != null) {
            try {
                return (KeyPairGenerator)Class.forName(string4).newInstance();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        throw new NoSuchAlgorithmException(string);
    }

    public String getAlgorithm() {
        return this.name;
    }

    public abstract void initialize(int var1, SecureRandom var2);

    public abstract KeyPair generateKeyPair();
}

