/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class BasicPermission
extends Permission
implements Serializable {
    public BasicPermission(String string) {
        super(string);
        if (string.indexOf("*") != -1) {
            if (!string.endsWith(".*") && !string.equals("*")) {
                throw new IllegalArgumentException("Bad wildcard: " + string);
            }
            if (string.indexOf("*") != string.lastIndexOf("*")) {
                throw new IllegalArgumentException("Bad wildcard: " + string);
            }
        }
    }

    public BasicPermission(String string, String string2) {
        this(string);
    }

    public boolean implies(Permission permission) {
        if (!(permission instanceof BasicPermission)) {
            return false;
        }
        String string = permission.getName();
        String string2 = this.getName();
        if (string2.equals(string)) {
            return true;
        }
        int n = string2.length() - 1;
        return string2.charAt(n) == '*' && string.startsWith(string2.substring(0, n));
    }

    public boolean equals(Object object) {
        if (!(object instanceof BasicPermission)) {
            return false;
        }
        return this.getName().equals(((BasicPermission)object).getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String getActions() {
        return "";
    }

    public PermissionCollection newPermissionCollection() {
        return new PermissionCollection(this){
            private /* synthetic */ BasicPermission this$0;
            Hashtable permissions;
            boolean allAllowed;
            {
                this.this$0 = basicPermission;
                this.finit$();
            }

            private /* synthetic */ void finit$() {
                this.permissions = new Hashtable();
                this.allAllowed = false;
            }

            public void add(Permission permission) {
                if (this.isReadOnly()) {
                    throw new IllegalStateException("readonly");
                }
                BasicPermission basicPermission = (BasicPermission)permission;
                String string = basicPermission.getName();
                if (string.equals("*")) {
                    this.allAllowed = true;
                }
                this.permissions.put(string, basicPermission);
            }

            public boolean implies(Permission permission) {
                if (!(permission instanceof BasicPermission)) {
                    return false;
                }
                if (this.allAllowed) {
                    return true;
                }
                BasicPermission basicPermission = (BasicPermission)permission;
                String string = basicPermission.getName();
                if (string.equals("*")) {
                    return false;
                }
                int n = string.length();
                if (string.endsWith("*")) {
                    n -= 2;
                }
                while (this.permissions.get(string) == null) {
                    if ((n = string.lastIndexOf(46, n)) < 0) {
                        return false;
                    }
                    string = string.substring(0, n + 1) + '*';
                }
                return true;
            }

            public Enumeration elements() {
                return this.permissions.elements();
            }
        };
    }
}

