/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import gnu.gcj.io.MimeTypes;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ContentHandler;
import java.net.ContentHandlerFactory;
import java.net.FileNameMap;
import java.net.URL;
import java.net.UnknownServiceException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;

public abstract class URLConnection {
    protected URL url;
    protected boolean doInput;
    protected boolean doOutput;
    protected boolean allowUserInteraction;
    protected boolean useCaches;
    protected long ifModifiedSince;
    protected boolean connected;
    private static boolean defaultAllowUserInteraction = false;
    private static boolean defaultUseCaches = true;
    private static FileNameMap fileNameMap;
    private static ContentHandlerFactory factory;
    private static ContentHandler contentHandler;
    private static Hashtable handlers;
    private static Locale locale;
    private static SimpleDateFormat dateFormat1;
    private static SimpleDateFormat dateFormat2;
    private static SimpleDateFormat dateFormat3;
    private static boolean dateformats_initialized = false;

    private /* synthetic */ void finit$() {
        this.doInput = true;
        this.doOutput = false;
        this.ifModifiedSince = 0L;
        this.connected = false;
    }

    protected URLConnection(URL uRL) {
        this.finit$();
        this.url = uRL;
        this.allowUserInteraction = defaultAllowUserInteraction;
        this.useCaches = defaultUseCaches;
    }

    public abstract void connect() throws IOException;

    public URL getURL() {
        return this.url;
    }

    public int getContentLength() {
        return this.getHeaderFieldInt("content-length", -1);
    }

    public String getContentType() {
        return this.getHeaderField("content-type");
    }

    public String getContentEncoding() {
        return this.getHeaderField("content-encoding");
    }

    public long getExpiration() {
        return this.getHeaderFieldDate("expiration", 0L);
    }

    public long getDate() {
        return this.getHeaderFieldDate("date", 0L);
    }

    public long getLastModified() {
        return this.getHeaderFieldDate("last-modified", 0L);
    }

    public String getHeaderField(int n) {
        return null;
    }

    public String getHeaderField(String string) {
        return null;
    }

    public int getHeaderFieldInt(String string, int n) {
        String string2 = this.getHeaderField(string);
        try {
            if (string2 != null) {
                n = Integer.parseInt(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    public long getHeaderFieldDate(String string, long l) {
        String string2;
        if (!dateformats_initialized) {
            this.initializeDateFormats();
        }
        if ((string2 = this.getHeaderField(string)) != null) {
            Date date = dateFormat1.parse(string2, new ParsePosition(0));
            if (date != null) {
                l = date.getTime();
            } else {
                date = dateFormat2.parse(string2, new ParsePosition(0));
                if (date != null) {
                    l = date.getTime();
                } else {
                    date = dateFormat3.parse(string2, new ParsePosition(0));
                    if (date != null) {
                        l = date.getTime();
                    }
                }
            }
        }
        return l;
    }

    public String getHeaderFieldKey(int n) {
        return null;
    }

    public Object getContent() throws IOException {
        String string = this.getContentType();
        contentHandler = this.setContentHandler(string);
        if (contentHandler == null) {
            return this.getInputStream();
        }
        return contentHandler.getContent(this);
    }

    public InputStream getInputStream() throws IOException {
        throw new UnknownServiceException("Protocol " + this.url.getProtocol() + " does not support input.");
    }

    public OutputStream getOutputStream() throws IOException {
        throw new UnknownServiceException("Protocol " + this.url.getProtocol() + " does not support output.");
    }

    public String toString() {
        return this.getClass().getName() + ":" + this.url.toString();
    }

    public void setDoInput(boolean bl) {
        if (this.connected) {
            throw new IllegalAccessError("Already connected");
        }
        this.doInput = bl;
    }

    public boolean getDoInput() {
        return this.doInput;
    }

    public void setDoOutput(boolean bl) {
        if (this.connected) {
            throw new IllegalAccessError("Already connected");
        }
        this.doOutput = bl;
    }

    public boolean getDoOutput() {
        return this.doOutput;
    }

    public void setAllowUserInteraction(boolean bl) {
        if (this.connected) {
            throw new IllegalAccessError("Already connected");
        }
        this.allowUserInteraction = bl;
    }

    public boolean getAllowUserInteraction() {
        return this.allowUserInteraction;
    }

    public static void setDefaultAllowUserInteraction(boolean bl) {
        defaultAllowUserInteraction = bl;
    }

    public static boolean getDefaultAllowUserInteraction() {
        return defaultAllowUserInteraction;
    }

    public void setUseCaches(boolean bl) {
        if (this.connected) {
            throw new IllegalAccessError("Already connected");
        }
        this.useCaches = bl;
    }

    public boolean getUseCaches() {
        return this.useCaches;
    }

    public void setIfModifiedSince(long l) {
        if (this.connected) {
            throw new IllegalAccessError("Already connected");
        }
        this.ifModifiedSince = l;
    }

    public long getIfModifiedSince() {
        return this.ifModifiedSince;
    }

    public boolean getDefaultUseCaches() {
        return defaultUseCaches;
    }

    public void setDefaultUseCaches(boolean bl) {
        defaultUseCaches = bl;
    }

    public void setRequestProperty(String string, String string2) {
    }

    public String getRequestProperty(String string) {
        return null;
    }

    public static void setDefaultRequestProperty(String string, String string2) {
    }

    public static String getDefaultRequestProperty(String string) {
        return null;
    }

    public static void setContentHandlerFactory(ContentHandlerFactory contentHandlerFactory) {
        if (factory != null) {
            throw new Error("ContentHandlerFactory already set");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        factory = contentHandlerFactory;
    }

    protected static String guessContentTypeFromName(String string) {
        String string2;
        int n = string.lastIndexOf(".");
        if (n != -1) {
            if (n == string.length()) {
                return "application/octet-stream";
            }
            string = string.substring(n + 1);
        }
        if ((string2 = MimeTypes.getMimeTypeFromExtension(string)) == null) {
            return "application/octet-stream";
        }
        return string2;
    }

    public static FileNameMap getFileNameMap() {
        return fileNameMap;
    }

    public static void setFileNameMap(FileNameMap fileNameMap) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        URLConnection.fileNameMap = fileNameMap;
    }

    private ContentHandler setContentHandler(String string) {
        if (string == null || string == "") {
            return null;
        }
        ContentHandler contentHandler = (ContentHandler)handlers.get(string);
        if (contentHandler != null) {
            if (contentHandler instanceof ContentHandler) {
                return contentHandler;
            }
            return null;
        }
        if (factory != null) {
            contentHandler = factory.createContentHandler(string);
        }
        if (contentHandler == null) {
            String string2 = System.getProperty("java.content.handler.pkgs");
            string2 = string2 == null ? "" : string2 + "|";
            string2 = string2 + "gnu.gcj.content|sun.net.www.content";
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
            char[] cArray = string.toCharArray();
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] == '/') {
                    cArray[i] = 46;
                    continue;
                }
                if (cArray[i] >= 'A' && cArray[i] <= 'Z' || cArray[i] >= 'a' && cArray[i] <= 'z' || cArray[i] >= '0' && cArray[i] <= '9') continue;
                cArray[i] = 95;
            }
            String string3 = new String(cArray);
            do {
                String string4 = stringTokenizer.nextToken() + "." + string3;
                try {
                    contentHandler = (ContentHandler)Class.forName(string4).newInstance();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            } while ((contentHandler == null || !(contentHandler instanceof ContentHandler)) && stringTokenizer.hasMoreTokens());
        }
        if (contentHandler != null && contentHandler instanceof ContentHandler) {
            handlers.put(string, contentHandler);
            return contentHandler;
        }
        handlers.put(string, string);
        return null;
    }

    private synchronized void initializeDateFormats() {
        if (dateformats_initialized) {
            return;
        }
        locale = new Locale("En", "Us", "Unix");
        dateFormat1 = new SimpleDateFormat("EEE, dd MMM yyyy hh:mm:ss 'GMT'", locale);
        dateFormat2 = new SimpleDateFormat("EEEE, dd-MMM-yy hh:mm:ss 'GMT'", locale);
        dateFormat3 = new SimpleDateFormat("EEE MMM d hh:mm:ss yyyy", locale);
        dateformats_initialized = true;
    }

    static {
        defaultAllowUserInteraction = false;
        defaultUseCaches = true;
        handlers = new Hashtable();
        dateformats_initialized = false;
    }
}

