/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.PlainSocketImpl;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketImplFactory;
import java.net.UnknownHostException;

public class Socket {
    static SocketImplFactory factory;
    SocketImpl impl;

    protected Socket() {
    }

    protected Socket(SocketImpl socketImpl) throws SocketException {
        this.impl = socketImpl;
    }

    public Socket(String string, int n) throws IOException, UnknownHostException {
        this(factory == null ? new PlainSocketImpl() : factory.createSocketImpl());
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkConnect(string, n);
        }
        this.impl.create(true);
        this.impl.connect(string, n);
    }

    public Socket(InetAddress inetAddress, int n) throws IOException {
        this(factory == null ? new PlainSocketImpl() : factory.createSocketImpl());
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkConnect(inetAddress.getHostName(), n);
        }
        this.impl.create(true);
        this.impl.connect(inetAddress, n);
    }

    public Socket(String string, int n, InetAddress inetAddress, int n2) throws IOException {
        this(factory == null ? new PlainSocketImpl() : factory.createSocketImpl());
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkConnect(string, n);
        }
        this.impl.create(true);
        this.impl.bind(inetAddress, n2);
        this.impl.connect(string, n);
    }

    public Socket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        this(factory == null ? new PlainSocketImpl() : factory.createSocketImpl());
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkConnect(inetAddress.getHostName(), n);
        }
        this.impl.create(true);
        this.impl.bind(inetAddress2, n2);
        this.impl.connect(inetAddress, n);
    }

    public Socket(String string, int n, boolean bl) throws IOException {
        this.impl = factory == null ? new PlainSocketImpl() : factory.createSocketImpl();
        this.impl.create(bl);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkConnect(string, n);
        }
        this.impl.connect(string, n);
    }

    public Socket(InetAddress inetAddress, int n, boolean bl) throws IOException {
        this.impl = factory == null ? new PlainSocketImpl() : factory.createSocketImpl();
        this.impl.create(bl);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkConnect(inetAddress.getHostName(), n);
        }
        this.impl.connect(inetAddress, n);
    }

    public InetAddress getInetAddress() {
        return this.impl.getInetAddress();
    }

    public InetAddress getLocalAddress() {
        try {
            return (InetAddress)this.impl.getOption(15);
        }
        catch (SocketException socketException) {
            System.err.println(socketException);
            throw new InternalError("Error in PlainSocketImpl.getOption");
        }
    }

    public int getPort() {
        return this.impl.getPort();
    }

    public int getLocalPort() {
        return this.impl.getLocalPort();
    }

    public InputStream getInputStream() throws IOException {
        return this.impl.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.impl.getOutputStream();
    }

    public void setTcpNoDelay(boolean bl) throws SocketException {
        this.impl.setOption(1, new Boolean(bl));
    }

    public boolean getTcpNoDelay() throws SocketException {
        Boolean bl = (Boolean)this.impl.getOption(1);
        return bl;
    }

    public void setSoLinger(boolean bl, int n) throws SocketException {
        if (bl && n >= 0) {
            if (n > 65535) {
                n = 65535;
            }
            this.impl.setOption(128, new Integer(n));
        } else {
            if (bl && n < 0) {
                throw new IllegalArgumentException("SO_LINGER must be >= 0");
            }
            this.impl.setOption(128, new Boolean(false));
        }
    }

    public int getSoLinger() throws SocketException {
        Object object = this.impl.getOption(128);
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return -1;
    }

    public synchronized void setSoTimeout(int n) throws SocketException {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid timeout: " + n);
        }
        this.impl.setOption(4102, new Integer(n));
    }

    public synchronized int getSoTimeout() throws SocketException {
        Object object = this.impl.getOption(4102);
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return 0;
    }

    public void setSendBufferSize(int n) throws SocketException {
        if (n <= 0) {
            throw new IllegalArgumentException("Invalid buffer size: " + n);
        }
        this.impl.setOption(4097, new Integer(n));
    }

    public int getSendBufferSize() throws SocketException {
        Integer n = (Integer)this.impl.getOption(4097);
        return n;
    }

    public void setReceiveBufferSize(int n) throws SocketException {
        if (n <= 0) {
            throw new IllegalArgumentException("Invalid buffer size: " + n);
        }
        this.impl.setOption(4098, new Integer(n));
    }

    public int getReceiveBufferSize() throws SocketException {
        Integer n = (Integer)this.impl.getOption(4098);
        return n;
    }

    public synchronized void close() throws IOException {
        this.impl.close();
    }

    public String toString() {
        return "Socket" + this.impl.toString();
    }

    public static synchronized void setSocketImplFactory(SocketImplFactory socketImplFactory) throws IOException {
        factory = socketImplFactory;
    }
}

