/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.PlainSocketImpl;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketImplFactory;

public class ServerSocket {
    static SocketImplFactory factory;
    SocketImpl impl = factory == null ? new PlainSocketImpl() : factory.createSocketImpl();
    static final byte[] zeros;
    static final InetAddress ANY_IF;

    public ServerSocket(int n) throws IOException {
        this(n, 50);
    }

    public ServerSocket(int n, int n2) throws IOException {
        this(n, n2, ANY_IF);
    }

    public ServerSocket(int n, int n2, InetAddress inetAddress) throws IOException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkListen(n);
        }
        this.impl.create(true);
        this.impl.bind(inetAddress == null ? ANY_IF : inetAddress, n);
        this.impl.listen(n2);
    }

    public InetAddress getInetAddress() {
        return this.impl.getInetAddress();
    }

    public int getLocalPort() {
        return this.impl.getLocalPort();
    }

    public Socket accept() throws IOException {
        Socket socket = new Socket(Socket.factory == null ? new PlainSocketImpl() : Socket.factory.createSocketImpl());
        this.implAccept(socket);
        return socket;
    }

    protected final void implAccept(Socket socket) throws IOException {
        this.impl.accept(socket.impl);
    }

    public void close() throws IOException {
        this.impl.close();
    }

    public synchronized void setSoTimeout(int n) throws SocketException {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid timeout: " + n);
        }
        this.impl.setOption(4102, new Integer(n));
    }

    public synchronized int getSoTimeout() throws SocketException {
        Object object = this.impl.getOption(4102);
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return 0;
    }

    public String toString() {
        return "ServerSocket" + this.impl.toString();
    }

    public static synchronized void setSocketFactory(SocketImplFactory socketImplFactory) throws IOException {
        factory = socketImplFactory;
    }

    static {
        zeros = new byte[]{0, 0, 0, 0};
        ANY_IF = new InetAddress(zeros, null);
    }
}

