/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.SocketException;

public class MulticastSocket
extends DatagramSocket {
    public MulticastSocket() throws IOException {
        super(0, ServerSocket.ANY_IF);
    }

    public MulticastSocket(int n) throws IOException {
        super(n, ServerSocket.ANY_IF);
    }

    public InetAddress getInterface() throws SocketException {
        return (InetAddress)this.impl.getOption(16);
    }

    public byte getTTL() throws IOException {
        return this.impl.getTTL();
    }

    public int getTimeToLive() throws IOException {
        return this.impl.getTimeToLive();
    }

    public void setInterface(InetAddress inetAddress) throws SocketException {
        this.impl.setOption(16, inetAddress);
    }

    public void setTTL(byte by) throws IOException {
        this.impl.setTTL(by);
    }

    public void setTimeToLive(int n) throws IOException {
        if (n <= 0 || n > 255) {
            throw new IllegalArgumentException("Invalid ttl: " + n);
        }
        this.impl.setTimeToLive(n);
    }

    public void joinGroup(InetAddress inetAddress) throws IOException {
        if (!inetAddress.isMulticastAddress()) {
            throw new IOException("Not a Multicast address");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkMulticast(inetAddress);
        }
        this.impl.join(inetAddress);
    }

    public void leaveGroup(InetAddress inetAddress) throws IOException {
        if (!inetAddress.isMulticastAddress()) {
            throw new IOException("Not a Multicast address");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkMulticast(inetAddress);
        }
        this.impl.leave(inetAddress);
    }

    public synchronized void send(DatagramPacket datagramPacket, byte by) throws IOException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            InetAddress inetAddress = datagramPacket.getAddress();
            if (inetAddress.isMulticastAddress()) {
                securityManager.checkMulticast(inetAddress, by);
            } else {
                securityManager.checkConnect(inetAddress.getHostAddress(), datagramPacket.getPort());
            }
        }
        int n = this.impl.getTimeToLive();
        this.impl.setTimeToLive(by & 0xFF);
        this.impl.send(datagramPacket);
        this.impl.setTimeToLive(n);
    }
}

