/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;

public abstract class JarURLConnection
extends URLConnection {
    private final URL jarFileURL;
    protected URLConnection jarFileURLConnection;
    private final String element;
    static Hashtable conn_cache = new Hashtable();
    private Hashtable hdrHash;
    private Vector hdrVec;
    private boolean gotHeaders;

    private /* synthetic */ void finit$() {
        this.hdrHash = new Hashtable();
        this.hdrVec = new Vector();
        this.gotHeaders = false;
    }

    public URL getJarFileURL() {
        return this.jarFileURL;
    }

    public String getEntryName() {
        return this.element;
    }

    public JarURLConnection(URL uRL) throws MalformedURLException {
        super(uRL);
        this.finit$();
        String string = uRL.getFile();
        int n = string.indexOf("!/", 0);
        if (n == -1) {
            throw new MalformedURLException(uRL + ": No `!/' in spec.");
        }
        this.jarFileURL = new URL(string.substring(0, n));
        this.element = n + 2 == string.length() ? null : string.substring(n + 2);
    }

    public synchronized void connect() throws IOException {
        if (this.connected) {
            return;
        }
        if (this.getUseCaches()) {
            this.jarFileURLConnection = (URLConnection)conn_cache.get(this.jarFileURL);
            if (this.jarFileURLConnection == null) {
                this.jarFileURLConnection = this.jarFileURL.openConnection();
                this.jarFileURLConnection.setUseCaches(true);
                this.jarFileURLConnection.connect();
                conn_cache.put(this.jarFileURL, this.jarFileURLConnection);
            }
        } else {
            this.jarFileURLConnection = this.jarFileURL.openConnection();
            this.jarFileURLConnection.connect();
        }
        this.connected = true;
    }

    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (!this.doInput) {
            throw new ProtocolException("Can't open InputStream if doInput is false");
        }
        if (this.element == null) {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(this.jarFileURLConnection.getInputStream());
            return new JarInputStream(bufferedInputStream);
        }
        JarFile jarFile = null;
        try {
            jarFile = this.getJarFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (jarFile != null) {
            return jarFile.getInputStream(jarFile.getEntry(this.element));
        }
        JarInputStream jarInputStream = new JarInputStream(this.jarFileURLConnection.getInputStream());
        ZipEntry zipEntry = jarInputStream.getNextEntry();
        while (zipEntry != null) {
            if (this.element.equals(zipEntry.getName())) {
                int n = (int)zipEntry.getSize();
                byte[] byArray = new byte[n];
                jarInputStream.read(byArray, 0, n);
                return new ByteArrayInputStream(byArray);
            }
            zipEntry = jarInputStream.getNextEntry();
        }
        return null;
    }

    public JarEntry getJarEntry() throws IOException {
        JarFile jarFile = null;
        if (this.element == null) {
            return null;
        }
        if (!this.doInput) {
            throw new ProtocolException("Can't open JarEntry if doInput is false");
        }
        try {
            jarFile = this.getJarFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (jarFile == null) {
            JarInputStream jarInputStream = new JarInputStream(this.jarFileURLConnection.getInputStream());
            ZipEntry zipEntry = jarInputStream.getNextEntry();
            while (zipEntry != null) {
                if (this.element.equals(zipEntry.getName())) {
                    return new JarEntry(zipEntry);
                }
                zipEntry = jarInputStream.getNextEntry();
            }
        } else {
            return jarFile.getJarEntry(this.element);
        }
        return null;
    }

    public abstract JarFile getJarFile() throws IOException;

    public String getHeaderField(String string) {
        try {
            this.getHeaders();
        }
        catch (IOException iOException) {
            return null;
        }
        return (String)this.hdrHash.get(string.toLowerCase());
    }

    public String getHeaderField(int n) {
        try {
            this.getHeaders();
        }
        catch (IOException iOException) {
            return null;
        }
        if (n < this.hdrVec.size()) {
            return this.getField((String)this.hdrVec.elementAt(n));
        }
        return null;
    }

    public String getHeaderFieldKey(int n) {
        try {
            this.getHeaders();
        }
        catch (IOException iOException) {
            return null;
        }
        if (n < this.hdrVec.size()) {
            return this.getKey((String)this.hdrVec.elementAt(n));
        }
        return null;
    }

    private String getKey(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(58);
        if (n >= 0) {
            return string.substring(0, n);
        }
        return null;
    }

    private String getField(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(58);
        if (n >= 0) {
            return string.substring(n + 1).trim();
        }
        return string;
    }

    private void getHeaders() throws IOException {
        if (this.gotHeaders) {
            return;
        }
        this.gotHeaders = true;
        this.connect();
        long l = this.element == null ? (long)this.jarFileURLConnection.getContentLength() : this.getJarEntry().getSize();
        String string = "Content-length: " + l;
        this.hdrVec.addElement(string);
        String string2 = this.getKey(string);
        this.hdrHash.put(string2.toLowerCase(), Long.toString(l));
    }
}

