/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.UnknownHostException;

public final class InetAddress
implements Serializable {
    private int address;
    transient byte[] addr;
    String hostName;
    int family;
    private static final long serialVersionUID = 3286316764910316507L;
    private static final byte[] localhostAddress = new byte[]{127, 0, 0, 1};
    private static InetAddress localhost = null;

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.addr = new byte[4];
        this.addr[3] = (byte)this.address;
        for (int i = 2; i >= 0; --i) {
            this.addr[i] = (byte)(this.address >>= 8);
        }
        this.family = InetAddress.getFamily(this.addr);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n = this.addr.length;
        for (int i = n - 4; i < n; ++i) {
            this.address = this.address << 8 | this.addr[i] & 0xFF;
        }
        objectOutputStream.defaultWriteObject();
    }

    private static native int getFamily(byte[] var0);

    InetAddress(byte[] byArray, String string) {
        this.addr = byArray;
        this.hostName = string;
        if (byArray != null) {
            this.family = InetAddress.getFamily(byArray);
        }
    }

    public boolean isMulticastAddress() {
        int n = this.addr.length;
        if (n == 4) {
            return (this.addr[0] & 0xF0) == 224;
        }
        if (n == 16) {
            return this.addr[0] == -1;
        }
        return false;
    }

    public String getHostName() {
        if (this.hostName == null) {
            InetAddress.lookup(null, this, false);
        }
        return this.hostName;
    }

    public byte[] getAddress() {
        return (byte[])this.addr.clone();
    }

    private static InetAddress[] allocArray(int n) {
        return new InetAddress[n];
    }

    private static SecurityException checkConnect(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return null;
        }
        try {
            securityManager.checkConnect(string, -1);
            return null;
        }
        catch (SecurityException securityException) {
            return securityException;
        }
    }

    public String getHostAddress() {
        StringBuffer stringBuffer = new StringBuffer(40);
        int n = this.addr.length;
        int n2 = 0;
        if (n == 16) {
            while (true) {
                boolean bl;
                if (n2 >= 16) {
                    return stringBuffer.toString();
                }
                int n3 = (this.addr[n2] & 0xFF) << 8 | this.addr[n2 + 1] & 0xFF;
                boolean bl2 = bl = stringBuffer.length() == 0;
                if (bl) {
                    if (n2 == 10 && n3 == 65535) {
                        stringBuffer.append(":FFFF:");
                        break;
                    }
                    if (n2 == 12) {
                        stringBuffer.append(':');
                        break;
                    }
                    if (n2 > 0) {
                        stringBuffer.append("::");
                    }
                } else {
                    stringBuffer.append(':');
                }
                if (n3 != 0 || n2 >= 14) {
                    stringBuffer.append(Integer.toHexString(n3).toUpperCase());
                }
                n2 += 2;
            }
        }
        while (true) {
            stringBuffer.append(this.addr[n2] & 0xFF);
            if (++n2 == n) break;
            stringBuffer.append('.');
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        int n;
        int n2 = 0;
        int n3 = this.addr.length;
        int n4 = n = n3 > 4 ? n3 - 4 : 0;
        while (n < n3) {
            n2 = n2 << 8 | this.addr[n] & 0xFF;
            ++n;
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof InetAddress)) {
            return false;
        }
        byte[] byArray = this.addr;
        byte[] byArray2 = ((InetAddress)object).addr;
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = byArray.length;
        while (--n >= 0) {
            if (byArray[n] == byArray2[n]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.getHostName() + '/' + this.getHostAddress();
    }

    private static native byte[] aton(String var0);

    private static native InetAddress[] lookup(String var0, InetAddress var1, boolean var2);

    public static InetAddress getByName(String string) throws UnknownHostException {
        if (string == null) {
            return InetAddress.getLocalHost();
        }
        byte[] byArray = InetAddress.aton(string);
        if (byArray != null) {
            return new InetAddress(byArray, null);
        }
        InetAddress inetAddress = new InetAddress(null, string);
        InetAddress.lookup(string, inetAddress, false);
        return inetAddress;
    }

    public static InetAddress[] getAllByName(String string) throws UnknownHostException {
        byte[] byArray = InetAddress.aton(string);
        if (byArray != null) {
            InetAddress[] inetAddressArray = new InetAddress[]{new InetAddress(byArray, null)};
            return inetAddressArray;
        }
        return InetAddress.lookup(string, null, true);
    }

    private static native String getLocalHostname();

    public static InetAddress getLocalHost() throws UnknownHostException {
        SecurityManager securityManager = System.getSecurityManager();
        if (localhost == null || securityManager != null && InetAddress.localhost.addr != localhostAddress) {
            InetAddress.getLocalHost(securityManager);
        }
        return localhost;
    }

    private static synchronized void getLocalHost(SecurityManager securityManager) throws UnknownHostException {
        if (securityManager == null && localhost != null) {
            return;
        }
        String string = InetAddress.getLocalHostname();
        if (securityManager != null) {
            try {
                securityManager.checkConnect(string, -1);
            }
            catch (SecurityException securityException) {
                string = null;
            }
        }
        if (string != null) {
            try {
                localhost = new InetAddress(null, null);
                InetAddress.lookup(string, localhost, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (localhost == null) {
            localhost = new InetAddress(localhostAddress, "localhost");
        }
    }
}

