/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocketImpl;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.PlainDatagramSocketImpl;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.UnknownHostException;

public class DatagramSocket {
    DatagramSocketImpl impl;

    public DatagramSocket() throws SocketException {
        this(0, ServerSocket.ANY_IF);
    }

    public DatagramSocket(int n) throws SocketException {
        this(n, ServerSocket.ANY_IF);
    }

    public DatagramSocket(int n, InetAddress inetAddress) throws SocketException {
        String string;
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("Invalid port: " + n);
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkListen(n);
        }
        if ((string = System.getProperty("impl.prefix")) == null || string.equals("")) {
            this.impl = new PlainDatagramSocketImpl();
        } else {
            try {
                this.impl = (DatagramSocketImpl)Class.forName("java.net." + string + "DatagramSocketImpl").newInstance();
            }
            catch (Exception exception) {
                System.err.println("Could not instantiate class: java.net." + string + "DatagramSocketImpl");
                this.impl = new PlainDatagramSocketImpl();
            }
        }
        this.impl.create();
        if (this instanceof MulticastSocket) {
            this.impl.setOption(4, new Boolean(true));
        }
        this.impl.bind(n, inetAddress == null ? ServerSocket.ANY_IF : inetAddress);
    }

    public void close() {
        this.impl.close();
    }

    public InetAddress getLocalAddress() {
        SecurityManager securityManager = System.getSecurityManager();
        try {
            return (InetAddress)this.impl.getOption(15);
        }
        catch (SocketException socketException) {
            try {
                return InetAddress.getLocalHost();
            }
            catch (UnknownHostException unknownHostException) {
                return null;
            }
        }
    }

    public int getLocalPort() {
        return this.impl.getLocalPort();
    }

    public synchronized int getSoTimeout() throws SocketException {
        Object object = this.impl.getOption(4102);
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return 0;
    }

    public synchronized void receive(DatagramPacket datagramPacket) throws IOException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkAccept(datagramPacket.getAddress().getHostAddress(), datagramPacket.getPort());
        }
        this.impl.receive(datagramPacket);
    }

    public void send(DatagramPacket datagramPacket) throws IOException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            InetAddress inetAddress = datagramPacket.getAddress();
            if (inetAddress.isMulticastAddress()) {
                securityManager.checkMulticast(inetAddress);
            } else {
                securityManager.checkConnect(inetAddress.getHostAddress(), datagramPacket.getPort());
            }
        }
        this.impl.send(datagramPacket);
    }

    public synchronized void setSoTimeout(int n) throws SocketException {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid timeout: " + n);
        }
        this.impl.setOption(4102, new Integer(n));
    }
}

