/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.InetAddress;

public final class DatagramPacket {
    private byte[] buffer;
    private int offset;
    private int length;
    private InetAddress address;
    private int port;

    public DatagramPacket(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new NullPointerException("Null buffer");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Invalid offset: " + n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Invalid length: " + n2);
        }
        if (n + n2 > byArray.length) {
            throw new IllegalArgumentException("Potential buffer overflow - offset: " + n + " length: " + n2);
        }
        this.buffer = byArray;
        this.offset = n;
        this.length = n2;
        this.address = null;
        this.port = -1;
    }

    public DatagramPacket(byte[] byArray, int n) {
        this(byArray, 0, n);
    }

    public DatagramPacket(byte[] byArray, int n, int n2, InetAddress inetAddress, int n3) {
        if (byArray == null) {
            throw new NullPointerException("Null buffer");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Invalid offset: " + n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Invalid length: " + n2);
        }
        if (n + n2 > byArray.length) {
            throw new IllegalArgumentException("Potential buffer overflow - offset: " + n + " length: " + n2);
        }
        if (n3 < 0 || n3 > 65535) {
            throw new IllegalArgumentException("Invalid port: " + n3);
        }
        if (inetAddress == null) {
            throw new NullPointerException("Null address");
        }
        this.buffer = byArray;
        this.offset = n;
        this.length = n2;
        this.address = inetAddress;
        this.port = n3;
    }

    public DatagramPacket(byte[] byArray, int n, InetAddress inetAddress, int n2) {
        this(byArray, 0, n, inetAddress, n2);
    }

    public synchronized InetAddress getAddress() {
        return this.address;
    }

    public synchronized int getPort() {
        return this.port;
    }

    public synchronized byte[] getData() {
        return this.buffer;
    }

    public synchronized int getOffset() {
        return this.offset;
    }

    public synchronized int getLength() {
        return this.length;
    }

    public synchronized void setAddress(InetAddress inetAddress) {
        if (inetAddress == null) {
            throw new NullPointerException("Null address");
        }
        this.address = inetAddress;
    }

    public synchronized void setPort(int n) {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("Invalid port: " + n);
        }
        this.port = n;
    }

    public synchronized void setData(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("Null buffer");
        }
        this.buffer = byArray;
    }

    public synchronized void setData(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new NullPointerException("Null buffer");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Invalid offset: " + n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Invalid length: " + n2);
        }
        if (n + n2 > byArray.length) {
            throw new IllegalArgumentException("Potential buffer overflow - offset: " + n + " length: " + n2);
        }
        this.buffer = byArray;
        this.offset = n;
        this.length = n2;
    }

    public synchronized void setLength(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid length: " + n);
        }
        if (this.offset + n > this.buffer.length) {
            throw new IllegalArgumentException("Potential buffer overflow - offset: " + this.offset + " length: " + n);
        }
        this.length = n;
    }
}

