/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import gnu.gcj.math.MPN;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Random;

public class BigInteger
extends Number
implements Comparable {
    private transient int ival;
    private transient int[] words;
    private int bitCount;
    private int bitLength;
    private int firstNonzeroByteNum;
    private int lowestSetBit;
    private byte[] magnitude;
    private int signum;
    private static final long serialVersionUID = -8287574255936472291L;
    private static final int minFixNum = -100;
    private static final int maxFixNum = 1024;
    private static final int numFixNum = 1125;
    private static final BigInteger[] smallFixNums = new BigInteger[1125];
    public static final BigInteger ZERO;
    public static final BigInteger ONE;
    private static final int FLOOR = 1;
    private static final int CEILING = 2;
    private static final int TRUNCATE = 3;
    private static final int ROUND = 4;
    private static final int[] primes;
    private static final byte[] bit4_count;

    private /* synthetic */ void finit$() {
        this.bitCount = -1;
        this.bitLength = -1;
        this.firstNonzeroByteNum = -2;
        this.lowestSetBit = -2;
    }

    private BigInteger() {
        this.finit$();
    }

    private BigInteger(int n) {
        this.finit$();
        this.ival = n;
    }

    public BigInteger(String string, int n) {
        this.finit$();
        BigInteger bigInteger = BigInteger.valueOf(string, n);
        this.ival = bigInteger.ival;
        this.words = bigInteger.words;
    }

    public BigInteger(String string) {
        this(string, 10);
    }

    public BigInteger(byte[] byArray) {
        this.finit$();
        if (byArray == null || byArray.length < 1) {
            throw new NumberFormatException();
        }
        this.words = BigInteger.byteArrayToIntArray(byArray, byArray[0] < 0 ? -1 : 0);
        BigInteger bigInteger = BigInteger.make(this.words, this.words.length);
        this.ival = bigInteger.ival;
        this.words = bigInteger.words;
    }

    public BigInteger(int n, byte[] byArray) {
        this.finit$();
        if (byArray == null || n > 1 || n < -1) {
            throw new NumberFormatException();
        }
        if (n == 0) {
            int n2;
            for (n2 = byArray.length - 1; n2 >= 0 && byArray[n2] == 0; --n2) {
            }
            if (n2 >= 0) {
                throw new NumberFormatException();
            }
            return;
        }
        this.words = BigInteger.byteArrayToIntArray(byArray, 0);
        BigInteger bigInteger = BigInteger.make(this.words, this.words.length);
        this.ival = bigInteger.ival;
        this.words = bigInteger.words;
        if (n < 0) {
            this.setNegative();
        }
    }

    public BigInteger(int n, Random random) {
        this.finit$();
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        int n2 = n / 32 + 2;
        this.words = new int[n2];
        this.words[--n2] = 0;
        this.words[--n2] = random.nextInt() >>> (n % 32 & 0x1F);
        while (--n2 >= 0) {
            this.words[n2] = random.nextInt();
        }
        BigInteger bigInteger = BigInteger.make(this.words, this.words.length);
        this.ival = bigInteger.ival;
        this.words = bigInteger.words;
    }

    public BigInteger(int n, int n2, Random random) {
        this(n, random);
        while (!this.isProbablePrime(n2)) {
            BigInteger bigInteger = new BigInteger(n, random);
            this.ival = bigInteger.ival;
            this.words = bigInteger.words;
        }
        return;
    }

    private static BigInteger make(long l) {
        if (l >= (long)-100 && l <= (long)1024) {
            return smallFixNums[(int)l - -100];
        }
        int n = (int)l;
        if ((long)n == l) {
            return new BigInteger(n);
        }
        BigInteger bigInteger = BigInteger.alloc(2);
        bigInteger.ival = 2;
        bigInteger.words[0] = n;
        bigInteger.words[1] = (int)(l >> 32);
        return bigInteger;
    }

    public static BigInteger valueOf(long l) {
        return BigInteger.make(l);
    }

    private static BigInteger make(int[] nArray, int n) {
        if (nArray == null) {
            return BigInteger.make(n);
        }
        if ((n = BigInteger.wordsNeeded(nArray, n)) <= 1) {
            if (n == 0) {
                return ZERO;
            }
            return BigInteger.make(nArray[0]);
        }
        BigInteger bigInteger = new BigInteger();
        bigInteger.words = nArray;
        bigInteger.ival = n;
        return bigInteger;
    }

    private static int[] byteArrayToIntArray(byte[] byArray, int n) {
        int[] nArray = new int[(byArray.length + 3) / 4 + 1];
        int n2 = nArray.length;
        nArray[--n2] = n;
        int n3 = 0;
        int n4 = n;
        int n5 = byArray.length % 4;
        while (n5 > 0) {
            n4 = n4 << 8 | byArray[n3] & 0xFF;
            --n5;
            ++n3;
        }
        nArray[--n2] = n4;
        while (n2 > 0) {
            nArray[--n2] = byArray[n3++] << 24 | (byArray[n3++] & 0xFF) << 16 | (byArray[n3++] & 0xFF) << 8 | byArray[n3++] & 0xFF;
        }
        return nArray;
    }

    private static BigInteger alloc(int n) {
        if (n <= 1) {
            return new BigInteger();
        }
        BigInteger bigInteger = new BigInteger();
        bigInteger.words = new int[n];
        return bigInteger;
    }

    private void realloc(int n) {
        if (n == 0) {
            if (this.words != null) {
                if (this.ival > 0) {
                    this.ival = this.words[0];
                }
                this.words = null;
            }
        } else if (this.words == null || this.words.length < n || this.words.length > n + 2) {
            int[] nArray = new int[n];
            if (this.words == null) {
                nArray[0] = this.ival;
                this.ival = 1;
            } else {
                if (n < this.ival) {
                    this.ival = n;
                }
                System.arraycopy(this.words, 0, nArray, 0, this.ival);
            }
            this.words = nArray;
        }
    }

    private final boolean isNegative() {
        return (this.words == null ? this.ival : this.words[this.ival - 1]) < 0;
    }

    public int signum() {
        int n;
        int n2 = n = this.words == null ? this.ival : this.words[this.ival - 1];
        if (n == 0 && this.words == null) {
            return 0;
        }
        if (n < 0) {
            return -1;
        }
        return 1;
    }

    private static int compareTo(BigInteger bigInteger, BigInteger bigInteger2) {
        int n;
        boolean bl;
        if (bigInteger.words == null && bigInteger2.words == null) {
            if (bigInteger.ival < bigInteger2.ival) {
                return -1;
            }
            if (bigInteger.ival > bigInteger2.ival) {
                return 1;
            }
            return 0;
        }
        boolean bl2 = bigInteger.isNegative();
        if (bl2 != (bl = bigInteger2.isNegative())) {
            if (bl2) {
                return -1;
            }
            return 1;
        }
        int n2 = bigInteger.words == null ? 1 : bigInteger.ival;
        int n3 = n = bigInteger2.words == null ? 1 : bigInteger2.ival;
        if (n2 != n) {
            if (n2 > n != bl2) {
                return 1;
            }
            return -1;
        }
        return MPN.cmp(bigInteger.words, bigInteger2.words, n2);
    }

    public int compareTo(Object object) {
        if (object instanceof BigInteger) {
            return BigInteger.compareTo(this, (BigInteger)object);
        }
        throw new ClassCastException();
    }

    public int compareTo(BigInteger bigInteger) {
        return BigInteger.compareTo(this, bigInteger);
    }

    public BigInteger min(BigInteger bigInteger) {
        if (BigInteger.compareTo(this, bigInteger) < 0) {
            return this;
        }
        return bigInteger;
    }

    public BigInteger max(BigInteger bigInteger) {
        if (BigInteger.compareTo(this, bigInteger) > 0) {
            return this;
        }
        return bigInteger;
    }

    private final boolean isOdd() {
        int n = this.words == null ? this.ival : this.words[0];
        return (n & 1) != 0;
    }

    private final boolean isZero() {
        return this.words == null && this.ival == 0;
    }

    private final boolean isOne() {
        return this.words == null && this.ival == 1;
    }

    private final boolean isMinusOne() {
        return this.words == null && this.ival == -1;
    }

    private static int wordsNeeded(int[] nArray, int n) {
        int n2;
        block4: {
            int n3;
            n2 = n;
            if (n2 <= 0) break block4;
            if ((n3 = nArray[--n2]) == -1) {
                while (n2 > 0 && (n3 = nArray[n2 - 1]) < 0) {
                    --n2;
                    if (n3 == -1) continue;
                    break;
                }
            } else {
                while (n3 == 0 && n2 > 0 && (n3 = nArray[n2 - 1]) >= 0) {
                    --n2;
                }
            }
        }
        return n2 + 1;
    }

    private BigInteger canonicalize() {
        if (this.words != null && (this.ival = BigInteger.wordsNeeded(this.words, this.ival)) <= 1) {
            if (this.ival == 1) {
                this.ival = this.words[0];
            }
            this.words = null;
        }
        if (this.words == null && this.ival >= -100 && this.ival <= 1024) {
            return smallFixNums[this.ival - -100];
        }
        return this;
    }

    private static final BigInteger add(int n, int n2) {
        return BigInteger.make((long)n + (long)n2);
    }

    private static BigInteger add(BigInteger bigInteger, int n) {
        if (bigInteger.words == null) {
            return BigInteger.add(bigInteger.ival, n);
        }
        BigInteger bigInteger2 = new BigInteger(0);
        bigInteger2.setAdd(bigInteger, n);
        return bigInteger2.canonicalize();
    }

    private void setAdd(BigInteger bigInteger, int n) {
        if (bigInteger.words == null) {
            this.set((long)bigInteger.ival + (long)n);
            return;
        }
        int n2 = bigInteger.ival;
        this.realloc(n2 + 1);
        long l = n;
        for (int i = 0; i < n2; ++i) {
            this.words[i] = (int)(l += (long)bigInteger.words[i] & 0xFFFFFFFFL);
            l >>= 32;
        }
        if (bigInteger.words[n2 - 1] < 0) {
            l += (long)-1;
        }
        this.words[n2] = (int)l;
        this.ival = BigInteger.wordsNeeded(this.words, n2 + 1);
    }

    private final void setAdd(int n) {
        this.setAdd(this, n);
    }

    private final void set(long l) {
        int n = (int)l;
        if ((long)n == l) {
            this.ival = n;
            this.words = null;
        } else {
            this.realloc(2);
            this.words[0] = n;
            this.words[1] = (int)(l >> 32);
            this.ival = 2;
        }
    }

    private final void set(int[] nArray, int n) {
        this.ival = n;
        this.words = nArray;
    }

    private final void set(BigInteger bigInteger) {
        if (bigInteger.words == null) {
            this.set(bigInteger.ival);
        } else if (this != bigInteger) {
            this.realloc(bigInteger.ival);
            System.arraycopy(bigInteger.words, 0, this.words, 0, bigInteger.ival);
            this.ival = bigInteger.ival;
        }
    }

    private static BigInteger add(BigInteger bigInteger, BigInteger bigInteger2, int n) {
        long l;
        int n2;
        BigInteger bigInteger3;
        if (bigInteger.words == null && bigInteger2.words == null) {
            return BigInteger.make((long)n * (long)bigInteger2.ival + (long)bigInteger.ival);
        }
        if (n != 1) {
            bigInteger2 = n == -1 ? BigInteger.neg(bigInteger2) : BigInteger.times(bigInteger2, BigInteger.make(n));
        }
        if (bigInteger.words == null) {
            return BigInteger.add(bigInteger2, bigInteger.ival);
        }
        if (bigInteger2.words == null) {
            return BigInteger.add(bigInteger, bigInteger2.ival);
        }
        if (bigInteger2.ival > bigInteger.ival) {
            bigInteger3 = bigInteger;
            bigInteger = bigInteger2;
            bigInteger2 = bigInteger3;
        }
        bigInteger3 = BigInteger.alloc(bigInteger.ival + 1);
        long l2 = MPN.add_n(bigInteger3.words, bigInteger.words, bigInteger2.words, n2);
        long l3 = l = bigInteger2.words[n2 - 1] < 0 ? 0xFFFFFFFFL : 0L;
        for (n2 = bigInteger2.ival; n2 < bigInteger.ival; ++n2) {
            bigInteger3.words[n2] = (int)(l2 += ((long)bigInteger.words[n2] & 0xFFFFFFFFL) + l);
            l2 >>>= 32;
        }
        if (bigInteger.words[n2 - 1] < 0) {
            l += (long)-1;
        }
        bigInteger3.words[n2] = (int)l2 + (int)l;
        bigInteger3.ival = n2 + 1;
        return bigInteger3.canonicalize();
    }

    public BigInteger add(BigInteger bigInteger) {
        return BigInteger.add(this, bigInteger, 1);
    }

    public BigInteger subtract(BigInteger bigInteger) {
        return BigInteger.add(this, bigInteger, -1);
    }

    private static final BigInteger times(BigInteger bigInteger, int n) {
        boolean bl;
        if (n == 0) {
            return ZERO;
        }
        if (n == 1) {
            return bigInteger;
        }
        int[] nArray = bigInteger.words;
        int n2 = bigInteger.ival;
        if (nArray == null) {
            return BigInteger.make((long)n2 * (long)n);
        }
        BigInteger bigInteger2 = BigInteger.alloc(n2 + 1);
        if (nArray[n2 - 1] < 0) {
            bl = true;
            BigInteger.negate(bigInteger2.words, nArray, n2);
            nArray = bigInteger2.words;
        } else {
            bl = false;
        }
        if (n < 0) {
            bl ^= true;
            n = -n;
        }
        bigInteger2.words[n2] = MPN.mul_1(bigInteger2.words, nArray, n2, n);
        bigInteger2.ival = n2 + 1;
        if (bl) {
            bigInteger2.setNegative();
        }
        return bigInteger2.canonicalize();
    }

    private static final BigInteger times(BigInteger bigInteger, BigInteger bigInteger2) {
        Object object;
        int[] nArray;
        int[] nArray2;
        if (bigInteger2.words == null) {
            return BigInteger.times(bigInteger, bigInteger2.ival);
        }
        if (bigInteger.words == null) {
            return BigInteger.times(bigInteger2, bigInteger.ival);
        }
        boolean bl = false;
        int n = bigInteger.ival;
        int n2 = bigInteger2.ival;
        if (bigInteger.isNegative()) {
            bl = true;
            nArray2 = new int[n];
            BigInteger.negate(nArray2, bigInteger.words, n);
        } else {
            bl = false;
            nArray2 = bigInteger.words;
        }
        if (bigInteger2.isNegative()) {
            bl ^= true;
            nArray = new int[n2];
            BigInteger.negate(nArray, bigInteger2.words, n2);
        } else {
            nArray = bigInteger2.words;
        }
        if (n < n2) {
            object = nArray2;
            nArray2 = nArray;
            nArray = object;
            int n3 = n;
            n = n2;
            n2 = n3;
        }
        object = BigInteger.alloc(n + n2);
        MPN.mul(((BigInteger)object).words, nArray2, n, nArray, n2);
        ((BigInteger)object).ival = n + n2;
        if (bl) {
            super.setNegative();
        }
        return super.canonicalize();
    }

    public BigInteger multiply(BigInteger bigInteger) {
        return BigInteger.times(this, bigInteger);
    }

    private static void divide(long l, long l2, BigInteger bigInteger, BigInteger bigInteger2, int n) {
        boolean bl;
        boolean bl2;
        if (l < 0L) {
            bl2 = true;
            if (l == Long.MIN_VALUE) {
                BigInteger.divide(BigInteger.make(l), BigInteger.make(l2), bigInteger, bigInteger2, n);
                return;
            }
            l = -l;
        } else {
            bl2 = false;
        }
        if (l2 < 0L) {
            bl = true;
            if (l2 == Long.MIN_VALUE) {
                if (n == 3) {
                    if (bigInteger != null) {
                        bigInteger.set(0L);
                    }
                    if (bigInteger2 != null) {
                        bigInteger2.set(l);
                    }
                } else {
                    BigInteger.divide(BigInteger.make(l), BigInteger.make(l2), bigInteger, bigInteger2, n);
                }
                return;
            }
            l2 = -l2;
        } else {
            bl = false;
        }
        long l3 = l / l2;
        long l4 = l % l2;
        boolean bl3 = bl2 ^ bl;
        boolean bl4 = false;
        if (l4 != 0L) {
            switch (n) {
                case 3: {
                    break;
                }
                case 1: 
                case 2: {
                    if (bl3 != (n == 1)) break;
                    bl4 = true;
                    break;
                }
                case 4: {
                    boolean bl5 = bl4 = l4 > l2 - (l3 & 1L) >> 1;
                }
            }
        }
        if (bigInteger != null) {
            if (bl4) {
                ++l3;
            }
            if (bl3) {
                l3 = -l3;
            }
            bigInteger.set(l3);
        }
        if (bigInteger2 != null) {
            if (bl4) {
                l4 = l2 - l4;
                bl2 ^= true;
            }
            if (bl2) {
                l4 = -l4;
            }
            bigInteger2.set(l4);
        }
    }

    private static void divide(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        if (!(bigInteger.words != null && bigInteger.ival > 2 || bigInteger2.words != null && bigInteger2.ival > 2)) {
            long l = bigInteger.longValue();
            long l2 = bigInteger2.longValue();
            if (l != Long.MIN_VALUE && l2 != Long.MIN_VALUE) {
                BigInteger.divide(l, l2, bigInteger3, bigInteger4, n);
                return;
            }
        }
        boolean bl = bigInteger.isNegative();
        boolean bl2 = bigInteger2.isNegative();
        boolean bl3 = bl ^ bl2;
        int[] nArray = new int[n5];
        bigInteger2.getAbsolute(nArray);
        for (n5 = bigInteger2.words == null ? 1 : bigInteger2.ival; n5 > 1 && nArray[n5 - 1] == 0; --n5) {
        }
        int[] nArray2 = new int[n4 + 2];
        bigInteger.getAbsolute(nArray2);
        for (n4 = bigInteger.words == null ? 1 : bigInteger.ival; n4 > 1 && nArray2[n4 - 1] == 0; --n4) {
        }
        int n6 = MPN.cmp(nArray2, n4, nArray, n5);
        if (n6 < 0) {
            int[] nArray3 = nArray2;
            nArray2 = nArray;
            nArray = nArray3;
            n3 = n4;
            n2 = 1;
            nArray2[0] = 0;
        } else if (n6 == 0) {
            nArray2[0] = 1;
            n2 = 1;
            nArray[0] = 0;
            n3 = 1;
        } else if (n5 == 1) {
            n2 = n4;
            if (nArray[0] == 1 && nArray2[n4 - 1] < 0) {
                ++n2;
            }
            n3 = 1;
            nArray[0] = MPN.divmod_1(nArray2, nArray2, n4, nArray[0]);
        } else {
            int n7;
            int n8 = MPN.count_leading_zeros(nArray[n5 - 1]);
            if (n8 != 0) {
                MPN.lshift(nArray, 0, nArray, n5, n8);
                n7 = MPN.lshift(nArray2, 0, nArray2, n4, n8);
                nArray2[n4++] = n7;
            }
            if (n4 == n5) {
                nArray2[n4++] = 0;
            }
            MPN.divide(nArray2, n4, nArray, n5);
            n3 = n5;
            MPN.rshift0(nArray, nArray2, 0, n3, n8);
            n2 = n4 + 1 - n5;
            if (bigInteger3 != null) {
                for (n7 = 0; n7 < n2; ++n7) {
                    nArray2[n7] = nArray2[n7 + n5];
                }
            }
        }
        if (nArray[n3 - 1] < 0) {
            nArray[n3] = 0;
            ++n3;
        }
        boolean bl4 = false;
        if (n3 > 1 || nArray[0] != 0) {
            switch (n) {
                case 3: {
                    break;
                }
                case 1: 
                case 2: {
                    if (bl3 != (n == 1)) break;
                    bl4 = true;
                    break;
                }
                case 4: {
                    BigInteger bigInteger5 = bigInteger4 == null ? new BigInteger() : bigInteger4;
                    bigInteger5.set(nArray, n3);
                    bigInteger5 = BigInteger.shift(bigInteger5, 1);
                    if (bl2) {
                        bigInteger5.setNegative();
                    }
                    int n9 = BigInteger.compareTo(bigInteger5, bigInteger2);
                    if (bl2) {
                        n9 = -n9;
                    }
                    boolean bl5 = bl4 = n9 == 1 || n9 == 0 && (nArray2[0] & 1) != 0;
                }
            }
        }
        if (bigInteger3 != null) {
            bigInteger3.set(nArray2, n2);
            if (bl3) {
                if (bl4) {
                    bigInteger3.setInvert();
                } else {
                    bigInteger3.setNegative();
                }
            } else if (bl4) {
                bigInteger3.setAdd(1);
            }
        }
        if (bigInteger4 != null) {
            bigInteger4.set(nArray, n3);
            if (bl4) {
                BigInteger bigInteger6;
                if (bigInteger2.words == null) {
                    bigInteger6 = bigInteger4;
                    bigInteger6.set(bl2 ? nArray[0] + bigInteger2.ival : nArray[0] - bigInteger2.ival);
                } else {
                    bigInteger6 = BigInteger.add(bigInteger4, bigInteger2, bl2 ? 1 : -1);
                }
                if (bl) {
                    bigInteger4.setNegative(bigInteger6);
                } else {
                    bigInteger4.set(bigInteger6);
                }
            } else if (bl) {
                bigInteger4.setNegative();
            }
        }
    }

    public BigInteger divide(BigInteger bigInteger) {
        if (bigInteger.isZero()) {
            throw new ArithmeticException("divisor is zero");
        }
        BigInteger bigInteger2 = new BigInteger();
        BigInteger.divide(this, bigInteger, bigInteger2, null, 3);
        return bigInteger2.canonicalize();
    }

    public BigInteger remainder(BigInteger bigInteger) {
        if (bigInteger.isZero()) {
            throw new ArithmeticException("divisor is zero");
        }
        BigInteger bigInteger2 = new BigInteger();
        BigInteger.divide(this, bigInteger, null, bigInteger2, 3);
        return bigInteger2.canonicalize();
    }

    public BigInteger[] divideAndRemainder(BigInteger bigInteger) {
        if (bigInteger.isZero()) {
            throw new ArithmeticException("divisor is zero");
        }
        BigInteger[] bigIntegerArray = new BigInteger[]{new BigInteger(), new BigInteger()};
        BigInteger.divide(this, bigInteger, bigIntegerArray[0], bigIntegerArray[1], 3);
        bigIntegerArray[0].canonicalize();
        bigIntegerArray[1].canonicalize();
        return bigIntegerArray;
    }

    public BigInteger mod(BigInteger bigInteger) {
        if (bigInteger.isNegative() || bigInteger.isZero()) {
            throw new ArithmeticException("non-positive modulus");
        }
        BigInteger bigInteger2 = new BigInteger();
        BigInteger.divide(this, bigInteger, null, bigInteger2, 1);
        return bigInteger2.canonicalize();
    }

    private BigInteger pow(BigInteger bigInteger) {
        if (this.isOne()) {
            return this;
        }
        if (this.isMinusOne()) {
            if (bigInteger.isOdd()) {
                return this;
            }
            return ONE;
        }
        if (bigInteger.words == null && bigInteger.ival >= 0) {
            return this.pow(bigInteger.ival);
        }
        if (this.isZero()) {
            return this;
        }
        BigInteger bigInteger2 = this;
        BigInteger bigInteger3 = null;
        while (true) {
            if (bigInteger.isOdd()) {
                BigInteger bigInteger4 = bigInteger3 = bigInteger3 == null ? bigInteger2 : BigInteger.times(bigInteger3, bigInteger2);
            }
            if ((bigInteger = BigInteger.shift(bigInteger, -1)).isZero()) break;
            bigInteger2 = BigInteger.times(bigInteger2, bigInteger2);
        }
        if (bigInteger3 == null) {
            return ONE;
        }
        return bigInteger3;
    }

    public BigInteger pow(int n) {
        if (n <= 0) {
            if (n == 0) {
                return ONE;
            }
            throw new ArithmeticException("negative exponent");
        }
        if (this.isZero()) {
            return this;
        }
        int n2 = this.words == null ? 1 : this.ival;
        int n3 = (this.bitLength() * n >> 5) + 2 * n2;
        boolean bl = this.isNegative() && (n & 1) != 0;
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        int[] nArray3 = new int[n3];
        this.getAbsolute(nArray);
        int n4 = 1;
        nArray2[0] = 1;
        block0: while (true) {
            int[] nArray4;
            if ((n & 1) != 0) {
                MPN.mul(nArray3, nArray, n2, nArray2, n4);
                nArray4 = nArray3;
                nArray3 = nArray2;
                nArray2 = nArray4;
                n4 += n2;
                while (nArray2[n4 - 1] == 0) {
                    --n4;
                }
            }
            if ((n >>= 1) == 0) break;
            MPN.mul(nArray3, nArray, n2, nArray, n2);
            nArray4 = nArray3;
            nArray3 = nArray;
            nArray = nArray4;
            n2 *= 2;
            while (true) {
                if (nArray[n2 - 1] != 0) continue block0;
                --n2;
            }
            break;
        }
        if (nArray2[n4 - 1] < 0) {
            ++n4;
        }
        if (bl) {
            BigInteger.negate(nArray2, nArray2, n4);
        }
        return BigInteger.make(nArray2, n4);
    }

    private static final int[] euclidInv(int n, int n2, int n3) {
        if (n2 == 0) {
            throw new ArithmeticException("not invertible");
        }
        if (n2 == 1) {
            int[] nArray = new int[3];
            nArray[0] = -n3;
            nArray[1] = 1;
            return nArray;
        }
        int[] nArray = BigInteger.euclidInv(n2, n % n2, n / n2);
        nArray[2] = nArray[0];
        nArray[0] = nArray[2] * -n3 + nArray[1];
        nArray[1] = nArray[2];
        return nArray;
    }

    private static final BigInteger[] euclidInv(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        BigInteger[] bigIntegerArray;
        if (bigInteger2.isZero()) {
            throw new ArithmeticException("not invertible");
        }
        if (bigInteger2.isOne()) {
            BigInteger[] bigIntegerArray2 = new BigInteger[3];
            bigIntegerArray2[0] = BigInteger.neg(bigInteger3);
            bigIntegerArray2[1] = ONE;
            return bigIntegerArray2;
        }
        if (bigInteger.words == null) {
            int[] nArray = BigInteger.euclidInv(bigInteger2.ival, bigInteger.ival % bigInteger2.ival, bigInteger.ival / bigInteger2.ival);
            bigIntegerArray = new BigInteger[3];
            bigIntegerArray[0] = new BigInteger(nArray[0]);
            bigIntegerArray[1] = new BigInteger(nArray[1]);
        } else {
            BigInteger bigInteger4 = new BigInteger();
            BigInteger bigInteger5 = new BigInteger();
            BigInteger.divide(bigInteger, bigInteger2, bigInteger5, bigInteger4, 1);
            bigIntegerArray = BigInteger.euclidInv(bigInteger2, bigInteger4, bigInteger5);
        }
        bigIntegerArray[2] = bigIntegerArray[0];
        bigIntegerArray[0] = BigInteger.add(bigIntegerArray[1], BigInteger.times(bigIntegerArray[2], bigInteger3), -1);
        bigIntegerArray[1] = bigIntegerArray[2];
        return bigIntegerArray;
    }

    public BigInteger modInverse(BigInteger bigInteger) {
        if (bigInteger.isNegative() || bigInteger.isZero()) {
            throw new ArithmeticException("non-positive modulo");
        }
        if (bigInteger.isOne()) {
            return ZERO;
        }
        if (this.isOne()) {
            return ONE;
        }
        BigInteger bigInteger2 = new BigInteger();
        int n = this.ival;
        int n2 = bigInteger.ival;
        boolean bl = false;
        if (bigInteger.words == null) {
            if (this.words != null || this.isNegative()) {
                n = this.mod((BigInteger)bigInteger).ival;
            }
            if (n2 > n) {
                int n3 = n;
                n = n2;
                n2 = n3;
                bl = true;
            }
            bigInteger2.ival = BigInteger.euclidInv(n2, n % n2, n / n2)[bl ? 0 : 1];
            if (bigInteger2.ival < 0) {
                bigInteger2.ival += bigInteger.ival;
            }
        } else {
            BigInteger bigInteger3;
            BigInteger bigInteger4 = this;
            if (this.isNegative()) {
                bigInteger4 = this.mod(bigInteger);
            }
            if (bigInteger4.compareTo(bigInteger) < 0) {
                bigInteger3 = bigInteger4;
                bigInteger4 = bigInteger;
                bigInteger = bigInteger3;
                bl = true;
            }
            bigInteger3 = new BigInteger();
            BigInteger bigInteger5 = new BigInteger();
            BigInteger.divide(bigInteger4, bigInteger, bigInteger5, bigInteger3, 1);
            bigInteger2 = BigInteger.euclidInv(bigInteger, bigInteger3, bigInteger5)[bl ? 0 : 1];
            if (bigInteger2.isNegative()) {
                bigInteger2 = BigInteger.add(bigInteger2, bl ? bigInteger4 : bigInteger, 1);
            }
        }
        return bigInteger2;
    }

    public BigInteger modPow(BigInteger bigInteger, BigInteger bigInteger2) {
        if (bigInteger2.isNegative() || bigInteger2.isZero()) {
            throw new ArithmeticException("non-positive modulo");
        }
        if (bigInteger.isNegative()) {
            return this.modInverse(bigInteger2);
        }
        if (bigInteger.isOne()) {
            return this.mod(bigInteger2);
        }
        BigInteger bigInteger3 = ONE;
        BigInteger bigInteger4 = this;
        BigInteger bigInteger5 = bigInteger;
        while (!bigInteger5.isZero()) {
            if (bigInteger5.and(ONE).isOne()) {
                bigInteger3 = BigInteger.times(bigInteger3, bigInteger4).mod(bigInteger2);
            }
            bigInteger5 = bigInteger5.shiftRight(1);
            bigInteger4 = BigInteger.times(bigInteger4, bigInteger4).mod(bigInteger2);
        }
        return bigInteger3;
    }

    private static final int gcd(int n, int n2) {
        int n3;
        if (n2 > n) {
            n3 = n;
            n = n2;
            n2 = n3;
        }
        while (n2 != 0) {
            if (n2 == 1) {
                return n2;
            }
            n3 = n2;
            n2 = n % n2;
            n = n3;
        }
        return n;
    }

    public BigInteger gcd(BigInteger bigInteger) {
        int n = this.ival;
        int n2 = bigInteger.ival;
        if (this.words == null) {
            if (n == 0) {
                return BigInteger.abs(bigInteger);
            }
            if (bigInteger.words == null && n != Integer.MIN_VALUE && n2 != Integer.MIN_VALUE) {
                if (n < 0) {
                    n = -n;
                }
                if (n2 < 0) {
                    n2 = -n2;
                }
                return BigInteger.make(BigInteger.gcd(n, n2));
            }
            n = 1;
        }
        if (bigInteger.words == null) {
            if (n2 == 0) {
                return BigInteger.abs(this);
            }
            n2 = 1;
        }
        int n3 = (n > n2 ? n : n2) + 1;
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        this.getAbsolute(nArray);
        bigInteger.getAbsolute(nArray2);
        n3 = MPN.gcd(nArray, nArray2, n3);
        BigInteger bigInteger2 = new BigInteger(0);
        bigInteger2.ival = n3;
        bigInteger2.words = nArray;
        return bigInteger2.canonicalize();
    }

    public boolean isProbablePrime(int n) {
        for (int i = 0; i < primes.length; ++i) {
            if (this.words == null && this.ival == primes[i]) {
                return true;
            }
            if (!this.remainder(BigInteger.make(primes[i])).isZero()) continue;
            return false;
        }
        BigInteger bigInteger = BigInteger.add(this, -1);
        int n2 = bigInteger.getLowestSetBit();
        BigInteger bigInteger2 = bigInteger.divide(BigInteger.make((long)2 << (n2 - 1 & 0x3F)));
        Random random = new Random();
        while (n-- > 0) {
            int n3 = random.nextInt();
            n3 = (n3 < 0 ? -n3 % 1023 : n3 % 1023) + 2;
            BigInteger bigInteger3 = BigInteger.make(n3).modPow(bigInteger2, this);
            if (bigInteger3.isOne() || bigInteger3.equals(bigInteger)) continue;
            int n4 = 0;
            while (n4 < n2) {
                if (bigInteger3.isOne()) {
                    return false;
                }
                ++n4;
                if (bigInteger3.equals(bigInteger)) break;
                bigInteger3 = bigInteger3.modPow(BigInteger.make(2), this);
            }
            if (n4 != n2 || bigInteger3.equals(bigInteger)) continue;
            return false;
        }
        return true;
    }

    private void setInvert() {
        if (this.words == null) {
            this.ival ^= 0xFFFFFFFF;
        } else {
            int n = this.ival;
            while (--n >= 0) {
                this.words[n] = ~this.words[n];
            }
        }
    }

    private void setShiftLeft(BigInteger bigInteger, int n) {
        int n2;
        int n3;
        int[] nArray;
        if (bigInteger.words == null) {
            if (n < 32) {
                this.set((long)bigInteger.ival << (n & 0x3F));
                return;
            }
            nArray = new int[]{bigInteger.ival};
            n3 = 1;
        } else {
            nArray = bigInteger.words;
            n3 = bigInteger.ival;
        }
        int n4 = n >> 5;
        int n5 = n3 + n4;
        if ((n &= 0x1F) == 0) {
            this.realloc(n5);
            n2 = n3;
            while (--n2 >= 0) {
                this.words[n2 + n4] = nArray[n2];
            }
        } else {
            this.realloc(++n5);
            n2 = MPN.lshift(this.words, n4, nArray, n3, n);
            n = 32 - n;
            this.words[n5 - 1] = n2 << (n & 0x1F) >> (n & 0x1F);
        }
        this.ival = n5;
        n2 = n4;
        while (--n2 >= 0) {
            this.words[n2] = 0;
        }
    }

    private void setShiftRight(BigInteger bigInteger, int n) {
        if (bigInteger.words == null) {
            this.set(n < 32 ? (long)(bigInteger.ival >> (n & 0x1F)) : (bigInteger.ival < 0 ? (long)-1 : 0L));
        } else if (n == 0) {
            this.set(bigInteger);
        } else {
            boolean bl = bigInteger.isNegative();
            int n2 = n >> 5;
            n &= 0x1F;
            int n3 = bigInteger.ival - n2;
            if (n3 <= 0) {
                this.set(bl ? (long)-1 : 0L);
            } else {
                if (this.words == null || this.words.length < n3) {
                    this.realloc(n3);
                }
                MPN.rshift0(this.words, bigInteger.words, n2, n3, n);
                this.ival = n3;
                if (bl) {
                    this.words[n3 - 1] = this.words[n3 - 1] | -1 << (32 - n & 0x1F);
                }
            }
        }
    }

    private void setShift(BigInteger bigInteger, int n) {
        if (n > 0) {
            this.setShiftLeft(bigInteger, n);
        } else {
            this.setShiftRight(bigInteger, -n);
        }
    }

    private static BigInteger shift(BigInteger bigInteger, int n) {
        if (bigInteger.words == null) {
            if (n <= 0) {
                return BigInteger.make(n > -32 ? (long)(bigInteger.ival >> (-n & 0x1F)) : (bigInteger.ival < 0 ? (long)-1 : 0L));
            }
            if (n < 32) {
                return BigInteger.make((long)bigInteger.ival << (n & 0x3F));
            }
        }
        if (n == 0) {
            return bigInteger;
        }
        BigInteger bigInteger2 = new BigInteger(0);
        bigInteger2.setShift(bigInteger, n);
        return bigInteger2.canonicalize();
    }

    public BigInteger shiftLeft(int n) {
        return BigInteger.shift(this, n);
    }

    public BigInteger shiftRight(int n) {
        return BigInteger.shift(this, -n);
    }

    private void format(int n, StringBuffer stringBuffer) {
        if (this.words == null) {
            stringBuffer.append(Integer.toString(this.ival, n));
        } else if (this.ival <= 2) {
            stringBuffer.append(Long.toString(this.longValue(), n));
        } else {
            int[] nArray;
            boolean bl = this.isNegative();
            if (bl || n != 16) {
                nArray = new int[this.ival];
                this.getAbsolute(nArray);
            } else {
                nArray = this.words;
            }
            int n2 = this.ival;
            int n3 = n2 * (MPN.chars_per_word(n) + 1);
            if (n == 16) {
                if (bl) {
                    stringBuffer.append('-');
                }
                int n4 = stringBuffer.length();
                int n5 = n2;
                while (--n5 >= 0) {
                    int n6 = nArray[n5];
                    int n7 = 8;
                    while (--n7 >= 0) {
                        int n8 = n6 >> (4 * n7 & 0x1F) & 0xF;
                        if (n8 <= 0 && stringBuffer.length() <= n4) continue;
                        stringBuffer.append(Character.forDigit(n8, 16));
                    }
                }
            } else {
                int n9;
                int n10 = stringBuffer.length();
                do {
                    n9 = MPN.divmod_1(nArray, nArray, n2, n);
                    stringBuffer.append(Character.forDigit(n9, n));
                    while (n2 > 0 && nArray[n2 - 1] == 0) {
                        --n2;
                    }
                } while (n2 != 0);
                if (bl) {
                    stringBuffer.append('-');
                }
                for (n9 = stringBuffer.length() - 1; n10 < n9; ++n10, --n9) {
                    char c = stringBuffer.charAt(n10);
                    stringBuffer.setCharAt(n10, stringBuffer.charAt(n9));
                    stringBuffer.setCharAt(n9, c);
                }
            }
        }
    }

    public String toString() {
        return this.toString(10);
    }

    public String toString(int n) {
        if (this.words == null) {
            return Integer.toString(this.ival, n);
        }
        if (this.ival <= 2) {
            return Long.toString(this.longValue(), n);
        }
        int n2 = this.ival * (MPN.chars_per_word(n) + 1);
        StringBuffer stringBuffer = new StringBuffer(n2);
        this.format(n, stringBuffer);
        return stringBuffer.toString();
    }

    public int intValue() {
        if (this.words == null) {
            return this.ival;
        }
        return this.words[0];
    }

    public long longValue() {
        if (this.words == null) {
            return this.ival;
        }
        if (this.ival == 1) {
            return this.words[0];
        }
        return ((long)this.words[1] << 32) + ((long)this.words[0] & 0xFFFFFFFFL);
    }

    public int hashCode() {
        if (this.words == null) {
            return this.ival;
        }
        return this.words[0] + this.words[this.ival - 1];
    }

    private static boolean equals(BigInteger bigInteger, BigInteger bigInteger2) {
        if (bigInteger.words == null && bigInteger2.words == null) {
            return bigInteger.ival == bigInteger2.ival;
        }
        if (bigInteger.words == null || bigInteger2.words == null || bigInteger.ival != bigInteger2.ival) {
            return false;
        }
        int n = bigInteger.ival;
        while (--n >= 0) {
            if (bigInteger.words[n] == bigInteger2.words[n]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof BigInteger)) {
            return false;
        }
        return BigInteger.equals(this, (BigInteger)object);
    }

    private static BigInteger valueOf(String string, int n) {
        int n2 = string.length();
        if (n2 <= 15 && n <= 16) {
            return BigInteger.make(Long.parseLong(string, n));
        }
        int n3 = 0;
        byte[] byArray = new byte[n2];
        boolean bl = false;
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (c == '-') {
                bl = true;
                continue;
            }
            if (c == '_' || n3 == 0 && (c == ' ' || c == '\t')) continue;
            int n4 = Character.digit(c, n);
            if (n4 < 0) break;
            byArray[n3++] = (byte)n4;
        }
        return BigInteger.valueOf(byArray, n3, bl, n);
    }

    private static BigInteger valueOf(byte[] byArray, int n, boolean bl, int n2) {
        int n3 = MPN.chars_per_word(n2);
        int[] nArray = new int[n / n3 + 1];
        int n4 = MPN.set_str(nArray, byArray, n, n2);
        if (n4 == 0) {
            return ZERO;
        }
        if (nArray[n4 - 1] < 0) {
            nArray[n4++] = 0;
        }
        if (bl) {
            BigInteger.negate(nArray, nArray, n4);
        }
        return BigInteger.make(nArray, n4);
    }

    public double doubleValue() {
        if (this.words == null) {
            return this.ival;
        }
        if (this.ival <= 2) {
            return this.longValue();
        }
        if (this.isNegative()) {
            return BigInteger.neg(this).roundToDouble(0, true, false);
        }
        return this.roundToDouble(0, false, false);
    }

    public float floatValue() {
        return (float)this.doubleValue();
    }

    private boolean checkBits(int n) {
        int n2;
        if (n <= 0) {
            return false;
        }
        if (this.words == null) {
            return n > 31 || (this.ival & (1 << (n & 0x1F)) - 1) != 0;
        }
        for (n2 = 0; n2 < n >> 5; ++n2) {
            if (this.words[n2] == 0) continue;
            return true;
        }
        return (n & 0x1F) != 0 && (this.words[n2] & (1 << (n & 0x1F)) - 1) != 0;
    }

    private double roundToDouble(int n, boolean bl, boolean bl2) {
        int n2 = this.bitLength();
        if ((n += n2 - 1) < -1075) {
            if (bl) {
                return 0.0;
            }
            return 0.0;
        }
        if (n > 1023) {
            if (bl) {
                return Double.NEGATIVE_INFINITY;
            }
            return Double.POSITIVE_INFINITY;
        }
        int n3 = n >= -1022 ? 53 : 53 + n + 1022;
        int n4 = n2 - (n3 + 1);
        long l = n4 > 0 ? (this.words == null ? (long)(this.ival >> (n4 & 0x1F)) : MPN.rshift_long(this.words, this.ival, n4)) : this.longValue() << (-n4 & 0x3F);
        if (n == 1023 && l >> 1 == 0x1FFFFFFFFFFFFFL) {
            if (bl2 || this.checkBits(n2 - n3)) {
                if (bl) {
                    return Double.NEGATIVE_INFINITY;
                }
                return Double.POSITIVE_INFINITY;
            }
            if (bl) {
                return -1.7976931348623157E308;
            }
            return Double.MAX_VALUE;
        }
        if ((l & 1L) == 1L && ((l & (long)2) == (long)2 || bl2 || this.checkBits(n4))) {
            if (((l += (long)2) & 0x40000000000000L) != 0L) {
                ++n;
                l >>= 1;
            } else if (n3 == 52 && (l & 0x20000000000000L) != 0L) {
                ++n;
            }
        }
        long l2 = bl ? Long.MIN_VALUE : 0L;
        long l3 = (n += 1023) <= 0 ? 0L : (long)n << 52;
        long l4 = (l >>= 1) & 0xFFEFFFFFFFFFFFFFL;
        return Double.longBitsToDouble(l2 | l3 | l4);
    }

    private void getAbsolute(int[] nArray) {
        int n;
        int n2;
        if (this.words == null) {
            n2 = 1;
            nArray[0] = this.ival;
        } else {
            n = n2 = this.ival;
            while (--n >= 0) {
                nArray[n] = this.words[n];
            }
        }
        if (nArray[n2 - 1] < 0) {
            BigInteger.negate(nArray, nArray, n2);
        }
        n = nArray.length;
        while (--n > n2) {
            nArray[n] = 0;
        }
    }

    private static boolean negate(int[] nArray, int[] nArray2, int n) {
        long l = 1L;
        boolean bl = nArray2[n - 1] < 0;
        for (int i = 0; i < n; ++i) {
            nArray[i] = (int)(l += (long)(~nArray2[i]) & 0xFFFFFFFFL);
            l >>= 32;
        }
        return bl && nArray[n - 1] < 0;
    }

    private void setNegative(BigInteger bigInteger) {
        int n = bigInteger.ival;
        if (bigInteger.words == null) {
            if (n == Integer.MIN_VALUE) {
                this.set(-((long)n));
            } else {
                this.set(-n);
            }
            return;
        }
        this.realloc(n + 1);
        if (BigInteger.negate(this.words, bigInteger.words, n)) {
            this.words[n++] = 0;
        }
        this.ival = n;
    }

    private final void setNegative() {
        this.setNegative(this);
    }

    private static BigInteger abs(BigInteger bigInteger) {
        if (bigInteger.isNegative()) {
            return BigInteger.neg(bigInteger);
        }
        return bigInteger;
    }

    public BigInteger abs() {
        return BigInteger.abs(this);
    }

    private static BigInteger neg(BigInteger bigInteger) {
        if (bigInteger.words == null && bigInteger.ival != Integer.MIN_VALUE) {
            return BigInteger.make(-bigInteger.ival);
        }
        BigInteger bigInteger2 = new BigInteger(0);
        bigInteger2.setNegative(bigInteger);
        return bigInteger2.canonicalize();
    }

    public BigInteger negate() {
        return BigInteger.neg(this);
    }

    public int bitLength() {
        if (this.words == null) {
            return MPN.intLength(this.ival);
        }
        return MPN.intLength(this.words, this.ival);
    }

    public byte[] toByteArray() {
        int n;
        byte[] byArray = new byte[(this.bitLength() + 1 + 7) / 8];
        int n2 = byArray.length;
        int n3 = 0;
        while (n2 > 4) {
            n = this.words[n3++];
            int n4 = 4;
            while (n4 > 0) {
                byArray[--n2] = (byte)n;
                --n4;
                n >>= 8;
            }
        }
        int n5 = n = this.words == null ? this.ival : this.words[n3];
        while (n2 > 0) {
            byArray[--n2] = (byte)n;
            n >>= 8;
        }
        return byArray;
    }

    private static int swappedOp(int n) {
        return "\u0000\u0001\u0004\u0005\u0002\u0003\u0006\u0007\b\t\f\r\n\u000b\u000e\u000f".charAt(n);
    }

    private static BigInteger bitOp(int n, BigInteger bigInteger, BigInteger bigInteger2) {
        switch (n) {
            case 0: {
                return ZERO;
            }
            case 1: {
                return bigInteger.and(bigInteger2);
            }
            case 3: {
                return bigInteger;
            }
            case 5: {
                return bigInteger2;
            }
            case 15: {
                return BigInteger.make(-1);
            }
        }
        BigInteger bigInteger3 = new BigInteger();
        BigInteger.setBitOp(bigInteger3, n, bigInteger, bigInteger2);
        return bigInteger3.canonicalize();
    }

    private static void setBitOp(BigInteger bigInteger, int n, BigInteger bigInteger2, BigInteger bigInteger3) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        if (bigInteger3.words != null && (bigInteger2.words == null || bigInteger2.ival < bigInteger3.ival)) {
            BigInteger bigInteger4 = bigInteger2;
            bigInteger2 = bigInteger3;
            bigInteger3 = bigInteger4;
            n = BigInteger.swappedOp(n);
        }
        if (bigInteger3.words == null) {
            n6 = bigInteger3.ival;
            n5 = 1;
        } else {
            n6 = bigInteger3.words[0];
            n5 = bigInteger3.ival;
        }
        if (bigInteger2.words == null) {
            n4 = bigInteger2.ival;
            n3 = 1;
        } else {
            n4 = bigInteger2.words[0];
            n3 = bigInteger2.ival;
        }
        if (n3 > 1) {
            bigInteger.realloc(n3);
        }
        int[] nArray = bigInteger.words;
        int n7 = 0;
        int n8 = 0;
        block0 : switch (n) {
            case 0: {
                n2 = 0;
                break;
            }
            case 1: {
                while (true) {
                    n2 = n4 & n6;
                    if (n7 + 1 >= n5) break;
                    nArray[n7++] = n2;
                    n4 = bigInteger2.words[n7];
                    n6 = bigInteger3.words[n7];
                }
                if (n6 >= 0) break;
                n8 = 1;
                break;
            }
            case 2: {
                while (true) {
                    n2 = n4 & ~n6;
                    if (n7 + 1 >= n5) break;
                    nArray[n7++] = n2;
                    n4 = bigInteger2.words[n7];
                    n6 = bigInteger3.words[n7];
                }
                if (n6 < 0) break;
                n8 = 1;
                break;
            }
            case 3: {
                n2 = n4;
                n8 = 1;
                break;
            }
            case 4: {
                while (true) {
                    n2 = ~n4 & n6;
                    if (n7 + 1 >= n5) break;
                    nArray[n7++] = n2;
                    n4 = bigInteger2.words[n7];
                    n6 = bigInteger3.words[n7];
                }
                if (n6 >= 0) break;
                n8 = 2;
                break;
            }
            case 5: {
                while (true) {
                    n2 = n6;
                    if (n7 + 1 >= n5) break block0;
                    nArray[n7++] = n2;
                    n4 = bigInteger2.words[n7];
                    n6 = bigInteger3.words[n7];
                }
            }
            case 6: {
                while (true) {
                    n2 = n4 ^ n6;
                    if (n7 + 1 >= n5) break;
                    nArray[n7++] = n2;
                    n4 = bigInteger2.words[n7];
                    n6 = bigInteger3.words[n7];
                }
                n8 = n6 < 0 ? 2 : 1;
                break;
            }
            case 7: {
                while (true) {
                    n2 = n4 | n6;
                    if (n7 + 1 >= n5) break;
                    nArray[n7++] = n2;
                    n4 = bigInteger2.words[n7];
                    n6 = bigInteger3.words[n7];
                }
                if (n6 < 0) break;
                n8 = 1;
                break;
            }
            case 8: {
                while (true) {
                    n2 = ~(n4 | n6);
                    if (n7 + 1 >= n5) break;
                    nArray[n7++] = n2;
                    n4 = bigInteger2.words[n7];
                    n6 = bigInteger3.words[n7];
                }
                if (n6 < 0) break;
                n8 = 2;
                break;
            }
            case 9: {
                while (true) {
                    n2 = ~(n4 ^ n6);
                    if (n7 + 1 >= n5) break;
                    nArray[n7++] = n2;
                    n4 = bigInteger2.words[n7];
                    n6 = bigInteger3.words[n7];
                }
                n8 = n6 >= 0 ? 2 : 1;
                break;
            }
            case 10: {
                while (true) {
                    n2 = ~n6;
                    if (n7 + 1 >= n5) break block0;
                    nArray[n7++] = n2;
                    n4 = bigInteger2.words[n7];
                    n6 = bigInteger3.words[n7];
                }
            }
            case 11: {
                while (true) {
                    n2 = n4 | ~n6;
                    if (n7 + 1 >= n5) break;
                    nArray[n7++] = n2;
                    n4 = bigInteger2.words[n7];
                    n6 = bigInteger3.words[n7];
                }
                if (n6 >= 0) break;
                n8 = 1;
                break;
            }
            case 12: {
                n2 = ~n4;
                n8 = 2;
                break;
            }
            case 13: {
                while (true) {
                    n2 = ~n4 | n6;
                    if (n7 + 1 >= n5) break;
                    nArray[n7++] = n2;
                    n4 = bigInteger2.words[n7];
                    n6 = bigInteger3.words[n7];
                }
                if (n6 < 0) break;
                n8 = 2;
                break;
            }
            case 14: {
                while (true) {
                    n2 = ~(n4 & n6);
                    if (n7 + 1 >= n5) break;
                    nArray[n7++] = n2;
                    n4 = bigInteger2.words[n7];
                    n6 = bigInteger3.words[n7];
                }
                if (n6 >= 0) break;
                n8 = 2;
                break;
            }
            default: {
                n2 = -1;
            }
        }
        if (n7 + 1 == n3) {
            n8 = 0;
        }
        switch (n8) {
            case 0: {
                if (n7 == 0 && nArray == null) {
                    bigInteger.ival = n2;
                    return;
                }
                nArray[n7++] = n2;
                break;
            }
            case 1: {
                nArray[n7] = n2;
                while (++n7 < n3) {
                    nArray[n7] = bigInteger2.words[n7];
                }
                break;
            }
            case 2: {
                nArray[n7] = n2;
                while (++n7 < n3) {
                    nArray[n7] = ~bigInteger2.words[n7];
                }
                break;
            }
        }
        bigInteger.ival = n7;
    }

    private static BigInteger and(BigInteger bigInteger, int n) {
        if (bigInteger.words == null) {
            return BigInteger.make(bigInteger.ival & n);
        }
        if (n >= 0) {
            return BigInteger.make(bigInteger.words[0] & n);
        }
        int n2 = bigInteger.ival;
        int[] nArray = new int[n2];
        nArray[0] = bigInteger.words[0] & n;
        while (--n2 > 0) {
            nArray[n2] = bigInteger.words[n2];
        }
        return BigInteger.make(nArray, bigInteger.ival);
    }

    public BigInteger and(BigInteger bigInteger) {
        int n;
        if (bigInteger.words == null) {
            return BigInteger.and(this, bigInteger.ival);
        }
        if (this.words == null) {
            return BigInteger.and(bigInteger, this.ival);
        }
        BigInteger bigInteger2 = this;
        if (this.ival < bigInteger.ival) {
            BigInteger bigInteger3 = this;
            bigInteger2 = bigInteger;
            bigInteger = bigInteger3;
        }
        int n2 = bigInteger.isNegative() ? bigInteger2.ival : bigInteger.ival;
        int[] nArray = new int[n2];
        for (n = 0; n < bigInteger.ival; ++n) {
            nArray[n] = bigInteger2.words[n] & bigInteger.words[n];
        }
        while (n < n2) {
            nArray[n] = bigInteger2.words[n];
            ++n;
        }
        return BigInteger.make(nArray, n2);
    }

    public BigInteger or(BigInteger bigInteger) {
        return BigInteger.bitOp(7, this, bigInteger);
    }

    public BigInteger xor(BigInteger bigInteger) {
        return BigInteger.bitOp(6, this, bigInteger);
    }

    public BigInteger not() {
        return BigInteger.bitOp(12, this, ZERO);
    }

    public BigInteger andNot(BigInteger bigInteger) {
        return this.and(bigInteger.not());
    }

    public BigInteger clearBit(int n) {
        if (n < 0) {
            throw new ArithmeticException();
        }
        return this.and(ONE.shiftLeft(n).not());
    }

    public BigInteger setBit(int n) {
        if (n < 0) {
            throw new ArithmeticException();
        }
        return this.or(ONE.shiftLeft(n));
    }

    public boolean testBit(int n) {
        if (n < 0) {
            throw new ArithmeticException();
        }
        return this.and(ONE.shiftLeft(n)).isZero() ^ true;
    }

    public BigInteger flipBit(int n) {
        if (n < 0) {
            throw new ArithmeticException();
        }
        return this.xor(ONE.shiftLeft(n));
    }

    public int getLowestSetBit() {
        if (this.isZero()) {
            return -1;
        }
        if (this.words == null) {
            return MPN.findLowestBit(this.ival);
        }
        return MPN.findLowestBit(this.words);
    }

    private static int bitCount(int n) {
        int n2 = 0;
        while (n != 0) {
            n2 += bit4_count[n & 0xF];
            n >>>= 4;
        }
        return n2;
    }

    private static int bitCount(int[] nArray, int n) {
        int n2 = 0;
        while (--n >= 0) {
            n2 += BigInteger.bitCount(nArray[n]);
        }
        return n2;
    }

    public int bitCount() {
        int n;
        int n2;
        int[] nArray = this.words;
        if (nArray == null) {
            n2 = 1;
            n = BigInteger.bitCount(this.ival);
        } else {
            n2 = this.ival;
            n = BigInteger.bitCount(nArray, n2);
        }
        if (this.isNegative()) {
            return n2 * 32 - n;
        }
        return n;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.words = BigInteger.byteArrayToIntArray(this.magnitude, this.signum < 0 ? -1 : 0);
        BigInteger bigInteger = BigInteger.make(this.words, this.words.length);
        this.ival = bigInteger.ival;
        this.words = bigInteger.words;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws ClassNotFoundException, IOException {
        this.signum = this.signum();
        this.magnitude = this.toByteArray();
        objectOutputStream.defaultWriteObject();
    }

    static {
        int n = 1125;
        while (--n >= 0) {
            BigInteger.smallFixNums[n] = new BigInteger(n + -100);
        }
        ZERO = smallFixNums[100];
        ONE = smallFixNums[101];
        primes = new int[]{2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53, 59, 61, 67, 71, 73, 79, 83, 89, 97, 101, 103, 107, 109, 113, 127, 131, 137, 139, 149, 151, 157, 163, 167, 173, 179, 181, 191, 193, 197, 199, 211, 223, 227, 229, 233, 239, 241, 251};
        bit4_count = new byte[]{0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4};
    }
}

