/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import java.math.BigInteger;

public class BigDecimal
extends Number
implements Comparable {
    private BigInteger intVal;
    private int scale;
    private static final long serialVersionUID = 6108874887143696463L;
    private static final BigDecimal ZERO = new BigDecimal(BigInteger.valueOf(0L), 0);
    private static final BigDecimal ONE = new BigDecimal(BigInteger.valueOf(1L), 0);
    public static final int ROUND_UP = 0;
    public static final int ROUND_DOWN = 1;
    public static final int ROUND_CEILING = 2;
    public static final int ROUND_FLOOR = 3;
    public static final int ROUND_HALF_UP = 4;
    public static final int ROUND_HALF_DOWN = 5;
    public static final int ROUND_HALF_EVEN = 6;
    public static final int ROUND_UNNECESSARY = 7;

    public BigDecimal(BigInteger bigInteger) {
        this(bigInteger, 0);
    }

    public BigDecimal(BigInteger bigInteger, int n) {
        if (n < 0) {
            throw new NumberFormatException("scale of " + n + " is < 0");
        }
        this.intVal = bigInteger;
        this.scale = n;
    }

    public BigDecimal(double d) {
        this(Double.toString(d));
    }

    public BigDecimal(String string) {
        int n = string.indexOf(46);
        this.intVal = new BigInteger(n == -1 ? string : string.substring(0, n) + string.substring(n + 1));
        this.scale = string.length() - (n == -1 ? string.length() : n + 1);
    }

    public static BigDecimal valueOf(long l) {
        return BigDecimal.valueOf(l, 0);
    }

    public static BigDecimal valueOf(long l, int n) {
        if (n == 0) {
            switch ((int)l) {
                case 0: {
                    return ZERO;
                }
                case 1: {
                    return ONE;
                }
            }
        }
        return new BigDecimal(BigInteger.valueOf(l), n);
    }

    public BigDecimal add(BigDecimal bigDecimal) {
        BigInteger bigInteger = this.intVal;
        BigInteger bigInteger2 = bigDecimal.intVal;
        if (this.scale < bigDecimal.scale) {
            bigInteger = bigInteger.multiply(BigInteger.valueOf(10).pow(bigDecimal.scale - this.scale));
        } else if (this.scale > bigDecimal.scale) {
            bigInteger2 = bigInteger2.multiply(BigInteger.valueOf(10).pow(this.scale - bigDecimal.scale));
        }
        return new BigDecimal(bigInteger.add(bigInteger2), Math.max(this.scale, bigDecimal.scale));
    }

    public BigDecimal subtract(BigDecimal bigDecimal) {
        return this.add(bigDecimal.negate());
    }

    public BigDecimal multiply(BigDecimal bigDecimal) {
        return new BigDecimal(this.intVal.multiply(bigDecimal.intVal), this.scale + bigDecimal.scale);
    }

    public BigDecimal divide(BigDecimal bigDecimal, int n) {
        return this.divide(bigDecimal, this.scale, n);
    }

    public BigDecimal divide(BigDecimal bigDecimal, int n, int n2) {
        if (n2 < 0 || n2 > 7) {
            throw new IllegalArgumentException("illegal rounding mode: " + n2);
        }
        if (n < 0) {
            throw new ArithmeticException("scale is negative: " + n);
        }
        if (this.intVal.signum() == 0) {
            return ZERO;
        }
        int n3 = bigDecimal.scale;
        BigInteger bigInteger = bigDecimal.intVal;
        int n4 = n + 1 - (this.scale - bigDecimal.scale);
        if (n4 < 0) {
            bigInteger = bigInteger.multiply(BigInteger.valueOf(10).pow(-n4));
            n4 = 0;
        }
        BigInteger bigInteger2 = this.intVal.multiply(BigInteger.valueOf(10).pow(n4));
        BigInteger[] bigIntegerArray = bigInteger2.divideAndRemainder(bigInteger);
        int n5 = bigIntegerArray[0].mod(BigInteger.valueOf(10)).intValue();
        BigInteger bigInteger3 = bigIntegerArray[0].divide(BigInteger.valueOf(10));
        if (n5 == 0 && bigIntegerArray[1].signum() == 0) {
            return new BigDecimal(bigInteger3, n);
        }
        int n6 = bigInteger3.signum();
        switch (n2) {
            case 7: {
                throw new ArithmeticException("newScale is not large enough");
            }
            case 2: {
                n2 = n6 == 1 ? 0 : 1;
                break;
            }
            case 3: {
                n2 = n6 == 1 ? 1 : 0;
                break;
            }
            case 4: {
                n2 = n5 >= 5 ? 0 : 1;
                break;
            }
            case 5: {
                n2 = n5 > 5 ? 0 : 1;
                break;
            }
            case 6: {
                if (n5 < 5) {
                    n2 = 1;
                    break;
                }
                int n7 = bigInteger3.mod(BigInteger.valueOf(10)).intValue();
                if (n7 % 2 == 1) {
                    n2 = 0;
                    break;
                }
                int n8 = n2 = n5 > 5 ? 0 : 1;
            }
        }
        if (n2 == 0) {
            return new BigDecimal(bigInteger3.add(BigInteger.valueOf(1L)), n);
        }
        return new BigDecimal(bigInteger3, n);
    }

    public int compareTo(BigDecimal bigDecimal) {
        BigInteger[] bigIntegerArray;
        if (this.scale == bigDecimal.scale) {
            return this.intVal.compareTo(bigDecimal.intVal);
        }
        BigInteger[] bigIntegerArray2 = this.intVal.divideAndRemainder(BigInteger.valueOf(10).pow(this.scale));
        int n = bigIntegerArray2[0].compareTo((bigIntegerArray = bigDecimal.intVal.divideAndRemainder(BigInteger.valueOf(10).pow(bigDecimal.scale)))[0]);
        if (n != 0) {
            return n;
        }
        if (!bigIntegerArray2[1].equals(BigInteger.valueOf(0L))) {
            while (bigIntegerArray2[1].mod(BigInteger.valueOf(10)).equals(BigInteger.valueOf(0L))) {
                bigIntegerArray2[1] = bigIntegerArray2[1].divide(BigInteger.valueOf(10));
            }
        }
        if (!bigIntegerArray[1].equals(BigInteger.valueOf(0L))) {
            while (bigIntegerArray[1].mod(BigInteger.valueOf(10)).equals(BigInteger.valueOf(0L))) {
                bigIntegerArray[1] = bigIntegerArray[1].divide(BigInteger.valueOf(10));
            }
        }
        return bigIntegerArray2[1].compareTo(bigIntegerArray[1]);
    }

    public int compareTo(Object object) {
        return this.compareTo((BigDecimal)object);
    }

    public boolean equals(Object object) {
        return object instanceof BigDecimal && this.scale == ((BigDecimal)object).scale && this.compareTo((BigDecimal)object) == 0;
    }

    public int hashCode() {
        return this.intValue() ^ this.scale;
    }

    public BigDecimal max(BigDecimal bigDecimal) {
        if (this.compareTo(bigDecimal) == 1) {
            return this;
        }
        return bigDecimal;
    }

    public BigDecimal min(BigDecimal bigDecimal) {
        if (this.compareTo(bigDecimal) == -1) {
            return this;
        }
        return bigDecimal;
    }

    public BigDecimal movePointLeft(int n) {
        if (n < 0) {
            return this.movePointRight(-n);
        }
        return new BigDecimal(this.intVal, this.scale + n);
    }

    public BigDecimal movePointRight(int n) {
        if (n < 0) {
            return this.movePointLeft(-n);
        }
        if (this.scale >= n) {
            return new BigDecimal(this.intVal, this.scale - n);
        }
        return new BigDecimal(this.intVal.multiply(BigInteger.valueOf(10).pow(n - this.scale)), 0);
    }

    public int signum() {
        return this.intVal.signum();
    }

    public int scale() {
        return this.scale;
    }

    public BigDecimal abs() {
        return new BigDecimal(this.intVal.abs(), this.scale);
    }

    public BigDecimal negate() {
        return new BigDecimal(this.intVal.negate(), this.scale);
    }

    public String toString() {
        String string = this.intVal.toString();
        if (this.scale == 0) {
            return string;
        }
        int n = string.length() - this.scale;
        boolean bl = string.charAt(0) == '-';
        StringBuffer stringBuffer = new StringBuffer(string.length() + 1 + (n <= 0 ? -n + 1 : 0));
        if (bl) {
            stringBuffer.append('-');
        }
        while (n <= 0) {
            stringBuffer.append('0');
            ++n;
        }
        stringBuffer.append(string.substring(bl ? 1 : 0));
        stringBuffer.insert(n, '.');
        return stringBuffer.toString();
    }

    public BigInteger toBigInteger() {
        if (this.scale == 0) {
            return this.intVal;
        }
        return this.intVal.divide(BigInteger.valueOf(10).pow(this.scale));
    }

    public int intValue() {
        return this.toBigInteger().intValue();
    }

    public long longValue() {
        return this.toBigInteger().longValue();
    }

    public float floatValue() {
        return Float.valueOf(this.toString()).floatValue();
    }

    public double doubleValue() {
        return Double.valueOf(this.toString());
    }

    public BigDecimal setScale(int n) {
        return this.setScale(n, 7);
    }

    public BigDecimal setScale(int n, int n2) {
        return this.divide(ONE, n, n2);
    }
}

