/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;

public final class Method
extends AccessibleObject
implements Member {
    private Class declaringClass;
    private Class[] exception_types;
    private String name;
    private Class[] parameter_types;
    private Class return_type;
    private int offset;

    public boolean equals(Object object) {
        if (!(object instanceof Method)) {
            return false;
        }
        Method method = (Method)object;
        return this.declaringClass == method.declaringClass && this.offset == method.offset;
    }

    public Class getDeclaringClass() {
        return this.declaringClass;
    }

    public Class[] getExceptionTypes() {
        if (this.exception_types == null) {
            this.getType();
        }
        return (Class[])this.exception_types.clone();
    }

    public native int getModifiers();

    public native String getName();

    private native void getType();

    public Class[] getParameterTypes() {
        if (this.parameter_types == null) {
            this.getType();
        }
        return (Class[])this.parameter_types.clone();
    }

    public Class getReturnType() {
        if (this.return_type == null) {
            this.getType();
        }
        return this.return_type;
    }

    public int hashCode() {
        return this.getName().hashCode() + this.declaringClass.getName().hashCode();
    }

    public native Object invoke(Object var1, Object[] var2) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException;

    public String toString() {
        int n;
        if (this.parameter_types == null) {
            this.getType();
        }
        StringBuffer stringBuffer = new StringBuffer();
        Modifier.toString(this.getModifiers(), stringBuffer);
        stringBuffer.append(" ");
        stringBuffer.append(this.return_type.getName());
        stringBuffer.append(" ");
        stringBuffer.append(this.declaringClass.getName());
        stringBuffer.append(".");
        stringBuffer.append(this.getName());
        stringBuffer.append("(");
        for (n = 0; n < this.parameter_types.length; ++n) {
            stringBuffer.append(this.parameter_types[n].getName());
            if (n >= this.parameter_types.length - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(")");
        if (this.exception_types.length > 0) {
            stringBuffer.append(" throws ");
            for (n = 0; n < this.exception_types.length; ++n) {
                stringBuffer.append(this.exception_types[n].getName());
                if (n >= this.exception_types.length - 1) continue;
                stringBuffer.append(",");
            }
        }
        return stringBuffer.toString();
    }

    private Method() {
    }
}

