/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.util.Enumeration;
import java.util.Vector;

public class ThreadGroup {
    static ThreadGroup root = new ThreadGroup();
    static boolean had_uncaught_exception = false;
    private ThreadGroup parent;
    private String name;
    private Vector threads;
    private Vector groups;
    private boolean daemon_flag;
    private int maxpri;

    private /* synthetic */ void finit$() {
        this.threads = new Vector();
        this.groups = new Vector();
        this.daemon_flag = false;
        this.maxpri = 10;
    }

    private ThreadGroup() {
        this.finit$();
        this.name = "main";
    }

    public ThreadGroup(String string) {
        this(Thread.currentThread().getThreadGroup(), string);
    }

    public ThreadGroup(ThreadGroup threadGroup, String string) {
        this.finit$();
        threadGroup.checkAccess();
        this.parent = threadGroup;
        if (threadGroup.isDestroyed()) {
            throw new IllegalArgumentException();
        }
        this.name = string;
        this.maxpri = threadGroup.maxpri;
        this.daemon_flag = threadGroup.daemon_flag;
        threadGroup.addGroup(this);
    }

    public final String getName() {
        return this.name;
    }

    public final ThreadGroup getParent() {
        return this.parent;
    }

    public final synchronized void setMaxPriority(int n) {
        this.checkAccess();
        if (n < this.maxpri && n >= 1 && n <= 10) {
            this.maxpri = n;
        }
    }

    public final int getMaxPriority() {
        return this.maxpri;
    }

    public final void setDaemon(boolean bl) {
        this.checkAccess();
        this.daemon_flag = bl;
    }

    public final boolean isDaemon() {
        return this.daemon_flag;
    }

    public synchronized boolean isDestroyed() {
        return this.parent == null && this != root;
    }

    public final boolean parentOf(ThreadGroup threadGroup) {
        while (threadGroup != null) {
            if (threadGroup == this) {
                return true;
            }
            threadGroup = threadGroup.parent;
        }
        return false;
    }

    public synchronized int activeCount() {
        int n;
        int n2 = 0;
        for (n = 0; n < this.threads.size(); ++n) {
            if (!((Thread)this.threads.elementAt(n)).isAlive()) continue;
            ++n2;
        }
        for (n = 0; n < this.groups.size(); ++n) {
            ThreadGroup threadGroup = (ThreadGroup)this.groups.elementAt(n);
            n2 += threadGroup.activeCount();
        }
        return n2;
    }

    public synchronized int activeGroupCount() {
        int n = this.groups.size();
        for (int i = 0; i < this.groups.size(); ++i) {
            ThreadGroup threadGroup = (ThreadGroup)this.groups.elementAt(i);
            n += threadGroup.activeGroupCount();
        }
        return n;
    }

    public int enumerate(Thread[] threadArray) {
        return this.enumerate(threadArray, 0, true);
    }

    public int enumerate(Thread[] threadArray, boolean bl) {
        return this.enumerate(threadArray, 0, bl);
    }

    private synchronized int enumerate(Thread[] threadArray, int n, boolean bl) {
        Object object;
        Enumeration enumeration = this.threads.elements();
        while (enumeration.hasMoreElements() && n < threadArray.length) {
            object = (Thread)enumeration.nextElement();
            if (!((Thread)object).isAlive()) continue;
            threadArray[n++] = object;
        }
        if (bl && n != threadArray.length) {
            enumeration = this.groups.elements();
            while (enumeration.hasMoreElements() && n < threadArray.length) {
                object = (ThreadGroup)enumeration.nextElement();
                n = super.enumerate(threadArray, n, true);
            }
        }
        return n;
    }

    public int enumerate(ThreadGroup[] threadGroupArray) {
        return this.enumerate(threadGroupArray, 0, true);
    }

    public int enumerate(ThreadGroup[] threadGroupArray, boolean bl) {
        return this.enumerate(threadGroupArray, 0, bl);
    }

    private synchronized int enumerate(ThreadGroup[] threadGroupArray, int n, boolean bl) {
        Enumeration enumeration = this.groups.elements();
        while (enumeration.hasMoreElements() && n < threadGroupArray.length) {
            ThreadGroup threadGroup = (ThreadGroup)enumeration.nextElement();
            threadGroupArray[n++] = threadGroup;
            if (!bl || n == threadGroupArray.length) continue;
            n = threadGroup.enumerate(threadGroupArray, n, true);
        }
        return n;
    }

    public final synchronized void interrupt() {
        Object object;
        int n;
        this.checkAccess();
        for (n = 0; n < this.threads.size(); ++n) {
            object = (Thread)this.threads.elementAt(n);
            ((Thread)object).interrupt();
        }
        for (n = 0; n < this.groups.size(); ++n) {
            object = (ThreadGroup)this.groups.elementAt(n);
            ((ThreadGroup)object).interrupt();
        }
    }

    public final synchronized void stop() {
        Object object;
        int n;
        this.checkAccess();
        for (n = 0; n < this.threads.size(); ++n) {
            object = (Thread)this.threads.elementAt(n);
            ((Thread)object).stop();
        }
        for (n = 0; n < this.groups.size(); ++n) {
            object = (ThreadGroup)this.groups.elementAt(n);
            ((ThreadGroup)object).stop();
        }
    }

    public final synchronized void suspend() {
        Object object;
        int n;
        this.checkAccess();
        for (n = 0; n < this.threads.size(); ++n) {
            object = (Thread)this.threads.elementAt(n);
            ((Thread)object).suspend();
        }
        for (n = 0; n < this.groups.size(); ++n) {
            object = (ThreadGroup)this.groups.elementAt(n);
            ((ThreadGroup)object).suspend();
        }
    }

    public final synchronized void resume() {
        Object object;
        int n;
        this.checkAccess();
        for (n = 0; n < this.threads.size(); ++n) {
            object = (Thread)this.threads.elementAt(n);
            ((Thread)object).resume();
        }
        for (n = 0; n < this.groups.size(); ++n) {
            object = (ThreadGroup)this.groups.elementAt(n);
            ((ThreadGroup)object).resume();
        }
    }

    private synchronized void checkDestroy() {
        if (!this.threads.isEmpty()) {
            throw new IllegalThreadStateException("ThreadGroup has threads");
        }
        for (int i = 0; i < this.groups.size(); ++i) {
            ThreadGroup threadGroup = (ThreadGroup)this.groups.elementAt(i);
            threadGroup.checkDestroy();
        }
    }

    public final synchronized void destroy() {
        this.checkAccess();
        if (this.isDestroyed()) {
            throw new IllegalThreadStateException("Already destroyed.");
        }
        this.checkDestroy();
        if (this.parent != null) {
            this.parent.removeGroup(this);
        }
        this.parent = null;
        for (int i = 0; i < this.groups.size(); ++i) {
            ThreadGroup threadGroup = (ThreadGroup)this.groups.elementAt(i);
            threadGroup.destroy();
        }
    }

    public void list() {
        this.list("");
    }

    private synchronized void list(String string) {
        Object object;
        int n;
        System.out.print(string);
        System.out.println(this.toString());
        String string2 = string + "    ";
        for (n = 0; n < this.threads.size(); ++n) {
            object = (Thread)this.threads.elementAt(n);
            System.out.print(string2);
            System.out.println(((Thread)object).toString());
        }
        for (n = 0; n < this.groups.size(); ++n) {
            object = (ThreadGroup)this.groups.elementAt(n);
            super.list(string2);
        }
    }

    public void uncaughtException(Thread thread, Throwable throwable) {
        if (this.parent != null) {
            this.parent.uncaughtException(thread, throwable);
        } else if (!(throwable instanceof ThreadDeath)) {
            if (thread != null) {
                System.out.print("Exception in thread \"" + thread.getName() + "\" ");
            }
            try {
                throwable.printStackTrace();
            }
            catch (Throwable throwable2) {
                System.out.println(throwable);
                System.err.println("*** Got " + throwable2.toString() + " while trying to print stack trace");
            }
            had_uncaught_exception = true;
        }
    }

    public boolean allowThreadSuspension(boolean bl) {
        return false;
    }

    public String toString() {
        return "java.lang.ThreadGroup[name=" + this.name + ",maxpri=" + this.maxpri + "]";
    }

    public final void checkAccess() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkAccess(this);
        }
    }

    final synchronized void addThread(Thread thread) {
        if (this.isDestroyed()) {
            throw new IllegalThreadStateException("ThreadGroup is destroyed");
        }
        this.threads.addElement(thread);
    }

    final synchronized void removeThread(Thread thread) {
        if (this.isDestroyed()) {
            throw new IllegalThreadStateException();
        }
        this.threads.removeElement(thread);
        if (this.daemon_flag && this.groups.size() == 0 && this.threads.size() == 0) {
            if (this.parent != null) {
                this.parent.removeGroup(this);
            }
            this.parent = null;
        }
    }

    final synchronized void addGroup(ThreadGroup threadGroup) {
        this.groups.addElement(threadGroup);
    }

    final synchronized void removeGroup(ThreadGroup threadGroup) {
        this.groups.removeElement(threadGroup);
        if (this.daemon_flag && this.groups.size() == 0 && this.threads.size() == 0) {
            if (this.parent != null) {
                this.parent.removeGroup(this);
            }
            this.parent = null;
        }
    }

    static {
        had_uncaught_exception = false;
    }
}

