/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public class Thread
implements Runnable {
    public static final int MAX_PRIORITY = 10;
    public static final int MIN_PRIORITY = 1;
    public static final int NORM_PRIORITY = 5;
    private ThreadGroup group;
    private String name;
    private Runnable runnable;
    private int priority;
    private boolean daemon_flag;
    boolean interrupt_flag;
    private boolean alive_flag;
    private boolean startable_flag;
    private ClassLoader context_class_loader;
    private Object data;
    private static int nextThreadNumber = 0;

    public static int activeCount() {
        return Thread.currentThread().getThreadGroup().activeCount();
    }

    public final void checkAccess() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkAccess(this);
        }
    }

    public native int countStackFrames();

    public static native Thread currentThread();

    public native void destroy();

    public static void dumpStack() {
        new Exception("Stack trace").printStackTrace();
    }

    public static int enumerate(Thread[] threadArray) {
        return Thread.currentThread().group.enumerate(threadArray);
    }

    public final String getName() {
        return this.name;
    }

    public final int getPriority() {
        return this.priority;
    }

    public final ThreadGroup getThreadGroup() {
        return this.group;
    }

    public native void interrupt();

    public static boolean interrupted() {
        return Thread.currentThread().isInterrupted(true);
    }

    public boolean isInterrupted() {
        return this.interrupt_flag;
    }

    public final boolean isAlive() {
        return this.alive_flag;
    }

    public final boolean isDaemon() {
        return this.daemon_flag;
    }

    public final void join() throws InterruptedException {
        this.join(0L, 0);
    }

    public final void join(long l) throws InterruptedException {
        this.join(l, 0);
    }

    public final native void join(long var1, int var3) throws InterruptedException;

    public final native void resume();

    private static final native void run_(Object var0);

    private final native void finish_();

    private boolean isInterrupted(boolean bl) {
        boolean bl2 = this.interrupt_flag;
        if (bl && bl2) {
            this.interrupt_flag = false;
        }
        return bl2;
    }

    public void run() {
        if (this.runnable != null) {
            this.runnable.run();
        }
    }

    public final void setDaemon(boolean bl) {
        this.checkAccess();
        if (this.isAlive()) {
            throw new IllegalThreadStateException();
        }
        this.daemon_flag = bl;
    }

    public synchronized ClassLoader getContextClassLoader() {
        ClassLoader classLoader;
        if (this.context_class_loader == null) {
            this.context_class_loader = ClassLoader.getSystemClassLoader();
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && classLoader != null) {
            for (classLoader = null; classLoader != null && classLoader != this.context_class_loader; classLoader = classLoader.getParent()) {
            }
            if (classLoader != this.context_class_loader) {
                securityManager.checkPermission(new RuntimePermission("getClassLoader"));
            }
        }
        return this.context_class_loader;
    }

    public synchronized void setContextClassLoader(ClassLoader classLoader) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("setContextClassLoader"));
        }
        this.context_class_loader = classLoader;
    }

    public final void setName(String string) {
        this.checkAccess();
        if (string == null) {
            throw new NullPointerException();
        }
        this.name = string;
    }

    public final native void setPriority(int var1);

    public static void sleep(long l) throws InterruptedException {
        Thread.sleep(l, 0);
    }

    public static native void sleep(long var0, int var2) throws InterruptedException;

    public synchronized native void start();

    public final void stop() {
        this.stop(null);
    }

    public final synchronized native void stop(Throwable var1);

    public final native void suspend();

    private final native void initialize_native();

    private static final synchronized String gen_name() {
        String string = "Thread-" + nextThreadNumber;
        ++nextThreadNumber;
        return string;
    }

    public Thread(ThreadGroup threadGroup, Runnable runnable, String string) {
        Thread thread = Thread.currentThread();
        this.group = threadGroup == null ? (thread == null ? ThreadGroup.root : thread.getThreadGroup()) : threadGroup;
        this.group.checkAccess();
        if (string == null) {
            throw new NullPointerException();
        }
        this.name = string;
        this.group.addThread(this);
        this.runnable = runnable;
        this.data = null;
        this.interrupt_flag = false;
        this.alive_flag = false;
        this.startable_flag = true;
        if (thread != null) {
            int n;
            this.daemon_flag = thread.isDaemon();
            int n2 = this.group.getMaxPriority();
            this.priority = n2 < (n = thread.getPriority()) ? n2 : n;
            this.context_class_loader = thread.context_class_loader;
        } else {
            this.daemon_flag = false;
            this.priority = 5;
        }
        this.initialize_native();
    }

    public Thread() {
        this(null, null, Thread.gen_name());
    }

    public Thread(Runnable runnable) {
        this(null, runnable, Thread.gen_name());
    }

    public Thread(String string) {
        this(null, null, string);
    }

    public Thread(ThreadGroup threadGroup, Runnable runnable) {
        this(threadGroup, runnable, Thread.gen_name());
    }

    public Thread(ThreadGroup threadGroup, String string) {
        this(threadGroup, null, string);
    }

    public Thread(Runnable runnable, String string) {
        this(null, runnable, string);
    }

    public String toString() {
        return "Thread[" + this.name + "," + this.priority + "," + (this.group == null ? "" : this.group.getName()) + "]";
    }

    public static native void yield();
}

