/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;

public final class StringBuffer
implements Serializable {
    int count;
    char[] value;
    boolean shared;
    static final long serialVersionUID = 3388685877147921107L;
    private static final int DEFAULT_CAPACITY = 16;

    public StringBuffer append(boolean bl) {
        return this.append(String.valueOf(bl));
    }

    public synchronized StringBuffer append(char c) {
        this.ensureCapacity_unsynchronized(this.count + 1);
        this.value[this.count++] = c;
        return this;
    }

    public StringBuffer append(int n) {
        return this.append(String.valueOf(n));
    }

    public StringBuffer append(long l) {
        return this.append(String.valueOf(l));
    }

    public StringBuffer append(float f) {
        return this.append(String.valueOf(f));
    }

    public StringBuffer append(double d) {
        return this.append(String.valueOf(d));
    }

    public StringBuffer append(Object object) {
        return this.append(String.valueOf(object));
    }

    public synchronized StringBuffer append(String string) {
        if (string == null) {
            string = "null";
        }
        int n = string.length();
        this.ensureCapacity_unsynchronized(this.count + n);
        string.getChars(0, n, this.value, this.count);
        this.count += n;
        return this;
    }

    public StringBuffer append(char[] cArray) {
        return this.append(cArray, 0, cArray.length);
    }

    public synchronized StringBuffer append(char[] cArray, int n, int n2) {
        this.ensureCapacity_unsynchronized(this.count + n2);
        System.arraycopy(cArray, n, this.value, this.count, n2);
        this.count += n2;
        return this;
    }

    public int capacity() {
        return this.value.length;
    }

    public synchronized char charAt(int n) {
        if (n >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        return this.value[n];
    }

    public synchronized StringBuffer delete(int n, int n2) {
        if (n < 0 || n > this.count || n > n2) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this.count) {
            n2 = this.count;
        }
        this.ensureCapacity_unsynchronized(this.count);
        if (this.count - n2 != 0) {
            System.arraycopy(this.value, n2, this.value, n, this.count - n2);
        }
        this.count -= n2 - n;
        return this;
    }

    public StringBuffer deleteCharAt(int n) {
        return this.delete(n, n + 1);
    }

    public synchronized void ensureCapacity(int n) {
        if (this.shared || n > this.value.length) {
            int n2 = n > this.value.length ? this.value.length * 2 + 2 : this.value.length;
            n = n < n2 ? n2 : n;
            char[] cArray = new char[n];
            System.arraycopy(this.value, 0, cArray, 0, this.count);
            this.value = cArray;
            this.shared = false;
        }
    }

    private void ensureCapacity_unsynchronized(int n) {
        if (this.shared || n > this.value.length) {
            int n2 = n > this.value.length ? this.value.length * 2 + 2 : this.value.length;
            n = n < n2 ? n2 : n;
            char[] cArray = new char[n];
            System.arraycopy(this.value, 0, cArray, 0, this.count);
            this.value = cArray;
            this.shared = false;
        }
    }

    public synchronized void getChars(int n, int n2, char[] cArray, int n3) {
        if (n < 0 || n > n2) {
            throw new StringIndexOutOfBoundsException(n);
        }
        int n4 = n2 - n;
        if (n2 > this.count || n3 + n4 > this.count) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        System.arraycopy(this.value, n, cArray, n3, n4);
    }

    public StringBuffer insert(int n, boolean bl) {
        return this.insert(n, bl ? "true" : "false");
    }

    public synchronized StringBuffer insert(int n, char c) {
        if (n < 0 || n > this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        this.ensureCapacity_unsynchronized(this.count + 1);
        System.arraycopy(this.value, n, this.value, n + 1, this.count - n);
        this.value[n] = c;
        ++this.count;
        return this;
    }

    public StringBuffer insert(int n, int n2) {
        return this.insert(n, String.valueOf(n2));
    }

    public StringBuffer insert(int n, long l) {
        return this.insert(n, String.valueOf(l));
    }

    public StringBuffer insert(int n, float f) {
        return this.insert(n, String.valueOf(f));
    }

    public StringBuffer insert(int n, double d) {
        return this.insert(n, String.valueOf(d));
    }

    public StringBuffer insert(int n, Object object) {
        return this.insert(n, String.valueOf(object));
    }

    public synchronized StringBuffer insert(int n, String string) {
        if (n < 0 || n > this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (string == null) {
            string = "null";
        }
        int n2 = string.length();
        this.ensureCapacity_unsynchronized(this.count + n2);
        System.arraycopy(this.value, n, this.value, n + n2, this.count - n);
        string.getChars(0, n2, this.value, n);
        this.count += n2;
        return this;
    }

    public StringBuffer insert(int n, char[] cArray) {
        return this.insert(n, cArray, 0, cArray == null ? 0 : cArray.length);
    }

    public synchronized StringBuffer insert(int n, char[] cArray, int n2, int n3) {
        if (n < 0 || n > this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n3 < 0) {
            throw new StringIndexOutOfBoundsException(n3);
        }
        if (n2 < 0 || n2 + n3 > cArray.length) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        this.ensureCapacity_unsynchronized(this.count + n3);
        System.arraycopy(this.value, n, this.value, n + n3, this.count - n);
        System.arraycopy(cArray, n2, this.value, n, n3);
        this.count += n3;
        return this;
    }

    public int length() {
        return this.count;
    }

    public synchronized StringBuffer replace(int n, int n2, String string) {
        if (n < 0 || n > this.count || n > n2) {
            throw new StringIndexOutOfBoundsException(n);
        }
        int n3 = string.length();
        int n4 = n3 - ((n2 > this.count ? this.count : n2) - n);
        this.ensureCapacity_unsynchronized(this.count + n4);
        if (n4 != 0 && n2 < this.count) {
            System.arraycopy(this.value, n2, this.value, n2 + n4, this.count - n2);
        }
        string.getChars(0, n3, this.value, n);
        this.count += n4;
        return this;
    }

    public synchronized StringBuffer reverse() {
        this.ensureCapacity_unsynchronized(this.count);
        for (int i = 0; i < this.count / 2; ++i) {
            char c = this.value[i];
            this.value[i] = this.value[this.count - i - 1];
            this.value[this.count - i - 1] = c;
        }
        return this;
    }

    public synchronized void setCharAt(int n, char c) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        this.ensureCapacity_unsynchronized(this.count);
        this.value[n] = c;
    }

    public synchronized void setLength(int n) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        this.ensureCapacity_unsynchronized(n);
        for (int i = this.count; i < n; ++i) {
            this.value[i] = '\u0000';
        }
        this.count = n;
    }

    public StringBuffer() {
        this(16);
    }

    public StringBuffer(int n) {
        this.count = 0;
        this.value = new char[n];
        this.shared = false;
    }

    public StringBuffer(String string) {
        this.count = string.length();
        this.value = new char[this.count + 16];
        string.getChars(0, this.count, this.value, 0);
        this.shared = false;
    }

    public String substring(int n) {
        return this.substring(n, this.count);
    }

    public synchronized String substring(int n, int n2) {
        if (n < 0 || n2 > this.count || n > n2) {
            throw new StringIndexOutOfBoundsException();
        }
        return new String(this.value, n, n2 - n);
    }

    public String toString() {
        return new String(this);
    }
}

