/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Long
extends Number
implements Comparable {
    public static final long MAX_VALUE = 0x7FFFFFFFFFFFFFFFL;
    public static final long MIN_VALUE = -9223372036854775808L;
    public static final Class TYPE;
    private long value;
    private static final long serialVersionUID = 4290774380558885855L;

    public Long(long l) {
        this.value = l;
    }

    public Long(String string) {
        this.value = Long.parseLong(string, 10);
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public int intValue() {
        return (int)this.value;
    }

    public long longValue() {
        return this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public int compareTo(Long l) {
        if (this.value == l.value) {
            return 0;
        }
        if (this.value > l.value) {
            return 1;
        }
        return -1;
    }

    public int compareTo(Object object) {
        return this.compareTo((Long)object);
    }

    public static Long decode(String string) {
        boolean bl = false;
        int n = 0;
        int n2 = 10;
        int n3 = string.length();
        if (n3 == 0) {
            throw new NumberFormatException();
        }
        if (string.charAt(0) == '-') {
            n2 = 10;
            ++n;
            bl = true;
        } else if (string.charAt(n) == '#') {
            n2 = 16;
            ++n;
        } else if (string.charAt(n) == '0') {
            if (n3 == 1) {
                return new Long(0L);
            }
            if (string.charAt(++n) == 'x') {
                n2 = 16;
                ++n;
            } else {
                n2 = 8;
            }
        }
        if (n >= n3) {
            throw new NumberFormatException();
        }
        return new Long(Long.parseLong(string, n, n3, bl, n2));
    }

    public boolean equals(Object object) {
        return object instanceof Long && ((Long)object).value == this.value;
    }

    public static Long getLong(String string) {
        return Long.getLong(string, null);
    }

    public static Long getLong(String string, long l) {
        Long l2 = Long.getLong(string, null);
        if (l2 == null) {
            return new Long(l);
        }
        return l2;
    }

    public static Long getLong(String string, Long l) {
        try {
            String string2 = System.getProperty(string);
            if (string2 != null) {
                return Long.decode(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return l;
    }

    public int hashCode() {
        return (int)this.longValue() ^ (int)(this >>> 32);
    }

    public static long parseLong(String string) {
        return Long.parseLong(string, 10);
    }

    public static long parseLong(String string, int n) {
        int n2 = string.length();
        if (n2 == 0 || n < 2 || n > 36) {
            throw new NumberFormatException();
        }
        boolean bl = false;
        int n3 = 0;
        if (string.charAt(n3) == '-') {
            if (n2 > 1) {
                bl = true;
                ++n3;
            } else {
                throw new NumberFormatException();
            }
        }
        return Long.parseLong(string, n3, n2, bl, n);
    }

    private static long parseLong(String string, int n, int n2, boolean bl, int n3) {
        long l = 0L;
        long l2 = Long.MAX_VALUE / (long)n3;
        if (bl && Long.MAX_VALUE % (long)n3 == (long)(n3 - 1)) {
            ++l2;
        }
        while (n < n2) {
            if (l < 0L || l > l2) {
                throw new NumberFormatException();
            }
            int n4 = Character.digit(string.charAt(n), n3);
            if (n4 < 0) {
                throw new NumberFormatException();
            }
            if (!((l = l * (long)n3 + (long)n4) >= 0L || bl && l == Long.MIN_VALUE)) {
                throw new NumberFormatException();
            }
            ++n;
        }
        if (bl) {
            return -l;
        }
        return l;
    }

    public static String toBinaryString(long l) {
        return Long.toUnsignedString(l, 1);
    }

    public static String toHexString(long l) {
        return Long.toUnsignedString(l, 4);
    }

    public static String toOctalString(long l) {
        return Long.toUnsignedString(l, 3);
    }

    private static String toUnsignedString(long l, int n) {
        int n2 = 1 << (n & 0x1F);
        long l2 = n2 - 1;
        char[] cArray = new char[64];
        int n3 = 64;
        do {
            cArray[--n3] = Character.forDigit((int)l & (int)l2, n2);
        } while ((l >>>= n & 0x3F) != 0L);
        return String.valueOf(cArray, n3, 64 - n3);
    }

    public String toString() {
        return Long.toString(this.value);
    }

    public static String toString(long l) {
        boolean bl;
        if (l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
            return Integer.toString((int)l);
        }
        char[] cArray = new char[20];
        int n = 20;
        if (l < 0L) {
            bl = true;
            if ((l = -l) < 0L) {
                cArray[--n] = 56;
                l = 0xCCCCCCCCCCCCCCCL;
            }
        } else {
            bl = false;
        }
        do {
            cArray[--n] = (char)((long)48 + l % (long)10);
        } while ((l /= (long)10) > 0L);
        if (bl) {
            cArray[--n] = 45;
        }
        return String.valueOf(cArray, n, 20 - n);
    }

    public static String toString(long l, int n) {
        boolean bl;
        if (n == 10 || n < 2 || n > 36) {
            return Long.toString(l);
        }
        if (l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
            return Integer.toString((int)l, n);
        }
        char[] cArray = new char[65];
        int n2 = 65;
        if (l < 0L) {
            bl = true;
            if ((l = -l) < 0L) {
                cArray[--n2] = Character.forDigit((int)(-(l + (long)n) % (long)n), n);
                l = -(l / (long)n);
            }
        } else {
            bl = false;
        }
        do {
            cArray[--n2] = Character.forDigit((int)(l % (long)n), n);
        } while ((l /= (long)n) > 0L);
        if (bl) {
            cArray[--n2] = 45;
        }
        return String.valueOf(cArray, n2, 65 - n2);
    }

    public static Long valueOf(String string) {
        return new Long(Long.parseLong(string, 10));
    }

    public static Long valueOf(String string, int n) {
        return new Long(Long.parseLong(string, n));
    }
}

