/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Integer
extends Number
implements Comparable {
    public static final int MAX_VALUE = 0x7FFFFFFF;
    public static final int MIN_VALUE = -2147483648;
    public static final Class TYPE;
    private int value;
    private static final long serialVersionUID = 1360826667806852920L;

    public Integer(int n) {
        this.value = n;
    }

    public Integer(String string) {
        this.value = Integer.parseInt(string, 10);
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public int intValue() {
        return this.value;
    }

    public long longValue() {
        return this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public int compareTo(Integer n) {
        if (this.value == n.value) {
            return 0;
        }
        if (this.value > n.value) {
            return 1;
        }
        return -1;
    }

    public int compareTo(Object object) {
        return this.compareTo((Integer)object);
    }

    public static Integer decode(String string) {
        boolean bl = false;
        int n = 0;
        int n2 = 10;
        int n3 = string.length();
        if (n3 == 0) {
            throw new NumberFormatException();
        }
        if (string.charAt(0) == '-') {
            n2 = 10;
            ++n;
            bl = true;
        } else if (string.charAt(n) == '#') {
            n2 = 16;
            ++n;
        } else if (string.charAt(n) == '0') {
            if (n3 == 1) {
                return new Integer(0);
            }
            if (string.charAt(++n) == 'x') {
                n2 = 16;
                ++n;
            } else {
                n2 = 8;
            }
        }
        if (n >= n3) {
            throw new NumberFormatException();
        }
        return new Integer(Integer.parseInt(string, n, n3, bl, n2));
    }

    public boolean equals(Object object) {
        return object instanceof Integer && ((Integer)object).value == this.value;
    }

    public static Integer getInteger(String string) {
        return Integer.getInteger(string, null);
    }

    public static Integer getInteger(String string, int n) {
        Integer n2 = Integer.getInteger(string, null);
        if (n2 == null) {
            return new Integer(n);
        }
        return n2;
    }

    public static Integer getInteger(String string, Integer n) {
        try {
            String string2 = System.getProperty(string);
            if (string2 != null) {
                return Integer.decode(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    public int hashCode() {
        return this.value;
    }

    public static int parseInt(String string) {
        return Integer.parseInt(string, 10);
    }

    public static int parseInt(String string, int n) {
        int n2 = string.length();
        if (n2 == 0 || n < 2 || n > 36) {
            throw new NumberFormatException();
        }
        boolean bl = false;
        int n3 = 0;
        if (string.charAt(n3) == '-') {
            if (n2 > 1) {
                bl = true;
                ++n3;
            } else {
                throw new NumberFormatException();
            }
        }
        return Integer.parseInt(string, n3, n2, bl, n);
    }

    private static int parseInt(String string, int n, int n2, boolean bl, int n3) {
        int n4 = 0;
        int n5 = Integer.MAX_VALUE / n3;
        if (bl && Integer.MAX_VALUE % n3 == n3 - 1) {
            ++n5;
        }
        while (n < n2) {
            if (n4 < 0 || n4 > n5) {
                throw new NumberFormatException();
            }
            int n6 = Character.digit(string.charAt(n), n3);
            if (n6 < 0) {
                throw new NumberFormatException();
            }
            if (!((n4 = n4 * n3 + n6) >= 0 || bl && n4 == Integer.MIN_VALUE)) {
                throw new NumberFormatException();
            }
            ++n;
        }
        if (bl) {
            return -n4;
        }
        return n4;
    }

    public static String toBinaryString(int n) {
        return Integer.toUnsignedString(n, 1);
    }

    public static String toHexString(int n) {
        return Integer.toUnsignedString(n, 4);
    }

    public static String toOctalString(int n) {
        return Integer.toUnsignedString(n, 3);
    }

    private static String toUnsignedString(int n, int n2) {
        int n3 = 1 << (n2 & 0x1F);
        int n4 = n3 - 1;
        char[] cArray = new char[32];
        int n5 = 32;
        do {
            cArray[--n5] = Character.forDigit(n & n4, n3);
        } while ((n >>>= n2 & 0x1F) != 0);
        return String.valueOf(cArray, n5, 32 - n5);
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    public static String toString(int n) {
        boolean bl;
        char[] cArray = new char[11];
        int n2 = 11;
        if (n < 0) {
            bl = true;
            if ((n = -n) < 0) {
                cArray[--n2] = 56;
                n = 0xCCCCCCC;
            }
        } else {
            bl = false;
        }
        do {
            cArray[--n2] = (char)(48 + n % 10);
        } while ((n /= 10) > 0);
        if (bl) {
            cArray[--n2] = 45;
        }
        return String.valueOf(cArray, n2, 11 - n2);
    }

    public static String toString(int n, int n2) {
        boolean bl;
        if (n2 == 10 || n2 < 2 || n2 > 36) {
            return Integer.toString(n);
        }
        char[] cArray = new char[33];
        int n3 = 33;
        if (n < 0) {
            bl = true;
            if ((n = -n) < 0) {
                cArray[--n3] = Character.forDigit(-(n + n2) % n2, n2);
                n = -(n / n2);
            }
        } else {
            bl = false;
        }
        do {
            cArray[--n3] = Character.forDigit(n % n2, n2);
        } while ((n /= n2) > 0);
        if (bl) {
            cArray[--n3] = 45;
        }
        return String.valueOf(cArray, n3, 33 - n3);
    }

    public static Integer valueOf(String string) {
        return new Integer(Integer.parseInt(string, 10));
    }

    public static Integer valueOf(String string, int n) {
        return new Integer(Integer.parseInt(string, n));
    }
}

