/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Float
extends Number
implements Comparable {
    public static final float MAX_VALUE = 3.4028235E38f;
    public static final float MIN_VALUE = 1.4E-45f;
    public static final float NEGATIVE_INFINITY = -1.0f / 0.0f;
    public static final float POSITIVE_INFINITY = 1.0f / 0.0f;
    public static final float NaN = 0.0f / 0.0f;
    public static final Class TYPE;
    private float value;
    private static final long serialVersionUID = -2671257302660747028L;

    public Float(float f) {
        this.value = f;
    }

    public Float(double d) {
        this.value = (float)d;
    }

    public Float(String string) {
        this.value = Float.valueOf(string).floatValue();
    }

    public static float parseFloat(String string) {
        return (float)Double.parseDouble(string);
    }

    public String toString() {
        return Float.toString(this.value);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Float)) {
            return false;
        }
        Float f = (Float)object;
        return Float.floatToIntBits(this.value) == Float.floatToIntBits(f.floatValue());
    }

    public int hashCode() {
        return Float.floatToIntBits(this.value);
    }

    public int intValue() {
        return (int)this.value;
    }

    public long longValue() {
        return (long)this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public static String toString(float f) {
        return Double.toString(f, true);
    }

    public static Float valueOf(String string) {
        return new Float(Double.valueOf(string).floatValue());
    }

    public boolean isNaN() {
        return Float.isNaN(this.value);
    }

    public static boolean isNaN(float f) {
        int n = Float.floatToIntBits(f);
        int n2 = n & 0x7F800000;
        int n3 = n & 0x7FFFFF;
        return n2 == 2139095040 && n3 != 0;
    }

    public boolean isInfinite() {
        return Float.isInfinite(this.value);
    }

    public static boolean isInfinite(float f) {
        int n = Float.floatToIntBits(f);
        int n2 = n & Integer.MAX_VALUE;
        return n2 == 2139095040;
    }

    public static native int floatToIntBits(float var0);

    public static native int floatToRawIntBits(float var0);

    public static native float intBitsToFloat(int var0);

    public int compareTo(Float f) {
        float f2 = f.value;
        if (Float.isNaN(this.value)) {
            if (Float.isNaN(f2)) {
                return 1;
            }
            return 0;
        }
        if (Float.isNaN(f2)) {
            return -1;
        }
        if ((double)this.value == 0.0 && (double)f2 == 0.0) {
            return 1;
        }
        if ((double)this.value == 0.0 && (double)f2 == 0.0) {
            return -1;
        }
        if (this.value == f2) {
            return 0;
        }
        if (this.value > f2) {
            return 1;
        }
        return -1;
    }

    public int compareTo(Object object) {
        return this.compareTo((Float)object);
    }
}

