/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Double
extends Number
implements Comparable {
    public static final double MIN_VALUE = 4.9E-324;
    public static final double MAX_VALUE = 1.7976931348623157E308;
    public static final double NEGATIVE_INFINITY = -1.0 / 0.0;
    public static final double POSITIVE_INFINITY = 1.0 / 0.0;
    public static final double NaN = 0.0 / 0.0;
    public static final Class TYPE;
    private double value;
    private static final long serialVersionUID = -9172774392245257468L;

    public static native double parseDouble(String var0) throws NumberFormatException;

    public Double(double d) {
        this.value = d;
    }

    public Double(String string) {
        this.value = Double.valueOf(string);
    }

    public String toString() {
        return Double.toString(this.value);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Double)) {
            return false;
        }
        Double d = (Double)object;
        return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(d);
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.value);
        return (int)l ^ (int)(l >>> 32);
    }

    public int intValue() {
        return (int)this.value;
    }

    public long longValue() {
        return (long)this.value;
    }

    public float floatValue() {
        return (float)this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    static native String toString(double var0, boolean var2);

    public static String toString(double d) {
        return Double.toString(d, false);
    }

    public static Double valueOf(String string) {
        return new Double(Double.parseDouble(string));
    }

    public boolean isNaN() {
        return Double.isNaN(this.value);
    }

    public static boolean isNaN(double d) {
        long l = Double.doubleToLongBits(d);
        long l2 = l & 0x7FF0000000000000L;
        long l3 = l & 0xFFFFFFFFFFFFFL;
        return l2 == 0x7FF0000000000000L && l3 != 0L;
    }

    public boolean isInfinite() {
        return Double.isInfinite(this.value);
    }

    public static boolean isInfinite(double d) {
        long l = Double.doubleToLongBits(d);
        long l2 = l & Long.MAX_VALUE;
        return l2 == 0x7FF0000000000000L;
    }

    public static native long doubleToLongBits(double var0);

    public static native long doubleToRawLongBits(double var0);

    public static native double longBitsToDouble(long var0);

    public int compareTo(Double d) {
        double d2 = d.value;
        if (Double.isNaN(this.value)) {
            if (Double.isNaN(d2)) {
                return 1;
            }
            return 0;
        }
        if (Double.isNaN(d2)) {
            return -1;
        }
        if (this.value == 0.0 && d2 == 0.0) {
            return 1;
        }
        if (this.value == 0.0 && d2 == 0.0) {
            return -1;
        }
        if (this.value == d2) {
            return 0;
        }
        if (this.value > d2) {
            return 1;
        }
        return -1;
    }

    public int compareTo(Object object) {
        return this.compareTo((Double)object);
    }
}

