/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import gnu.gcj.runtime.VMClassLoader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;

public abstract class ClassLoader {
    private static ClassLoader system;
    private ClassLoader parent;

    public final ClassLoader getParent() {
        return this.parent;
    }

    public static ClassLoader getSystemClassLoader() {
        if (system == null) {
            system = VMClassLoader.instance;
        }
        return system;
    }

    protected ClassLoader() {
        this(null);
    }

    protected ClassLoader(ClassLoader classLoader) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        this.parent = classLoader;
    }

    public Class loadClass(String string) throws ClassNotFoundException {
        return this.loadClass(string, false);
    }

    protected Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class clazz = this.findLoadedClass(string);
        if (clazz == null) {
            try {
                if (this.parent != null) {
                    return this.parent.loadClass(string, bl);
                }
                clazz = system.findClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clazz == null) {
            clazz = this.findClass(string);
        }
        if (clazz == null) {
            throw new ClassNotFoundException(string);
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        throw new ClassNotFoundException(string);
    }

    protected final Class defineClass(byte[] byArray, int n, int n2) {
        return this.defineClass(null, byArray, n, n2);
    }

    protected final synchronized Class defineClass(String string, byte[] byArray, int n, int n2) {
        if (byArray == null || byArray.length < n + n2 || n < 0 || n2 < 0) {
            throw new ClassFormatError("arguments to defineClass are meaningless");
        }
        if (string != null && this.findLoadedClass(string) != null) {
            throw new LinkageError("class " + string + " already loaded");
        }
        try {
            return this.defineClass0(string, byArray, n, n2);
        }
        catch (ClassFormatError classFormatError) {
            throw classFormatError;
        }
        catch (VirtualMachineError virtualMachineError) {
            throw virtualMachineError;
        }
        catch (Throwable throwable) {
            throw new InternalError("Unexpected exception while defining class " + string + ": " + throwable.toString());
        }
    }

    private native Class defineClass0(String var1, byte[] var2, int var3, int var4) throws ClassFormatError;

    protected final void resolveClass(Class clazz) {
        ClassLoader.resolveClass0(clazz);
    }

    static void resolveClass0(Class clazz) {
        Class clazz2 = clazz;
        synchronized (clazz2) {
            try {
                try {
                    ClassLoader.linkClass0(clazz);
                }
                catch (Throwable throwable) {
                    ClassLoader.markClassErrorState0(clazz);
                    if (throwable instanceof Error) {
                        throw (Error)throwable;
                    }
                    throw new InternalError("unexpected exception during linking: " + throwable);
                }
                Object var3_4 = null;
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                throw throwable;
            }
        }
    }

    private static native void linkClass0(Class var0);

    private static native void markClassErrorState0(Class var0);

    protected final Class findSystemClass(String string) throws ClassNotFoundException {
        return ClassLoader.getSystemClassLoader().loadClass(string);
    }

    protected final void setSigners(Class clazz, Object[] objectArray) {
    }

    protected final native Class findLoadedClass(String var1);

    public static InputStream getSystemResourceAsStream(String string) {
        return ClassLoader.getSystemClassLoader().getResourceAsStream(string);
    }

    public static URL getSystemResource(String string) {
        return ClassLoader.getSystemClassLoader().getResource(string);
    }

    public InputStream getResourceAsStream(String string) {
        try {
            URL uRL = this.getResource(string);
            if (uRL == null) {
                return null;
            }
            return uRL.openStream();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public URL getResource(String string) {
        URL uRL = null;
        ClassLoader classLoader = this.parent;
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        if (this != classLoader) {
            uRL = classLoader.getResource(string);
        }
        if (uRL != null) {
            return uRL;
        }
        return this.findResource(string);
    }

    protected URL findResource(String string) {
        return null;
    }

    public final Enumeration getResources(String string) throws IOException {
        Enumeration enumeration = null;
        ClassLoader classLoader = this.parent;
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        if (this != classLoader) {
            enumeration = classLoader.getResources(string);
        }
        if (enumeration != null) {
            return enumeration;
        }
        return this.findResources(string);
    }

    protected Enumeration findResources(String string) throws IOException {
        return null;
    }
}

