/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;

public final class Character
implements Serializable,
Comparable {
    public static final char MIN_VALUE = '\u0000';
    public static final char MAX_VALUE = '\uffff';
    public static final int MIN_RADIX = 2;
    public static final int MAX_RADIX = 36;
    public static final Class TYPE;
    public static final byte SPACE_SEPARATOR = 12;
    public static final byte LINE_SEPARATOR = 13;
    public static final byte PARAGRAPH_SEPARATOR = 14;
    public static final byte UPPERCASE_LETTER = 1;
    public static final byte LOWERCASE_LETTER = 2;
    public static final byte TITLECASE_LETTER = 3;
    public static final byte MODIFIER_LETTER = 4;
    public static final byte OTHER_LETTER = 5;
    public static final byte DECIMAL_DIGIT_NUMBER = 9;
    public static final byte LETTER_NUMBER = 10;
    public static final byte OTHER_NUMBER = 11;
    public static final byte NON_SPACING_MARK = 6;
    public static final byte ENCLOSING_MARK = 7;
    public static final byte COMBINING_SPACING_MARK = 8;
    public static final byte DASH_PUNCTUATION = 20;
    public static final byte START_PUNCTUATION = 21;
    public static final byte END_PUNCTUATION = 22;
    public static final byte CONNECTOR_PUNCTUATION = 23;
    public static final byte OTHER_PUNCTUATION = 24;
    public static final byte MATH_SYMBOL = 25;
    public static final byte CURRENCY_SYMBOL = 26;
    public static final byte MODIFIER_SYMBOL = 27;
    public static final byte OTHER_SYMBOL = 28;
    public static final byte CONTROL = 15;
    public static final byte FORMAT = 16;
    public static final byte UNASSIGNED = 0;
    public static final byte PRIVATE_USE = 18;
    public static final byte SURROGATE = 19;
    private static final long serialVersionUID = 3786198910865385080L;
    private char value;

    public Character(char c) {
        this.value = c;
    }

    public char charValue() {
        return this.value;
    }

    private static native int digit_value(char var0);

    public static int digit(char c, int n) {
        if (n < 2 || n > 36) {
            return -1;
        }
        int n2 = Character.digit_value(c);
        if (n2 == -1) {
            if (c >= 'A' && c <= 'Z') {
                n2 = c - 65 + 10;
            } else if (c >= 'a' && c <= 'z') {
                n2 = c - 97 + 10;
            } else {
                return -1;
            }
        }
        if (n2 >= n) {
            return -1;
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (object instanceof Character) {
            return this.value == ((Character)object).value;
        }
        return false;
    }

    public static char forDigit(int n, int n2) {
        if (n < 0 || n >= n2 || n2 < 2 || n2 > 36) {
            return '\u0000';
        }
        if (n < 10) {
            return (char)(48 + n);
        }
        return (char)(97 + n - 10);
    }

    public static native int getNumericValue(char var0);

    public static native int getType(char var0);

    public int hashCode() {
        return this.value;
    }

    public static boolean isDefined(char c) {
        return Character.getType(c) != 0;
    }

    public static boolean isDigit(char c) {
        return Character.digit_value(c) != -1;
    }

    public static boolean isIdentifierIgnorable(char c) {
        return c <= '\b' || c > '\r' && c <= '\u001b' || c > '~' && c <= '\u009f' || c > '\u200b' && c <= '\u200f' || c > '\u2029' && c <= '\u202e' || c > '\u2069' && c <= '\u206f' || c == '\ufeff';
    }

    public static boolean isISOControl(char c) {
        return c <= '\u001f' || c > '~' && c <= '\u009f';
    }

    public static boolean isJavaIdentifierPart(char c) {
        if (Character.isIdentifierIgnorable(c) || Character.isDigit(c)) {
            return true;
        }
        int n = Character.getType(c);
        return n == 8 || n == 6 || n == 26 || n == 23 || n == 1 || n == 2 || n == 3 || n == 4 || n == 5 || n == 10;
    }

    public static boolean isJavaIdentifierStart(char c) {
        int n = Character.getType(c);
        return n == 26 || n == 23 || n == 1 || n == 2 || n == 3 || n == 4 || n == 5;
    }

    public static boolean isJavaLetter(char c) {
        return c == '$' || c == '_' || Character.isLetter(c);
    }

    public static boolean isJavaLetterOrDigit(char c) {
        return c == '$' || c == '_' || Character.isLetterOrDigit(c);
    }

    public static boolean isLetter(char c) {
        int n = Character.getType(c);
        return n == 1 || n == 2 || n == 3 || n == 4 || n == 5;
    }

    public static boolean isLetterOrDigit(char c) {
        return Character.isDigit(c) || Character.isLetter(c);
    }

    public static native boolean isLowerCase(char var0);

    public static boolean isSpace(char c) {
        return c == '\n' || c == '\t' || c == '\f' || c == '\r' || c == ' ';
    }

    public static native boolean isSpaceChar(char var0);

    public static native boolean isTitleCase(char var0);

    public static boolean isUnicodeIdentifierPart(char c) {
        if (Character.isIdentifierIgnorable(c) || Character.isDigit(c)) {
            return true;
        }
        int n = Character.getType(c);
        return n == 23 || n == 10 || n == 8 || n == 6 || n == 1 || n == 2 || n == 3 || n == 4 || n == 5;
    }

    public static boolean isUnicodeIdentifierStart(char c) {
        return Character.isLetter(c);
    }

    public static native boolean isUpperCase(char var0);

    public static boolean isWhitespace(char c) {
        return c > '\b' && c <= '\r' || c > '\u001b' && c <= '\u001f' || c != '\u00a0' && c != '\ufeff' && Character.isSpaceChar(c);
    }

    public static native char toLowerCase(char var0);

    public static native char toTitleCase(char var0);

    public static native char toUpperCase(char var0);

    public String toString() {
        return String.valueOf(this.value);
    }

    public int compareTo(Character c) {
        return this.value - c.value;
    }

    public int compareTo(Object object) {
        return this.compareTo((Character)object);
    }

    public static final class UnicodeBlock
    extends Subset {
        private char start;
        private char end;
        public static final UnicodeBlock BASIC_LATIN = new UnicodeBlock("Basic Latin", '\u0000', '\u007f');
        public static final UnicodeBlock LATIN_1_SUPPLEMENT = new UnicodeBlock("Latin-1 Supplement", '\u0080', '\u00ff');
        public static final UnicodeBlock LATIN_EXTENDED_A = new UnicodeBlock("Latin Extended-A", '\u0100', '\u017f');
        public static final UnicodeBlock LATIN_EXTENDED_B = new UnicodeBlock("Latin Extended-B", '\u0180', '\u024f');
        public static final UnicodeBlock IPA_EXTENSIONS = new UnicodeBlock("IPA Extensions", '\u0250', '\u02af');
        public static final UnicodeBlock SPACING_MODIFIER_LETTERS = new UnicodeBlock("Spacing Modifier Letters", '\u02b0', '\u02ff');
        public static final UnicodeBlock COMBINING_DIACRITICAL_MARKS = new UnicodeBlock("Combining Diacritical Marks", '\u0300', '\u036f');
        public static final UnicodeBlock GREEK = new UnicodeBlock("Greek", '\u0370', '\u03ff');
        public static final UnicodeBlock CYRILLIC = new UnicodeBlock("Cyrillic", '\u0400', '\u04ff');
        public static final UnicodeBlock ARMENIAN = new UnicodeBlock("Armenian", '\u0530', '\u058f');
        public static final UnicodeBlock HEBREW = new UnicodeBlock("Hebrew", '\u0590', '\u05ff');
        public static final UnicodeBlock ARABIC = new UnicodeBlock("Arabic", '\u0600', '\u06ff');
        public static final UnicodeBlock SYRIAC__ = new UnicodeBlock("Syriac  ", '\u0700', '\u074f');
        public static final UnicodeBlock THAANA = new UnicodeBlock("Thaana", '\u0780', '\u07bf');
        public static final UnicodeBlock DEVANAGARI = new UnicodeBlock("Devanagari", '\u0900', '\u097f');
        public static final UnicodeBlock BENGALI = new UnicodeBlock("Bengali", '\u0980', '\u09ff');
        public static final UnicodeBlock GURMUKHI = new UnicodeBlock("Gurmukhi", '\u0a00', '\u0a7f');
        public static final UnicodeBlock GUJARATI = new UnicodeBlock("Gujarati", '\u0a80', '\u0aff');
        public static final UnicodeBlock ORIYA = new UnicodeBlock("Oriya", '\u0b00', '\u0b7f');
        public static final UnicodeBlock TAMIL = new UnicodeBlock("Tamil", '\u0b80', '\u0bff');
        public static final UnicodeBlock TELUGU = new UnicodeBlock("Telugu", '\u0c00', '\u0c7f');
        public static final UnicodeBlock KANNADA = new UnicodeBlock("Kannada", '\u0c80', '\u0cff');
        public static final UnicodeBlock MALAYALAM = new UnicodeBlock("Malayalam", '\u0d00', '\u0d7f');
        public static final UnicodeBlock SINHALA = new UnicodeBlock("Sinhala", '\u0d80', '\u0dff');
        public static final UnicodeBlock THAI = new UnicodeBlock("Thai", '\u0e00', '\u0e7f');
        public static final UnicodeBlock LAO = new UnicodeBlock("Lao", '\u0e80', '\u0eff');
        public static final UnicodeBlock TIBETAN = new UnicodeBlock("Tibetan", '\u0f00', '\u0fff');
        public static final UnicodeBlock MYANMAR_ = new UnicodeBlock("Myanmar ", '\u1000', '\u109f');
        public static final UnicodeBlock GEORGIAN = new UnicodeBlock("Georgian", '\u10a0', '\u10ff');
        public static final UnicodeBlock HANGUL_JAMO = new UnicodeBlock("Hangul Jamo", '\u1100', '\u11ff');
        public static final UnicodeBlock ETHIOPIC = new UnicodeBlock("Ethiopic", '\u1200', '\u137f');
        public static final UnicodeBlock CHEROKEE = new UnicodeBlock("Cherokee", '\u13a0', '\u13ff');
        public static final UnicodeBlock UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS = new UnicodeBlock("Unified Canadian Aboriginal Syllabics", '\u1400', '\u167f');
        public static final UnicodeBlock OGHAM = new UnicodeBlock("Ogham", '\u1680', '\u169f');
        public static final UnicodeBlock RUNIC = new UnicodeBlock("Runic", '\u16a0', '\u16ff');
        public static final UnicodeBlock KHMER = new UnicodeBlock("Khmer", '\u1780', '\u17ff');
        public static final UnicodeBlock MONGOLIAN = new UnicodeBlock("Mongolian", '\u1800', '\u18af');
        public static final UnicodeBlock LATIN_EXTENDED_ADDITIONAL = new UnicodeBlock("Latin Extended Additional", '\u1e00', '\u1eff');
        public static final UnicodeBlock GREEK_EXTENDED = new UnicodeBlock("Greek Extended", '\u1f00', '\u1fff');
        public static final UnicodeBlock GENERAL_PUNCTUATION = new UnicodeBlock("General Punctuation", '\u2000', '\u206f');
        public static final UnicodeBlock SUPERSCRIPTS_AND_SUBSCRIPTS = new UnicodeBlock("Superscripts and Subscripts", '\u2070', '\u209f');
        public static final UnicodeBlock CURRENCY_SYMBOLS = new UnicodeBlock("Currency Symbols", '\u20a0', '\u20cf');
        public static final UnicodeBlock COMBINING_MARKS_FOR_SYMBOLS = new UnicodeBlock("Combining Marks for Symbols", '\u20d0', '\u20ff');
        public static final UnicodeBlock LETTERLIKE_SYMBOLS = new UnicodeBlock("Letterlike Symbols", '\u2100', '\u214f');
        public static final UnicodeBlock NUMBER_FORMS = new UnicodeBlock("Number Forms", '\u2150', '\u218f');
        public static final UnicodeBlock ARROWS = new UnicodeBlock("Arrows", '\u2190', '\u21ff');
        public static final UnicodeBlock MATHEMATICAL_OPERATORS = new UnicodeBlock("Mathematical Operators", '\u2200', '\u22ff');
        public static final UnicodeBlock MISCELLANEOUS_TECHNICAL = new UnicodeBlock("Miscellaneous Technical", '\u2300', '\u23ff');
        public static final UnicodeBlock CONTROL_PICTURES = new UnicodeBlock("Control Pictures", '\u2400', '\u243f');
        public static final UnicodeBlock OPTICAL_CHARACTER_RECOGNITION = new UnicodeBlock("Optical Character Recognition", '\u2440', '\u245f');
        public static final UnicodeBlock ENCLOSED_ALPHANUMERICS = new UnicodeBlock("Enclosed Alphanumerics", '\u2460', '\u24ff');
        public static final UnicodeBlock BOX_DRAWING = new UnicodeBlock("Box Drawing", '\u2500', '\u257f');
        public static final UnicodeBlock BLOCK_ELEMENTS = new UnicodeBlock("Block Elements", '\u2580', '\u259f');
        public static final UnicodeBlock GEOMETRIC_SHAPES = new UnicodeBlock("Geometric Shapes", '\u25a0', '\u25ff');
        public static final UnicodeBlock MISCELLANEOUS_SYMBOLS = new UnicodeBlock("Miscellaneous Symbols", '\u2600', '\u26ff');
        public static final UnicodeBlock DINGBATS = new UnicodeBlock("Dingbats", '\u2700', '\u27bf');
        public static final UnicodeBlock BRAILLE_PATTERNS = new UnicodeBlock("Braille Patterns", '\u2800', '\u28ff');
        public static final UnicodeBlock CJK_RADICALS_SUPPLEMENT = new UnicodeBlock("CJK Radicals Supplement", '\u2e80', '\u2eff');
        public static final UnicodeBlock KANGXI_RADICALS = new UnicodeBlock("Kangxi Radicals", '\u2f00', '\u2fdf');
        public static final UnicodeBlock IDEOGRAPHIC_DESCRIPTION_CHARACTERS = new UnicodeBlock("Ideographic Description Characters", '\u2ff0', '\u2fff');
        public static final UnicodeBlock CJK_SYMBOLS_AND_PUNCTUATION = new UnicodeBlock("CJK Symbols and Punctuation", '\u3000', '\u303f');
        public static final UnicodeBlock HIRAGANA = new UnicodeBlock("Hiragana", '\u3040', '\u309f');
        public static final UnicodeBlock KATAKANA = new UnicodeBlock("Katakana", '\u30a0', '\u30ff');
        public static final UnicodeBlock BOPOMOFO = new UnicodeBlock("Bopomofo", '\u3100', '\u312f');
        public static final UnicodeBlock HANGUL_COMPATIBILITY_JAMO = new UnicodeBlock("Hangul Compatibility Jamo", '\u3130', '\u318f');
        public static final UnicodeBlock KANBUN = new UnicodeBlock("Kanbun", '\u3190', '\u319f');
        public static final UnicodeBlock BOPOMOFO_EXTENDED = new UnicodeBlock("Bopomofo Extended", '\u31a0', '\u31bf');
        public static final UnicodeBlock ENCLOSED_CJK_LETTERS_AND_MONTHS = new UnicodeBlock("Enclosed CJK Letters and Months", '\u3200', '\u32ff');
        public static final UnicodeBlock CJK_COMPATIBILITY = new UnicodeBlock("CJK Compatibility", '\u3300', '\u33ff');
        public static final UnicodeBlock CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A = new UnicodeBlock("CJK Unified Ideographs Extension A", '\u3400', '\u4db5');
        public static final UnicodeBlock CJK_UNIFIED_IDEOGRAPHS = new UnicodeBlock("CJK Unified Ideographs", '\u4e00', '\u9fff');
        public static final UnicodeBlock YI_SYLLABLES = new UnicodeBlock("Yi Syllables", '\ua000', '\ua48f');
        public static final UnicodeBlock YI_RADICALS = new UnicodeBlock("Yi Radicals", '\ua490', '\ua4cf');
        public static final UnicodeBlock HANGUL_SYLLABLES = new UnicodeBlock("Hangul Syllables", '\uac00', '\ud7a3');
        public static final UnicodeBlock SURROGATES_AREA = new UnicodeBlock("Surrogates Area", '\ud800', '\udfff');
        public static final UnicodeBlock PRIVATE_USE_AREA = new UnicodeBlock("Private Use Area", '\ue000', '\uf8ff');
        public static final UnicodeBlock CJK_COMPATIBILITY_IDEOGRAPHS = new UnicodeBlock("CJK Compatibility Ideographs", '\uf900', '\ufaff');
        public static final UnicodeBlock ALPHABETIC_PRESENTATION_FORMS = new UnicodeBlock("Alphabetic Presentation Forms", '\ufb00', '\ufb4f');
        public static final UnicodeBlock ARABIC_PRESENTATION_FORMS_A = new UnicodeBlock("Arabic Presentation Forms-A", '\ufb50', '\ufdff');
        public static final UnicodeBlock COMBINING_HALF_MARKS = new UnicodeBlock("Combining Half Marks", '\ufe20', '\ufe2f');
        public static final UnicodeBlock CJK_COMPATIBILITY_FORMS = new UnicodeBlock("CJK Compatibility Forms", '\ufe30', '\ufe4f');
        public static final UnicodeBlock SMALL_FORM_VARIANTS = new UnicodeBlock("Small Form Variants", '\ufe50', '\ufe6f');
        public static final UnicodeBlock ARABIC_PRESENTATION_FORMS_B = new UnicodeBlock("Arabic Presentation Forms-B", '\ufe70', '\ufefe');
        public static final UnicodeBlock HALFWIDTH_AND_FULLWIDTH_FORMS = new UnicodeBlock("Halfwidth and Fullwidth Forms", '\uff00', '\uffef');
        public static final UnicodeBlock SPECIALS = new UnicodeBlock("Specials", '\ufff0', '\ufffd');
        private static final UnicodeBlock[] blocks = new UnicodeBlock[]{BASIC_LATIN, LATIN_1_SUPPLEMENT, LATIN_EXTENDED_A, LATIN_EXTENDED_B, IPA_EXTENSIONS, SPACING_MODIFIER_LETTERS, COMBINING_DIACRITICAL_MARKS, GREEK, CYRILLIC, ARMENIAN, HEBREW, ARABIC, SYRIAC__, THAANA, DEVANAGARI, BENGALI, GURMUKHI, GUJARATI, ORIYA, TAMIL, TELUGU, KANNADA, MALAYALAM, SINHALA, THAI, LAO, TIBETAN, MYANMAR_, GEORGIAN, HANGUL_JAMO, ETHIOPIC, CHEROKEE, UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS, OGHAM, RUNIC, KHMER, MONGOLIAN, LATIN_EXTENDED_ADDITIONAL, GREEK_EXTENDED, GENERAL_PUNCTUATION, SUPERSCRIPTS_AND_SUBSCRIPTS, CURRENCY_SYMBOLS, COMBINING_MARKS_FOR_SYMBOLS, LETTERLIKE_SYMBOLS, NUMBER_FORMS, ARROWS, MATHEMATICAL_OPERATORS, MISCELLANEOUS_TECHNICAL, CONTROL_PICTURES, OPTICAL_CHARACTER_RECOGNITION, ENCLOSED_ALPHANUMERICS, BOX_DRAWING, BLOCK_ELEMENTS, GEOMETRIC_SHAPES, MISCELLANEOUS_SYMBOLS, DINGBATS, BRAILLE_PATTERNS, CJK_RADICALS_SUPPLEMENT, KANGXI_RADICALS, IDEOGRAPHIC_DESCRIPTION_CHARACTERS, CJK_SYMBOLS_AND_PUNCTUATION, HIRAGANA, KATAKANA, BOPOMOFO, HANGUL_COMPATIBILITY_JAMO, KANBUN, BOPOMOFO_EXTENDED, ENCLOSED_CJK_LETTERS_AND_MONTHS, CJK_COMPATIBILITY, CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A, CJK_UNIFIED_IDEOGRAPHS, YI_SYLLABLES, YI_RADICALS, HANGUL_SYLLABLES, SURROGATES_AREA, PRIVATE_USE_AREA, CJK_COMPATIBILITY_IDEOGRAPHS, ALPHABETIC_PRESENTATION_FORMS, ARABIC_PRESENTATION_FORMS_A, COMBINING_HALF_MARKS, CJK_COMPATIBILITY_FORMS, SMALL_FORM_VARIANTS, ARABIC_PRESENTATION_FORMS_B, HALFWIDTH_AND_FULLWIDTH_FORMS, SPECIALS};

        private UnicodeBlock(String string, char c, char c2) {
            super(string);
            this.start = c;
            this.end = c2;
        }

        public static UnicodeBlock of(char c) {
            if (c == '\ufeff') {
                return SPECIALS;
            }
            int n = blocks.length;
            int n2 = 0;
            while (n > n2) {
                int n3 = (n + n2) / 2;
                UnicodeBlock unicodeBlock = blocks[n3];
                if (c < unicodeBlock.start) {
                    n = n3;
                    continue;
                }
                if (c > unicodeBlock.end) {
                    n2 = n3;
                    continue;
                }
                return unicodeBlock;
            }
            return null;
        }
    }

    public static class Subset {
        private String name;

        protected Subset(String string) {
            this.name = string;
        }

        public final boolean equals(Object object) {
            return object == this;
        }

        public final int hashCode() {
            return super.hashCode();
        }

        public final String toString() {
            return this.name;
        }
    }
}

