/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class RandomAccessFile
implements DataOutput,
DataInput {
    private FileDescriptor fd;
    private DataOutputStream out;
    private DataInputStream in;

    public void close() throws IOException {
        if (this.fd.valid()) {
            this.fd.close();
        }
    }

    public final FileDescriptor getFD() throws IOException {
        if (!this.fd.valid()) {
            throw new IOException();
        }
        return this.fd;
    }

    public long getFilePointer() throws IOException {
        return this.fd.getFilePointer();
    }

    public long length() throws IOException {
        return this.fd.length();
    }

    public RandomAccessFile(String string, String string2) throws IOException {
        int n;
        if (string2.compareTo("r") == 0) {
            n = 1;
        } else if (string2.compareTo("rw") == 0) {
            n = 3;
        } else {
            throw new IllegalArgumentException("invalid mode: " + string2);
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(string);
            if ((n & 2) != 0) {
                securityManager.checkWrite(string);
            }
        }
        this.fd = new FileDescriptor(string, n);
        this.out = new DataOutputStream(new FileOutputStream(this.fd));
        this.in = new DataInputStream(new FileInputStream(this.fd));
    }

    public RandomAccessFile(File file, String string) throws IOException {
        this(file.getPath(), string);
    }

    public int read() throws IOException {
        return this.in.read();
    }

    public int read(byte[] byArray) throws IOException {
        return this.in.read(byArray);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.in.read(byArray, n, n2);
    }

    public final boolean readBoolean() throws IOException {
        return this.in.readBoolean();
    }

    public final byte readByte() throws IOException {
        return this.in.readByte();
    }

    public final char readChar() throws IOException {
        return this.in.readChar();
    }

    public final double readDouble() throws IOException {
        return this.in.readDouble();
    }

    public final float readFloat() throws IOException {
        return this.in.readFloat();
    }

    public final void readFully(byte[] byArray) throws IOException {
        this.in.readFully(byArray);
    }

    public final void readFully(byte[] byArray, int n, int n2) throws IOException {
        this.in.readFully(byArray, n, n2);
    }

    public final int readInt() throws IOException {
        return this.in.readInt();
    }

    public final String readLine() throws IOException {
        return this.in.readLine();
    }

    public final long readLong() throws IOException {
        return this.in.readLong();
    }

    public final short readShort() throws IOException {
        return this.in.readShort();
    }

    public final int readUnsignedByte() throws IOException {
        return this.in.readUnsignedByte();
    }

    public final int readUnsignedShort() throws IOException {
        return this.in.readUnsignedShort();
    }

    public final String readUTF() throws IOException {
        return this.in.readUTF();
    }

    public void seek(long l) throws IOException {
        this.fd.seek(l, 0);
    }

    public int skipBytes(int n) throws IOException {
        return this.fd.seek(n, 1);
    }

    public void write(int n) throws IOException {
        this.out.write(n);
    }

    public void write(byte[] byArray) throws IOException {
        this.out.write(byArray);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
    }

    public final void writeBoolean(boolean bl) throws IOException {
        this.out.writeBoolean(bl);
    }

    public final void writeByte(int n) throws IOException {
        this.out.writeByte(n);
    }

    public final void writeShort(int n) throws IOException {
        this.out.writeShort(n);
    }

    public final void writeChar(int n) throws IOException {
        this.out.writeChar(n);
    }

    public final void writeInt(int n) throws IOException {
        this.out.writeInt(n);
    }

    public final void writeLong(long l) throws IOException {
        this.out.writeLong(l);
    }

    public final void writeFloat(float f) throws IOException {
        this.out.writeFloat(f);
    }

    public final void writeDouble(double d) throws IOException {
        this.out.writeDouble(d);
    }

    public final void writeBytes(String string) throws IOException {
        this.out.writeBytes(string);
    }

    public final void writeChars(String string) throws IOException {
        this.out.writeChars(string);
    }

    public final void writeUTF(String string) throws IOException {
        this.out.writeUTF(string);
    }
}

