/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PushbackInputStream
extends FilterInputStream {
    protected byte[] buf;
    protected int pos;

    public PushbackInputStream(InputStream inputStream) {
        this(inputStream, 1);
    }

    public PushbackInputStream(InputStream inputStream, int n) {
        super(inputStream);
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.buf = new byte[n];
        this.pos = this.buf.length;
    }

    public int available() throws IOException {
        return this.pos + super.available();
    }

    public void close() throws IOException {
        this.buf = null;
        super.close();
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        if (this.pos < this.buf.length) {
            return this.buf[this.pos++] & 0xFF;
        }
        return super.read();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n3 = Math.min(this.buf.length - this.pos, n2);
        if (n3 > 0) {
            System.arraycopy(this.buf, this.pos, byArray, n, n3);
            this.pos += n3;
            return n3;
        }
        return super.read(byArray, n, n2);
    }

    public void unread(int n) throws IOException {
        if (this.pos <= 0) {
            throw new IOException();
        }
        this.buf[this.pos += -1] = (byte)n;
    }

    public void unread(byte[] byArray) throws IOException {
        this.unread(byArray, 0, byArray.length);
    }

    public void unread(byte[] byArray, int n, int n2) throws IOException {
        if (this.pos < n2) {
            throw new IOException();
        }
        System.arraycopy(byArray, n, this.buf, this.pos - n2, n2);
        this.pos -= n2;
    }

    public long skip(long l) throws IOException {
        long l2 = l;
        if (l > 0L) {
            int n = (int)Math.min((long)(this.buf.length - this.pos), l);
            this.pos += n;
            l -= (long)n;
            l -= super.skip(l);
        }
        return l2 - l;
    }
}

